/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.popupeditors;

import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.popupeditors.PopupEditor;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import java.util.Set;
import javafx.fxml.FXML;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;

public class BoundsPopupEditor
extends PopupEditor {
    @FXML
    Label minX;
    @FXML
    Label minY;
    @FXML
    Label minZ;
    @FXML
    Label maxX;
    @FXML
    Label maxY;
    @FXML
    Label maxZ;
    @FXML
    Label width;
    @FXML
    Label height;
    @FXML
    Label depth;
    private Parent root;
    private Bounds bounds;

    public BoundsPopupEditor(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses) {
        super(propMeta, selectedClasses);
    }

    @Override
    public void initializePopupContent() {
        this.root = EditorUtils.loadPopupFxml("BoundsPopupEditor.fxml", this);
    }

    @Override
    public String getPreviewString(Object value) {
        assert (value instanceof Bounds);
        Bounds boundsVal = (Bounds)value;
        Object valueAsString = this.isIndeterminate() ? "-" : EditorUtils.valAsStr(boundsVal.getMinX()) + "," + EditorUtils.valAsStr(boundsVal.getMinY()) + "  " + EditorUtils.valAsStr(boundsVal.getWidth()) + "x" + EditorUtils.valAsStr(boundsVal.getHeight());
        return valueAsString;
    }

    @Override
    public void setPopupContentValue(Object value) {
        if (value == null) {
            this.bounds = null;
            this.updateValues();
        } else {
            assert (value instanceof Bounds);
            this.bounds = (Bounds)value;
            this.updateValues();
        }
    }

    @Override
    public Node getPopupContentNode() {
        return this.root;
    }

    private void updateValues() {
        this.minX.setText(EditorUtils.valAsStr(this.bounds != null ? Double.valueOf(this.bounds.getMinX()) : ""));
        this.minY.setText(EditorUtils.valAsStr(this.bounds != null ? Double.valueOf(this.bounds.getMinY()) : ""));
        this.minZ.setText(EditorUtils.valAsStr(this.bounds != null ? Double.valueOf(this.bounds.getMinZ()) : ""));
        this.maxX.setText(EditorUtils.valAsStr(this.bounds != null ? Double.valueOf(this.bounds.getMaxX()) : ""));
        this.maxY.setText(EditorUtils.valAsStr(this.bounds != null ? Double.valueOf(this.bounds.getMaxY()) : ""));
        this.maxZ.setText(EditorUtils.valAsStr(this.bounds != null ? Double.valueOf(this.bounds.getMaxZ()) : ""));
        this.width.setText(EditorUtils.valAsStr(this.bounds != null ? Double.valueOf(this.bounds.getWidth()) : ""));
        this.height.setText(EditorUtils.valAsStr(this.bounds != null ? Double.valueOf(this.bounds.getHeight()) : ""));
        this.depth.setText(EditorUtils.valAsStr(this.bounds != null ? Double.valueOf(this.bounds.getDepth()) : ""));
    }
}

