/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.popupeditors;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.AutoSuggestEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.BoundedDoubleEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.popupeditors.PopupEditor;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Control;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Font;

public class FontPopupEditor
extends PopupEditor {
    @FXML
    private StackPane familySp;
    @FXML
    private StackPane styleSp;
    @FXML
    private StackPane sizeSp;
    private Parent root;
    private Font font = Font.getDefault();
    private FamilyEditor familyEditor;
    private StyleEditor styleEditor;
    private BoundedDoubleEditor sizeEditor;
    private EditorController editorController;
    private static WeakReference<Map<String, Map<String, Font>>> fontCache = new WeakReference<Object>(null);
    private static volatile Map<String, String> pathologicalFonts = null;
    private static final Comparator<Font> fontComparator = (t, t1) -> {
        int cmp = t.getName().compareTo(t1.getName());
        if (cmp != 0) {
            return cmp;
        }
        return t.toString().compareTo(t1.toString());
    };

    public FontPopupEditor(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses, EditorController editorController) {
        super(propMeta, selectedClasses);
        this.initialize(editorController);
    }

    private void initialize(EditorController editorController) {
        this.editorController = editorController;
    }

    private void setStyle() {
        this.styleEditor.reset("", "", new ArrayList<String>(FontPopupEditor.getStyles(EditorUtils.toString(this.familyEditor.getValue()), false, this.editorController)));
        this.styleEditor.setUpdateFromModel(true);
        this.styleEditor.setValue(this.font.getStyle());
        this.styleEditor.setUpdateFromModel(false);
    }

    private void commit() {
        if (this.isUpdateFromModel()) {
            return;
        }
        this.font = this.getFont();
        assert (this.font != null);
        this.commitValue(this.font);
    }

    private Font getFont() {
        Font oldFont = this.font;
        Object sizeObj = this.sizeEditor.getValue();
        assert (sizeObj instanceof Double);
        Font newFont = FontPopupEditor.getFont(EditorUtils.toString(this.familyEditor.getValue()), EditorUtils.toString(this.styleEditor.getValue()), (Double)sizeObj, this.editorController);
        if (newFont != null) {
            return newFont;
        }
        return oldFont;
    }

    @Override
    public Object getValue() {
        return this.font;
    }

    public void reset(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses, EditorController editorController) {
        super.reset(propMeta, selectedClasses);
        this.editorController = editorController;
    }

    @Override
    public void initializePopupContent() {
        this.root = EditorUtils.loadPopupFxml("FontPopupEditor.fxml", this);
        this.familyEditor = new FamilyEditor("", "", FontPopupEditor.getFamilies(this.editorController), this.editorController);
        this.familySp.getChildren().add((Object)this.familyEditor.getValueEditor());
        this.styleEditor = new StyleEditor("", "", new ArrayList<String>(), this.editorController);
        this.styleSp.getChildren().add((Object)this.styleEditor.getValueEditor());
        this.sizeEditor = new BoundedDoubleEditor("", "", FontPopupEditor.getPredefinedFontSizes(), 1.0, 96.0, true);
        FontPopupEditor.commitOnFocusLost(this.sizeEditor);
        this.sizeSp.getChildren().add((Object)this.sizeEditor.getValueEditor());
        this.familyEditor.valueProperty().addListener((ov, oldVal, newVal) -> {
            if (this.familyEditor.isUpdateFromModel()) {
                return;
            }
            this.commit();
            this.setStyle();
        });
        this.styleEditor.valueProperty().addListener((ov, oldVal, newVal) -> {
            if (this.styleEditor.isUpdateFromModel()) {
                return;
            }
            this.commit();
        });
        this.sizeEditor.valueProperty().addListener((ov, oldVal, newVal) -> {
            if (this.sizeEditor.isUpdateFromModel()) {
                return;
            }
            this.commit();
        });
        this.sizeEditor.transientValueProperty().addListener((ov, oldVal, newVal) -> this.transientValue(this.getFont()));
    }

    @Override
    public String getPreviewString(Object value) {
        assert (value instanceof Font);
        Font fontVal = (Font)value;
        if (this.isIndeterminate()) {
            return "-";
        }
        String size = EditorUtils.valAsStr(fontVal.getSize());
        return fontVal.getFamily() + " " + size + "px" + (String)(!fontVal.getName().equals(fontVal.getFamily()) && !"Regular".equals(fontVal.getStyle()) ? " (" + fontVal.getStyle() + ")" : "");
    }

    @Override
    public void setPopupContentValue(Object value) {
        assert (value instanceof Font);
        this.font = (Font)value;
        this.familyEditor.setUpdateFromModel(true);
        this.familyEditor.setValue(this.font.getFamily());
        this.familyEditor.setUpdateFromModel(false);
        this.setStyle();
        this.sizeEditor.setUpdateFromModel(true);
        this.sizeEditor.setValue(this.font.getSize());
        this.sizeEditor.setUpdateFromModel(false);
    }

    @Override
    public Node getPopupContentNode() {
        return this.root;
    }

    private static void commitOnFocusLost(AutoSuggestEditor autoSuggestEditor) {
        autoSuggestEditor.getTextField().focusedProperty().addListener((ov, oldVal, newVal) -> {
            if (!newVal.booleanValue()) {
                autoSuggestEditor.getCommitListener().handle(null);
            }
        });
    }

    public static Set<Font> getAllFonts() {
        Font f = Font.getDefault();
        double defSize = f.getSize();
        TreeSet<Font> allFonts = new TreeSet<Font>(fontComparator);
        for (String familly : Font.getFamilies()) {
            for (String name : Font.getFontNames((String)familly)) {
                Font font = new Font(name, defSize);
                allFonts.add(font);
            }
        }
        for (String name : Font.getFontNames()) {
            Font font = new Font(name, defSize);
            allFonts.add(font);
        }
        return allFonts;
    }

    public static List<String> getFamilies(EditorController editorController) {
        return new ArrayList<String>(FontPopupEditor.getFontMap(editorController).keySet());
    }

    public static Set<String> getStyles(String family, boolean canBeUnknown, EditorController editorController) {
        Map<String, Object> styles = FontPopupEditor.getFontMap(editorController).get(family);
        if (styles == null) {
            assert (!canBeUnknown);
            styles = Collections.emptyMap();
        }
        return styles.keySet();
    }

    public static Font getFont(String family, String style, EditorController editorController) {
        Map<String, Object> styles = FontPopupEditor.getFontMap(editorController).get(family);
        if (styles == null) {
            styles = Collections.emptyMap();
        }
        if (styles.get(style) == null) {
            style = styles.keySet().iterator().next();
        }
        return (Font)styles.get(style);
    }

    public static Font getFont(String family, String style, double size, EditorController editorController) {
        Font font = FontPopupEditor.getFont(family, style, editorController);
        if (font == null) {
            return null;
        }
        return FontPopupEditor.getFont(font, size);
    }

    public static Font getFont(Font font, double size) {
        if (font == null) {
            assert (false);
            font = Font.getDefault();
        }
        if (Math.abs(font.getSize() - size) < 1.0E-7) {
            return font;
        }
        return new Font(FontPopupEditor.getPersistentName(font), size);
    }

    public static Map<String, String> getPathologicalFonts() {
        if (pathologicalFonts == null) {
            double size = Font.getDefault().getSize();
            String defaultName = Font.getDefault().getName();
            HashMap<String, String> problems = new HashMap<String, String>();
            HashSet allNames = new HashSet(Font.getFontNames());
            for (String familly : Font.getFamilies()) {
                allNames.addAll(Font.getFontNames((String)familly));
            }
            for (String name : allNames) {
                Font f2;
                Font f = new Font(name, size);
                if (f.getName().equals(name) || f.getName().equals(defaultName) || f.getName().equals("System") || (f2 = new Font(f.getName(), size)).getName().equals(f.getName())) continue;
                problems.put(f.getName(), name);
            }
            pathologicalFonts = Collections.unmodifiableMap(problems);
        }
        return pathologicalFonts;
    }

    public static String getPersistentName(Font font) {
        Map<String, String> problems = FontPopupEditor.getPathologicalFonts();
        if (problems.containsKey(font.getName())) {
            Font test = new Font(font.getName(), font.getSize());
            if (test.getName().equals(font.getName())) {
                return font.getName();
            }
            String alternateName = problems.get(font.getName());
            assert (alternateName != null);
            Font test2 = new Font(alternateName, font.getSize());
            if (test2.getName().equals(font.getName())) {
                return alternateName;
            }
        }
        return font.getName();
    }

    private static Map<String, Map<String, Font>> getFontMap(EditorController editorController) {
        Map<String, Map<String, Font>> fonts = (Map<String, Map<String, Font>>)fontCache.get();
        if (fonts == null) {
            fonts = FontPopupEditor.makeFontMap(editorController);
            fontCache = new WeakReference<Map<String, Map<String, Font>>>(fonts);
        }
        return fonts;
    }

    private static Map<String, Map<String, Font>> makeFontMap(EditorController editorController) {
        Set<Font> fonts = FontPopupEditor.getAllFonts();
        TreeMap fontTree = new TreeMap();
        for (Font f : fonts) {
            HashSet<Font> styleFonts;
            TreeMap<String, HashSet<Font>> familyStyleMap = (TreeMap<String, HashSet<Font>>)fontTree.get(f.getFamily());
            if (familyStyleMap == null) {
                familyStyleMap = new TreeMap<String, HashSet<Font>>();
                fontTree.put(f.getFamily(), familyStyleMap);
            }
            if ((styleFonts = (HashSet<Font>)familyStyleMap.get(f.getStyle())) == null) {
                styleFonts = new HashSet<Font>();
                familyStyleMap.put(f.getStyle(), styleFonts);
            }
            styleFonts.add(f);
        }
        TreeMap res = new TreeMap();
        for (Map.Entry e1 : fontTree.entrySet()) {
            String family = (String)e1.getKey();
            Map styleMap = (Map)e1.getValue();
            TreeMap<String, Font> resMap = new TreeMap<String, Font>();
            for (Map.Entry e2 : styleMap.entrySet()) {
                String style = (String)e2.getKey();
                Set fontSet = (Set)e2.getValue();
                int size = fontSet.size();
                assert (1 <= size);
                if (1 < size) {
                    editorController.getMessageLog().logWarningMessage("inspector.font.samefamilystyle", styleMap.get(style));
                }
                resMap.put(style, (Font)((Set)styleMap.get(style)).iterator().next());
            }
            res.put(family, Collections.unmodifiableMap(resMap));
        }
        return Collections.unmodifiableMap(res);
    }

    private static List<String> getPredefinedFontSizes() {
        String[] predefinedFontSizes = new String[]{"9", "10", "11", "12", "13", "14", "18", "24", "36", "48", "64", "72", "96"};
        return Arrays.asList(predefinedFontSizes);
    }

    private static class StyleEditor
    extends AutoSuggestEditor {
        private String style = null;

        public StyleEditor(String name, String defaultValue, List<String> suggestedList, EditorController editorController) {
            super(name, defaultValue, suggestedList);
            this.initialize(editorController);
        }

        private void initialize(EditorController editorController) {
            EventHandler onActionListener = event -> {
                if (Objects.equals(this.style, this.getTextField().getText())) {
                    return;
                }
                this.style = this.getTextField().getText();
                if (this.style.isEmpty() || !this.getSuggestedList().contains(this.style)) {
                    editorController.getMessageLog().logWarningMessage("inspector.font.invalidstyle", this.style);
                    return;
                }
                this.valueProperty().setValue((Object)this.style);
            };
            this.setTextEditorBehavior(this, (Control)this.getTextField(), (EventHandler<ActionEvent>)onActionListener);
            FontPopupEditor.commitOnFocusLost(this);
        }

        @Override
        public Object getValue() {
            return this.getTextField().getText();
        }
    }

    private static class FamilyEditor
    extends AutoSuggestEditor {
        private List<String> families;
        private String family = null;

        public FamilyEditor(String name, String defaultValue, List<String> families, EditorController editorController) {
            super(name, defaultValue, families);
            this.initialize(families, editorController);
        }

        private void initialize(List<String> families, EditorController editorController) {
            this.families = families;
            EventHandler onActionListener = event -> {
                if (Objects.equals(this.family, this.getTextField().getText())) {
                    return;
                }
                this.family = this.getTextField().getText();
                if (this.family.isEmpty() || !this.families.contains(this.family)) {
                    editorController.getMessageLog().logWarningMessage("inspector.font.invalidfamily", this.family);
                    return;
                }
                this.valueProperty().setValue((Object)this.family);
            };
            this.setTextEditorBehavior(this, (Control)this.getTextField(), (EventHandler<ActionEvent>)onActionListener);
            FontPopupEditor.commitOnFocusLost(this);
        }

        @Override
        public Object getValue() {
            return this.getTextField().getText();
        }

        public List<String> getFamilies() {
            return this.families;
        }
    }
}

