/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.popupeditors;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.popupeditors.PopupEditor;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.ColorEncoder;
import com.oracle.javafx.scenebuilder.kit.util.control.paintpicker.PaintPicker;
import java.util.Set;
import javafx.beans.value.ChangeListener;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.shape.Rectangle;

public class PaintPopupEditor
extends PopupEditor {
    private final Rectangle graphic = new Rectangle(20.0, 10.0);
    private EditorController editorController;
    protected PaintPicker paintPicker;
    private final ChangeListener<Paint> paintChangeListener = (ov, oldValue, newValue) -> {
        if (this.paintPicker.isLiveUpdate()) {
            this.userUpdateTransientValueProperty(newValue);
            this.popupMb.setText(this.getPreviewString(newValue));
        } else {
            this.commitValue(newValue);
        }
        this.graphic.setFill(newValue);
    };
    private final ChangeListener<Boolean> liveUpdateListener = (ov, oldValue, newValue) -> {
        if (!this.paintPicker.isLiveUpdate()) {
            this.commitValue(this.paintPicker.getPaintProperty());
        }
    };

    public PaintPopupEditor(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses, EditorController editorController) {
        super(propMeta, selectedClasses);
        this.initialize(editorController);
    }

    private void initialize(EditorController editorController) {
        this.editorController = editorController;
    }

    @Override
    public void initializePopupContent() {
        PaintPicker.Delegate delegate = (warningKey, arguments) -> this.editorController.getMessageLog().logWarningMessage(warningKey, arguments);
        this.paintPicker = new PaintPicker(delegate);
    }

    @Override
    public String getPreviewString(Object value) {
        if (value == null) {
            return null;
        }
        assert (value instanceof Paint);
        if (value instanceof LinearGradient || value instanceof RadialGradient || value instanceof ImagePattern) {
            return value.getClass().getSimpleName();
        }
        assert (value instanceof Color);
        return ColorEncoder.encodeColor((Color)value);
    }

    @Override
    public void setPopupContentValue(Object value) {
        assert (value == null || value instanceof Paint);
        this.paintPicker.paintProperty().removeListener(this.paintChangeListener);
        this.paintPicker.liveUpdateProperty().removeListener(this.liveUpdateListener);
        if (value != null) {
            Paint paint = (Paint)value;
            this.paintPicker.setPaintProperty(paint);
        }
        this.paintPicker.paintProperty().addListener(this.paintChangeListener);
        this.paintPicker.liveUpdateProperty().addListener(this.liveUpdateListener);
        this.graphic.setFill((Paint)value);
    }

    @Override
    public Node getPopupContentNode() {
        return this.paintPicker;
    }

    public Node getPreviewGraphic(Object value) {
        Paint paintVal = value == null ? null : (Paint)value;
        this.graphic.setFill(paintVal);
        return this.graphic;
    }
}

