/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.library;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.EditorPlatform;
import com.oracle.javafx.scenebuilder.kit.editor.drag.source.LibraryDragSource;
import com.oracle.javafx.scenebuilder.kit.editor.images.ImageUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.LibraryListItem;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.library.BuiltinLibrary;
import com.oracle.javafx.scenebuilder.kit.library.LibraryItem;
import java.net.URL;
import java.util.Map;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.stage.Window;

class LibraryListCell
extends ListCell<LibraryListItem> {
    private final EditorController editorController;
    private final HBox graphic = new HBox();
    private final ImageView iconImageView = new ImageView();
    private final Label classNameLabel = new Label();
    private final Label qualifierLabel = new Label();
    private final Label sectionLabel = new Label();
    private final URL missingIconURL = ImageUtils.getNodeIconURL("MissingIcon.png");
    private static final String EMPTY_QUALIFIER_ID = " (empty)";

    public LibraryListCell(EditorController ec) {
        this.editorController = ec;
        this.graphic.getStyleClass().add((Object)"list-cell-graphic");
        this.classNameLabel.getStyleClass().add((Object)"library-classname-label");
        this.qualifierLabel.getStyleClass().add((Object)"library-qualifier-label");
        this.sectionLabel.getStyleClass().add((Object)"library-section-label");
        this.graphic.getChildren().add((Object)this.iconImageView);
        this.graphic.getChildren().add((Object)this.classNameLabel);
        this.graphic.getChildren().add((Object)this.qualifierLabel);
        this.graphic.getChildren().add((Object)this.sectionLabel);
        HBox.setHgrow((Node)this.sectionLabel, (Priority)Priority.ALWAYS);
        this.sectionLabel.setMaxWidth(Double.MAX_VALUE);
        EventHandler mouseEventHandler = e -> this.handleMouseEvent((MouseEvent)e);
        this.addEventHandler(MouseEvent.ANY, mouseEventHandler);
        this.setOnDragDetected(t -> {
            LibraryItem item;
            LibraryListItem listItem = (LibraryListItem)this.getItem();
            FXOMDocument fxomDocument = this.editorController.getFxomDocument();
            if (listItem != null && fxomDocument != null && (item = ((LibraryListItem)this.getItem()).getLibItem()) != null) {
                ListView list = this.getListView();
                Dragboard db = list.startDragAndDrop(new TransferMode[]{TransferMode.COPY});
                Window ownerWindow = this.getScene().getWindow();
                LibraryDragSource dragSource = new LibraryDragSource(item, fxomDocument, ownerWindow);
                assert (this.editorController.getDragController().getDragSource() == null);
                assert (dragSource.isAcceptable());
                this.editorController.getDragController().begin(dragSource);
                db.setContent((Map)dragSource.makeClipboardContent());
                db.setDragView(dragSource.makeDragView());
            }
        });
    }

    public void updateItem(LibraryListItem item, boolean empty) {
        super.updateItem((Object)item, empty);
        this.setText(null);
        if (!empty && item != null) {
            this.updateLayout(item);
            if (item.getLibItem() != null) {
                String id = item.getLibItem().getName();
                if (id.contains(BuiltinLibrary.getEmptyQualifier())) {
                    id = id.replace(BuiltinLibrary.getEmptyQualifier(), EMPTY_QUALIFIER_ID);
                }
                this.graphic.setId(id);
            }
            this.setGraphic((Node)this.graphic);
        } else {
            this.setGraphic(null);
        }
    }

    private Cursor getOpenHandCursor() {
        if (EditorPlatform.IS_WINDOWS) {
            return ImageUtils.getOpenHandCursor();
        }
        return Cursor.OPEN_HAND;
    }

    private Cursor getClosedHandCursor() {
        if (EditorPlatform.IS_WINDOWS) {
            return ImageUtils.getClosedHandCursor();
        }
        return Cursor.CLOSED_HAND;
    }

    private void handleMouseEvent(MouseEvent me) {
        Scene scene = this.getScene();
        if (scene == null) {
            return;
        }
        if (scene.getWindow() != null && !scene.getWindow().isFocused()) {
            this.setCursor(Cursor.DEFAULT);
            return;
        }
        LibraryListItem listItem = (LibraryListItem)this.getItem();
        LibraryItem item = null;
        if (listItem != null) {
            item = listItem.getLibItem();
        }
        boolean isSection = false;
        if (listItem != null && listItem.getSectionName() != null) {
            isSection = true;
        }
        if (me.getEventType() == MouseEvent.MOUSE_ENTERED) {
            if (this.isEmpty() || isSection) {
                this.setCursor(Cursor.DEFAULT);
            } else {
                this.setCursor(this.getOpenHandCursor());
            }
        } else if (me.getEventType() == MouseEvent.MOUSE_PRESSED) {
            if (this.isEmpty() || isSection) {
                this.setCursor(Cursor.DEFAULT);
            } else {
                this.setCursor(this.getClosedHandCursor());
            }
        } else if (me.getEventType() == MouseEvent.MOUSE_RELEASED) {
            if (this.isEmpty() || isSection) {
                this.setCursor(Cursor.DEFAULT);
            } else {
                this.setCursor(this.getOpenHandCursor());
            }
        } else if (me.getEventType() == MouseEvent.MOUSE_EXITED) {
            this.setCursor(Cursor.DEFAULT);
        } else if (me.getEventType() == MouseEvent.MOUSE_CLICKED && me.getClickCount() == 2 && me.getButton() == MouseButton.PRIMARY && !this.isEmpty() && !isSection && item != null && this.editorController.canPerformInsert(item)) {
            this.editorController.performInsert(item);
        }
    }

    private void updateLayout(LibraryListItem listItem) {
        assert (listItem != null);
        if (listItem.getLibItem() != null) {
            LibraryItem item = listItem.getLibItem();
            String classname = this.getClassName(item.getName());
            this.iconImageView.setManaged(true);
            this.classNameLabel.setManaged(true);
            this.qualifierLabel.setManaged(true);
            this.sectionLabel.setManaged(false);
            this.iconImageView.setVisible(true);
            this.classNameLabel.setVisible(true);
            this.qualifierLabel.setVisible(true);
            this.sectionLabel.setVisible(false);
            this.classNameLabel.setText(classname);
            this.qualifierLabel.setText(this.getQualifier(item.getName()));
            URL iconURL = item.getIconURL();
            if (iconURL == null) {
                iconURL = this.missingIconURL;
            }
            this.iconImageView.setImage(new Image(iconURL.toExternalForm()));
        } else if (listItem.getSectionName() != null) {
            this.iconImageView.setManaged(false);
            this.classNameLabel.setManaged(false);
            this.qualifierLabel.setManaged(false);
            this.sectionLabel.setManaged(true);
            this.iconImageView.setVisible(false);
            this.classNameLabel.setVisible(false);
            this.qualifierLabel.setVisible(false);
            this.sectionLabel.setVisible(true);
            this.sectionLabel.setText(listItem.getSectionName());
        }
    }

    private String getClassName(String input) {
        if (!input.contains(" ")) {
            return input;
        }
        return input.substring(0, input.lastIndexOf(32));
    }

    private String getQualifier(String input) {
        if (!input.contains(" ")) {
            return "";
        }
        return input.substring(input.lastIndexOf(32), input.length());
    }
}

