/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.library;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.drag.source.AbstractDragSource;
import com.oracle.javafx.scenebuilder.kit.editor.drag.source.DocumentDragSource;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.ImportWindowController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.LibraryListCell;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.LibraryListItem;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.AbstractFxmlPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog.AbstractModalDialog;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog.AlertDialog;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog.ErrorDialog;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMArchive;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyT;
import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.library.Library;
import com.oracle.javafx.scenebuilder.kit.library.LibraryItem;
import com.oracle.javafx.scenebuilder.kit.library.LibraryItemNameComparator;
import com.oracle.javafx.scenebuilder.kit.library.user.UserLibrary;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PrefixedValue;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import com.oracle.javafx.scenebuilder.kit.preferences.MavenPreferences;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TitledPane;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.StackPane;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;

public class LibraryPanelController
extends AbstractFxmlPanelController {
    private String searchPattern;
    ArrayList<LibraryItem> searchData = new ArrayList();
    private final String TEMP_FILE_EXTENSION = ".tmp";
    String sectionNameToKeepOpened = null;
    boolean initiateImportDialog = false;
    final List<File> jarAndFxmlFiles = new ArrayList<File>();
    private String userLibraryPathString = null;
    private final MavenPreferences mavenPreferences;
    private boolean animateAccordion;
    @FXML
    private Accordion libAccordion;
    @FXML
    Label noSearchResults;
    @FXML
    ListView<LibraryListItem> libSearchList;
    @FXML
    ListView<LibraryListItem> libList = null;
    @FXML
    StackPane libPane;
    private DISPLAY_MODE currentDisplayMode;
    private DISPLAY_MODE previousDisplayMode = DISPLAY_MODE.SECTIONS;
    final ListChangeListener<LibraryItem> libraryItemListener = change -> this.libraryDidChange(null);
    private final ChangeListener<Library> libraryListener = (ov, t, t1) -> {
        if (t instanceof UserLibrary) {
            t.getItems().removeListener(this.libraryItemListener);
            t.getItems().clear();
        }
        if (t1 instanceof UserLibrary) {
            t1.getItems().addListener(this.libraryItemListener);
            if (this.sectionNameToKeepOpened != null) {
                this.sectionNameToKeepOpened = null;
            }
        }
    };
    private final EventHandler<KeyEvent> keyEventHandler = e -> this.handleKeyEvent((KeyEvent)e);
    private final Callback<ListView<LibraryListItem>, ListCell<LibraryListItem>> cb = param -> new LibraryListCell(this.getEditorController());
    private static final PropertyName valueName = new PropertyName("value");

    public LibraryPanelController(EditorController c, MavenPreferences mavenPreferences) {
        super(LibraryPanelController.class.getResource("LibraryPanel.fxml"), I18N.getBundle(), c);
        this.startListeningToLibrary();
        this.mavenPreferences = mavenPreferences;
    }

    public String getSearchPattern() {
        return this.searchPattern;
    }

    public void setSearchPattern(String searchPattern) {
        this.searchPattern = searchPattern.toUpperCase(Locale.ENGLISH);
        this.searchPatternDidChange();
    }

    public void performImportJarFxml(Window owner) {
        List<File> importedFiles = this.performSelectJarOrFxmlFile(owner);
        this.processImportJarFxml(importedFiles);
    }

    public void performImportFromFolder(Window owner) {
        File folder = this.performSelectFolder(owner);
        this.processImportFolder(folder);
    }

    public void performImportSelection(List<FXOMObject> objects) {
        this.processInternalImport(objects);
    }

    public void animateAccordion(boolean animate) {
        this.animateAccordion = animate;
        this.libAccordion.getPanes().forEach(tp -> tp.setAnimated(animate));
    }

    @Override
    protected void fxomDocumentDidChange(FXOMDocument oldDocument) {
    }

    @Override
    protected void sceneGraphRevisionDidChange() {
    }

    @Override
    protected void cssRevisionDidChange() {
    }

    @Override
    protected void jobManagerRevisionDidChange() {
    }

    @Override
    protected void editorSelectionDidChange() {
    }

    @Override
    protected void controllerDidLoadFxml() {
        assert (this.libAccordion != null);
        assert (this.libPane != null);
        assert (this.libList != null);
        assert (this.noSearchResults != null);
        assert (this.libSearchList != null);
        this.startListeningToDrop();
        this.setDisplayMode(DISPLAY_MODE.SECTIONS);
        this.populateLibraryPanel();
        this.setUserLibraryPathString();
    }

    private void displayModeDidChange(DISPLAY_MODE displayMode) {
        if (this.libAccordion != null) {
            switch (displayMode.ordinal()) {
                case 0: {
                    this.libAccordion.setVisible(true);
                    this.libAccordion.setManaged(true);
                    this.noSearchResults.setVisible(false);
                    this.noSearchResults.setManaged(false);
                    this.libSearchList.setVisible(false);
                    this.libSearchList.setManaged(false);
                    this.getLibList().setVisible(false);
                    this.getLibList().setManaged(false);
                    break;
                }
                case 1: {
                    this.libAccordion.setVisible(false);
                    this.libAccordion.setManaged(false);
                    if (this.libSearchList.getItems().isEmpty()) {
                        this.noSearchResults.setVisible(true);
                        this.noSearchResults.setManaged(true);
                        this.libSearchList.setVisible(false);
                        this.libSearchList.setManaged(false);
                    } else {
                        this.noSearchResults.setVisible(false);
                        this.noSearchResults.setManaged(false);
                        this.libSearchList.setVisible(true);
                        this.libSearchList.setManaged(true);
                    }
                    this.getLibList().setVisible(false);
                    this.getLibList().setManaged(false);
                    break;
                }
                case 2: {
                    this.libAccordion.setVisible(false);
                    this.libAccordion.setManaged(false);
                    this.noSearchResults.setVisible(false);
                    this.noSearchResults.setManaged(false);
                    this.libSearchList.setVisible(false);
                    this.libSearchList.setManaged(false);
                    this.getLibList().setVisible(true);
                    this.getLibList().setManaged(true);
                    break;
                }
            }
        }
    }

    public void setPreviousDisplayMode(DISPLAY_MODE displayMode) {
        this.previousDisplayMode = displayMode;
    }

    public void setDisplayMode(DISPLAY_MODE displayMode) {
        this.currentDisplayMode = displayMode;
        this.displayModeDidChange(displayMode);
    }

    public DISPLAY_MODE getDisplayMode() {
        return this.currentDisplayMode;
    }

    private void startListeningToLibrary() {
        this.getEditorController().libraryProperty().addListener(this.libraryListener);
    }

    void libraryDidChange(Library oldLib) {
        if (this.libAccordion != null) {
            this.libAccordion.getPanes().clear();
            this.populateLibraryPanel();
        }
    }

    private String getExpandedSectionName() {
        String sectionName = null;
        if (this.libAccordion != null && this.libAccordion.getExpandedPane() != null) {
            sectionName = this.libAccordion.getExpandedPane().getText();
        }
        return sectionName;
    }

    private void populateLibraryPanel() {
        LinkedHashMap libData = new LinkedHashMap();
        TreeSet<String> sectionNames = new TreeSet<String>(this.getEditorController().getLibrary().getSectionComparator());
        ObservableList panes = this.libAccordion.getPanes();
        this.searchData.clear();
        this.getLibList().getItems().clear();
        if (this.getEditorController().getLibrary().getItems().size() > 0) {
            for (LibraryItem item : this.getEditorController().getLibrary().getItems()) {
                sectionNames.add(item.getSection());
            }
            for (String sectionName : sectionNames) {
                libData.put(sectionName, new ArrayList());
            }
            for (LibraryItem item : this.getEditorController().getLibrary().getItems()) {
                ((ArrayList)libData.get(item.getSection())).add(item);
            }
            for (String sectionName : sectionNames) {
                ListView itemsList = new ListView();
                itemsList.setId(sectionName + "List");
                itemsList.setCellFactory(this.cb);
                itemsList.addEventHandler(KeyEvent.KEY_RELEASED, this.keyEventHandler);
                Collections.sort((List)libData.get(sectionName), new LibraryItemNameComparator());
                for (LibraryItem item : (ArrayList)libData.get(sectionName)) {
                    itemsList.getItems().add((Object)new LibraryListItem(item));
                }
                TitledPane sectionPane = new TitledPane(sectionName, (Node)itemsList);
                sectionPane.setId(sectionName);
                sectionPane.setAnimated(true);
                panes.add(sectionPane);
                this.searchData.addAll((Collection)libData.get(sectionName));
                this.getLibList().getItems().add((Object)new LibraryListItem(sectionName));
                for (LibraryItem item : (ArrayList)libData.get(sectionName)) {
                    this.getLibList().getItems().add((Object)new LibraryListItem(item));
                }
            }
            if (this.libAccordion.getPanes().size() >= 1) {
                this.expandPaneWithName(this.sectionNameToKeepOpened);
            }
            if (this.libSearchList.getCellFactory() == null) {
                this.libSearchList.setCellFactory(this.cb);
            }
            if (this.getLibList().getCellFactory() == null) {
                this.getLibList().setCellFactory(this.cb);
            }
            this.libSearchList.addEventHandler(KeyEvent.KEY_RELEASED, this.keyEventHandler);
            this.getLibList().addEventHandler(KeyEvent.KEY_RELEASED, this.keyEventHandler);
        }
        this.libAccordion.getPanes().forEach(tp -> tp.setAnimated(this.animateAccordion));
    }

    private void expandPaneWithName(String paneName) {
        String sectionName = paneName;
        if (sectionName == null) {
            sectionName = "Containers";
        }
        for (TitledPane tp : this.libAccordion.getPanes()) {
            if (!tp.getText().equals(sectionName)) continue;
            this.libAccordion.setExpandedPane(tp);
        }
    }

    private void searchPatternDidChange() {
        if (this.searchPattern == null || this.searchPattern.isEmpty()) {
            this.currentDisplayMode = this.previousDisplayMode;
        } else if (this.currentDisplayMode != DISPLAY_MODE.SEARCH) {
            this.previousDisplayMode = this.currentDisplayMode;
            this.currentDisplayMode = DISPLAY_MODE.SEARCH;
        }
        if (this.currentDisplayMode.equals((Object)DISPLAY_MODE.SEARCH)) {
            this.libSearchList.getItems().clear();
            ArrayList<LibraryItem> rawFilteredItem = new ArrayList<LibraryItem>();
            for (LibraryItem item : this.searchData) {
                if (!item.getName().toUpperCase(Locale.ROOT).contains(this.searchPattern)) continue;
                rawFilteredItem.add(item);
            }
            Collections.sort(rawFilteredItem, new LibraryItemNameComparator());
            for (LibraryItem item : rawFilteredItem) {
                this.libSearchList.getItems().add((Object)new LibraryListItem(item));
            }
            rawFilteredItem.clear();
        }
        this.setDisplayMode(this.currentDisplayMode);
    }

    private void handleKeyEvent(KeyEvent e) {
        if (e.getCode() == KeyCode.ENTER) {
            Object source = e.getSource();
            assert (source instanceof ListView);
            ListView list = (ListView)source;
            Object rawItem = list.getSelectionModel().getSelectedItem();
            assert (rawItem instanceof LibraryListItem);
            LibraryListItem listitem = (LibraryListItem)rawItem;
            LibraryItem item = listitem.getLibItem();
            if (this.getEditorController().canPerformInsert(item)) {
                this.getEditorController().performInsert(item);
            }
            e.consume();
        }
    }

    private void startListeningToDrop() {
        this.libPane.setOnDragDropped(t -> {
            AbstractDragSource dragSource = this.getEditorController().getDragController().getDragSource();
            if (dragSource instanceof DocumentDragSource) {
                this.processInternalImport(((DocumentDragSource)dragSource).getDraggedObjects());
            } else {
                Dragboard db;
                this.initiateImportDialog = false;
                this.jarAndFxmlFiles.clear();
                t.setDropCompleted(true);
                if (this.getEditorController().getLibrary() instanceof UserLibrary && (db = t.getDragboard()).hasFiles()) {
                    List files = db.getFiles();
                    for (File file : files) {
                        if (!file.isFile() || !file.getName().endsWith(".jar") && !file.getName().endsWith(".fxml")) continue;
                        this.jarAndFxmlFiles.add(file);
                    }
                    this.initiateImportDialog = true;
                }
            }
        });
        this.libPane.setOnDragExited(t -> {
            if (this.initiateImportDialog) {
                this.initiateImportDialog = false;
                final Timer timer = new Timer(true);
                TimerTask timerTask = new TimerTask(this){
                    final /* synthetic */ LibraryPanelController this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        Platform.runLater(() -> this.this$0.processImportJarFxml(this.this$0.jarAndFxmlFiles));
                        timer.cancel();
                    }
                };
                timer.schedule(timerTask, 600L);
            }
        });
        this.libPane.setOnDragOver(t -> {
            AbstractDragSource dragSource = this.getEditorController().getDragController().getDragSource();
            Dragboard db = t.getDragboard();
            if (db.hasFiles() || dragSource != null) {
                t.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
            }
        });
        this.libPane.setOnDragDone(t -> {
            assert (this.getEditorController().getDragController().getDragSource() != null);
            this.getEditorController().getDragController().end();
            t.getDragboard().clear();
            t.consume();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInternalImport(List<FXOMObject> objects) {
        this.sectionNameToKeepOpened = this.getExpandedSectionName();
        this.setUserLibraryPathString();
        Path libPath = Paths.get(this.userLibraryPathString, new String[0]);
        boolean hasDependencies = false;
        for (FXOMObject asset : objects) {
            if (!this.hasDependencies(asset)) continue;
            hasDependencies = true;
            break;
        }
        if (hasDependencies) {
            this.userLibraryUpdateRejected();
        } else {
            ((UserLibrary)this.getEditorController().getLibrary()).stopWatching();
            try {
                for (FXOMObject asset : objects) {
                    ArrayList<FXOMObject> selection = new ArrayList<FXOMObject>();
                    selection.add(asset);
                    FXOMArchive fxomArchive = new FXOMArchive(selection);
                    FXOMArchive.Entry entry0 = fxomArchive.getEntries().get(0);
                    String fxmlText = entry0.getFxmlText();
                    String prefix = asset.getGlueElement().getTagName();
                    File fxmlFile = this.getUniqueFxmlFileName(prefix, this.userLibraryPathString);
                    this.writeFxmlFile(fxmlFile, fxmlText, libPath);
                }
            }
            finally {
                if (this.currentDisplayMode.equals((Object)DISPLAY_MODE.SECTIONS)) {
                    this.sectionNameToKeepOpened = "Custom";
                }
                ((UserLibrary)this.getEditorController().getLibrary()).startWatching();
            }
        }
    }

    private void writeFxmlFile(File targetFile, String text, Path libPath) {
        Path targetFilePath = Paths.get(targetFile.getPath(), new String[0]);
        this.createUserLibraryDir(libPath);
        try {
            Files.createFile(targetFilePath, new FileAttribute[0]);
            try (PrintWriter writer = new PrintWriter(targetFile, "UTF-8");){
                writer.write(text);
            }
        }
        catch (IOException ioe) {
            ErrorDialog errorDialog = new ErrorDialog(null);
            errorDialog.setTitle(I18N.getString("error.file.create.title"));
            errorDialog.setMessage(I18N.getString("error.file.create.message", targetFilePath.normalize().toString()));
            errorDialog.setDetails(I18N.getString("error.write.details"));
            errorDialog.setDebugInfoWithThrowable(ioe);
            errorDialog.showAndWait();
        }
    }

    private File getUniqueFxmlFileName(String prefix, String libDir) {
        int suffix = 0;
        File file = null;
        while (file == null || file.exists()) {
            file = new File(libDir + File.separator + prefix + "_" + ++suffix + ".fxml");
        }
        return file;
    }

    private void processImportJarFxml(List<File> importedFiles) {
        if (importedFiles != null && !importedFiles.isEmpty()) {
            this.sectionNameToKeepOpened = this.getExpandedSectionName();
            Path libPath = Paths.get(((UserLibrary)this.getEditorController().getLibrary()).getPath(), new String[0]);
            if (this.createUserLibraryDir(libPath)) {
                List<File> jarFiles;
                List<File> fxmlFiles = this.getSubsetOfFiles(".fxml", importedFiles);
                if (!fxmlFiles.isEmpty() && this.enoughFreeSpaceOnDisk(fxmlFiles) && !this.hasDependencies(fxmlFiles)) {
                    this.copyFilesToUserLibraryDir(fxmlFiles);
                    if (this.currentDisplayMode.equals((Object)DISPLAY_MODE.SECTIONS)) {
                        this.sectionNameToKeepOpened = "Custom";
                    }
                }
                if (!(jarFiles = this.getSubsetOfFiles(".jar", importedFiles)).isEmpty() && this.enoughFreeSpaceOnDisk(jarFiles)) {
                    Window window = this.getPanelRoot().getScene().getWindow();
                    if (window instanceof Stage) {
                        Stage stage = (Stage)window;
                        stage.toFront();
                    }
                    ImportWindowController iwc = new ImportWindowController(this, jarFiles, this.mavenPreferences, (Stage)window);
                    iwc.setToolStylesheet(this.getEditorController().getToolStylesheet());
                    AbstractModalDialog.ButtonID userChoice = iwc.showAndWait();
                    if (userChoice.equals((Object)AbstractModalDialog.ButtonID.OK) && this.currentDisplayMode.equals((Object)DISPLAY_MODE.SECTIONS)) {
                        this.sectionNameToKeepOpened = "Custom";
                    }
                }
            }
        }
    }

    private void processImportFolder(File folder) {
        Path libPath;
        if (folder != null && folder.exists() && folder.isDirectory() && this.createUserLibraryDir(libPath = Paths.get(((UserLibrary)this.getEditorController().getLibrary()).getPath(), new String[0]))) {
            Window window = this.getPanelRoot().getScene().getWindow();
            if (window instanceof Stage) {
                Stage stage = (Stage)window;
                stage.toFront();
            }
            ImportWindowController iwc = new ImportWindowController(this, Arrays.asList(folder), this.mavenPreferences, (Stage)window);
            iwc.setToolStylesheet(this.getEditorController().getToolStylesheet());
            AbstractModalDialog.ButtonID userChoice = iwc.showAndWait();
            if (userChoice.equals((Object)AbstractModalDialog.ButtonID.OK) && this.currentDisplayMode.equals((Object)DISPLAY_MODE.SECTIONS)) {
                this.sectionNameToKeepOpened = "Custom";
            }
        }
    }

    private List<File> getSubsetOfFiles(String pattern, List<File> files) {
        ArrayList<File> res = new ArrayList<File>();
        for (File file : files) {
            if (!file.getName().endsWith(pattern)) continue;
            res.add(file);
        }
        return res;
    }

    private boolean createUserLibraryDir(Path libPath) {
        boolean dirCreated = false;
        try {
            Files.createDirectories(libPath, new FileAttribute[0]);
            dirCreated = true;
        }
        catch (IOException ioe) {
            ErrorDialog errorDialog = new ErrorDialog(null);
            errorDialog.setTitle(I18N.getString("error.dir.create.title"));
            errorDialog.setMessage(I18N.getString("error.dir.create.message", libPath.normalize().toString()));
            errorDialog.setDetails(I18N.getString("error.write.details"));
            errorDialog.setDebugInfoWithThrowable(ioe);
            errorDialog.showAndWait();
        }
        return dirCreated;
    }

    private boolean enoughFreeSpaceOnDisk(List<File> files) {
        long totalSize = Long.MAX_VALUE;
        try {
            for (File file : files) {
                Path targetPath = Paths.get(file.getAbsolutePath(), new String[0]);
                totalSize += Files.size(targetPath);
            }
        }
        catch (IOException ioe) {
            ErrorDialog errorDialog = new ErrorDialog(null);
            errorDialog.setTitle(I18N.getString("error.disk.space.title"));
            errorDialog.setMessage(I18N.getString("error.disk.space.message"));
            errorDialog.setDetails(I18N.getString("error.write.details"));
            errorDialog.setDebugInfoWithThrowable(ioe);
            errorDialog.showAndWait();
        }
        File libFile = new File(((UserLibrary)this.getEditorController().getLibrary()).getPath());
        return totalSize < libFile.getFreeSpace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyFilesToUserLibraryDir(List<File> files) {
        int errorCount = 0;
        IOException savedIOE = null;
        String savedFileName = "";
        Path tempTargetPath = null;
        this.setUserLibraryPathString();
        ((UserLibrary)this.getEditorController().getLibrary()).stopWatching();
        try {
            for (File file : files) {
                savedFileName = file.getName();
                tempTargetPath = Paths.get(this.userLibraryPathString, file.getName() + ".tmp");
                Path ultimateTargetPath = Paths.get(this.userLibraryPathString, file.getName());
                Files.deleteIfExists(tempTargetPath);
                Files.copy(file.toPath(), tempTargetPath, StandardCopyOption.REPLACE_EXISTING);
                Files.move(tempTargetPath, ultimateTargetPath, StandardCopyOption.ATOMIC_MOVE);
            }
        }
        catch (IOException ioe) {
            ++errorCount;
            savedIOE = ioe;
        }
        finally {
            if (tempTargetPath != null) {
                try {
                    Files.deleteIfExists(tempTargetPath);
                }
                catch (IOException ioe) {
                    ++errorCount;
                    savedIOE = ioe;
                }
            }
        }
        ((UserLibrary)this.getEditorController().getLibrary()).startWatching();
        if (errorCount > 0) {
            ErrorDialog errorDialog = new ErrorDialog(null);
            errorDialog.setTitle(I18N.getString("error.copy.title"));
            if (errorCount == 1) {
                errorDialog.setMessage(I18N.getString("error.copy.message.single", savedFileName, this.userLibraryPathString));
                errorDialog.setDebugInfoWithThrowable(savedIOE);
            } else {
                errorDialog.setMessage(I18N.getString("error.copy.message.multiple", errorCount, this.userLibraryPathString));
            }
            errorDialog.setDetails(I18N.getString("error.write.details"));
            errorDialog.showAndWait();
        }
    }

    private List<File> performSelectJarOrFxmlFile(Window owner) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(I18N.getString("lib.filechooser.filter.msg"), new String[]{"*.fxml", "*.jar"}));
        fileChooser.setInitialDirectory(EditorController.getNextInitialDirectory());
        List selectedFiles = fileChooser.showOpenMultipleDialog(owner);
        if (selectedFiles != null && !selectedFiles.isEmpty()) {
            EditorController.updateNextInitialDirectory((File)selectedFiles.get(0));
        }
        return selectedFiles;
    }

    private File performSelectFolder(Window owner) {
        DirectoryChooser dirChooser = new DirectoryChooser();
        dirChooser.setInitialDirectory(EditorController.getNextInitialDirectory());
        File folder = dirChooser.showDialog(owner);
        if (folder != null) {
            EditorController.updateNextInitialDirectory(folder);
        }
        return folder;
    }

    private void userLibraryUpdateRejected() {
        AlertDialog dialog = new AlertDialog(null);
        dialog.setTitle(I18N.getString("alert.import.reject.dependencies.title"));
        dialog.setMessage(I18N.getString("alert.import.reject.dependencies.message"));
        dialog.setDetails(I18N.getString("alert.import.reject.dependencies.details"));
        dialog.setActionButtonDisable(true);
        dialog.setActionButtonVisible(false);
        dialog.setOKButtonDisable(true);
        dialog.setOKButtonVisible(false);
        dialog.setCancelButtonTitle(I18N.getString("label.close"));
        dialog.showAndWait();
    }

    private boolean hasDependencies(List<File> fxmlFiles) {
        boolean hasDependencies = false;
        boolean scanWentWell = true;
        for (File fxmlFile : fxmlFiles) {
            try {
                if (!this.hasDependencies(fxmlFile)) continue;
                hasDependencies = true;
                break;
            }
            catch (IOException ioe) {
                scanWentWell = false;
                hasDependencies = true;
                ErrorDialog errorDialog = new ErrorDialog(null);
                errorDialog.setTitle(I18N.getString("error.import.reject.dependencies.scan.title"));
                errorDialog.setMessage(I18N.getString("error.import.reject.dependencies.scan.message"));
                errorDialog.setDetails(I18N.getString("error.import.reject.dependencies.scan.details"));
                errorDialog.setDebugInfoWithThrowable(ioe);
                errorDialog.showAndWait();
            }
        }
        if (hasDependencies && scanWentWell) {
            this.userLibraryUpdateRejected();
        }
        return hasDependencies;
    }

    private boolean hasDependencies(File fxmlFile) throws IOException {
        boolean res = false;
        URL location = fxmlFile.toURI().toURL();
        FXOMDocument fxomDocument = new FXOMDocument(FXOMDocument.readContentFromURL(location), location, this.getEditorController().getFxomDocument().getClassLoader(), this.getEditorController().getFxomDocument().getResources(), FXOMDocument.FXOMDocumentSwitch.NORMALIZED);
        res = this.hasDependencies(fxomDocument.getFxomRoot());
        return res;
    }

    private boolean hasDependencies(FXOMObject rootFxomObject) {
        List<Path> targetPaths = this.getDependenciesPaths(rootFxomObject);
        return targetPaths.size() > 0;
    }

    private List<Path> getDependenciesPaths(FXOMObject rootFxomObject) {
        ArrayList<Path> targetPaths = new ArrayList<Path>();
        for (FXOMPropertyT p : rootFxomObject.collectPropertiesT()) {
            Path path = this.extractPath(p);
            if (path == null) continue;
            targetPaths.add(path);
        }
        for (FXOMObject fxomObject : rootFxomObject.collectObjectWithSceneGraphObjectClass(URL.class)) {
            if (!(fxomObject instanceof FXOMInstance)) continue;
            FXOMInstance urlInstance = (FXOMInstance)fxomObject;
            FXOMProperty valueProperty = urlInstance.getProperties().get(valueName);
            if (valueProperty instanceof FXOMPropertyT) {
                FXOMPropertyT valuePropertyT = (FXOMPropertyT)valueProperty;
                Path path = this.extractPath(valuePropertyT);
                if (path == null) continue;
                targetPaths.add(path);
                continue;
            }
            assert (false) : "valueProperty.getName() = " + String.valueOf(valueProperty.getName());
        }
        return targetPaths;
    }

    private Path extractPath(FXOMPropertyT p) {
        Path result;
        PrefixedValue pv = new PrefixedValue(p.getValue());
        if (pv.isPlainString()) {
            try {
                URL url = new URL(pv.getSuffix());
                result = Paths.get(url.toURI());
            }
            catch (MalformedURLException | URISyntaxException x) {
                result = null;
            }
        } else if (pv.isDocumentRelativePath()) {
            URL documentLocation = p.getFxomDocument().getLocation();
            if (documentLocation == null) {
                result = null;
            } else {
                URL url = pv.resolveDocumentRelativePath(documentLocation);
                if (url == null) {
                    result = null;
                } else {
                    try {
                        result = Paths.get(url.toURI());
                    }
                    catch (URISyntaxException | FileSystemNotFoundException x) {
                        result = null;
                    }
                }
            }
        } else if (pv.isClassLoaderRelativePath()) {
            ClassLoader classLoader = p.getFxomDocument().getClassLoader();
            if (classLoader == null) {
                result = null;
            } else {
                URL url = pv.resolveClassLoaderRelativePath(classLoader);
                if (url == null) {
                    result = null;
                } else {
                    try {
                        result = Paths.get(url.toURI());
                    }
                    catch (URISyntaxException x) {
                        result = null;
                    }
                }
            }
        } else {
            result = null;
        }
        return result;
    }

    private void setUserLibraryPathString() {
        if (this.getEditorController().getLibrary() instanceof UserLibrary && this.userLibraryPathString == null) {
            this.userLibraryPathString = ((UserLibrary)this.getEditorController().getLibrary()).getPath();
            assert (this.userLibraryPathString != null);
        }
    }

    private ListView<LibraryListItem> getLibList() {
        if (this.libList == null) {
            this.libList = new ListView();
        }
        return this.libList;
    }

    public static enum DISPLAY_MODE {
        SECTIONS{

            public String toString() {
                return I18N.getString("library.panel.menu.view.sections");
            }
        }
        ,
        SEARCH,
        LIST{

            public String toString() {
                return I18N.getString("library.panel.menu.view.list");
            }
        };

    }
}

