/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.library.manager;

import com.oracle.javafx.scenebuilder.kit.editor.panel.library.manager.ArtifactDialogListItem;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.manager.DialogListItem;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.manager.LibraryDialogListItem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;

class DialogListItemComparator
implements Comparator<DialogListItem> {
    DialogListItemComparator() {
    }

    @Override
    public int compare(DialogListItem a, DialogListItem b) {
        if (a instanceof ArtifactDialogListItem && b instanceof ArtifactDialogListItem) {
            return this.compareUsingArtifactCoordinates((ArtifactDialogListItem)a, (ArtifactDialogListItem)b);
        }
        if (a instanceof LibraryDialogListItem && b instanceof LibraryDialogListItem) {
            return this.compareUsingPaths((LibraryDialogListItem)a, (LibraryDialogListItem)b);
        }
        if (a instanceof LibraryDialogListItem) {
            return -1;
        }
        return 1;
    }

    private int compareUsingArtifactCoordinates(ArtifactDialogListItem a, ArtifactDialogListItem b) {
        return a.getCoordinates().compareTo(b.getCoordinates());
    }

    private int compareUsingPaths(LibraryDialogListItem a, LibraryDialogListItem b) {
        Path first = a.getFilePath();
        Path second = b.getFilePath();
        if (Files.isDirectory(first, new LinkOption[0]) && Files.isRegularFile(second, new LinkOption[0])) {
            return -1;
        }
        if (Files.isRegularFile(first, new LinkOption[0]) && Files.isDirectory(second, new LinkOption[0])) {
            return 1;
        }
        return first.compareTo(second);
    }
}

