/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.library.manager;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.ImportWindowController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.LibraryPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.LibraryUtil;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.manager.ArtifactDialogListItem;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.manager.DialogListItem;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.manager.DialogListItemComparator;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.manager.LibraryDialogListCell;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.manager.LibraryDialogListItem;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.MavenArtifact;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.MavenDialogController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.repository.RepositoryManagerController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.search.SearchMavenDialogController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.AbstractFxmlWindowController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog.AbstractModalDialog;
import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.library.user.UserLibrary;
import com.oracle.javafx.scenebuilder.kit.preferences.MavenPreferences;
import com.oracle.javafx.scenebuilder.kit.preferences.PreferencesControllerBase;
import com.oracle.javafx.scenebuilder.kit.preferences.PreferencesRecordArtifact;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.fxml.FXML;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.ListView;
import javafx.scene.control.Tooltip;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class LibraryDialogController
extends AbstractFxmlWindowController {
    @FXML
    private ListView<DialogListItem> libraryListView;
    @FXML
    private Hyperlink classesLink;
    private final EditorController editorController;
    private final UserLibrary userLibrary;
    private final Stage owner;
    private ObservableList<DialogListItem> listItems;
    private Runnable onAddJar;
    private Runnable onAddFolder;
    private Consumer<Path> onEditFXML;
    private final String userM2Repository;
    private final PreferencesControllerBase preferencesControllerBase;

    public LibraryDialogController(EditorController editorController, String userM2Repository, PreferencesControllerBase preferencesController, Stage owner) {
        super(LibraryPanelController.class.getResource("LibraryDialog.fxml"), I18N.getBundle(), owner);
        this.owner = owner;
        this.editorController = editorController;
        this.userLibrary = (UserLibrary)editorController.getLibrary();
        this.userM2Repository = userM2Repository;
        this.preferencesControllerBase = preferencesController;
    }

    @Override
    protected void controllerDidLoadFxml() {
        super.controllerDidLoadFxml();
        this.classesLink.setTooltip(new Tooltip(I18N.getString("library.dialog.hyperlink.tooltip")));
    }

    @Override
    protected void controllerDidCreateStage() {
        if (this.owner == null) {
            this.getStage().initModality(Modality.APPLICATION_MODAL);
        } else {
            this.getStage().initOwner((Window)this.owner);
            this.getStage().initModality(Modality.WINDOW_MODAL);
        }
    }

    @Override
    public void onCloseRequest(WindowEvent event) {
        this.close();
    }

    @Override
    public void openWindow() {
        super.openWindow();
        super.getStage().setTitle(I18N.getString("library.dialog.title"));
        this.loadLibraryList();
    }

    void loadLibraryList() {
        if (this.listItems == null) {
            this.listItems = FXCollections.observableArrayList();
        }
        this.listItems.clear();
        SortedList sortedItems = this.listItems.sorted((Comparator)new DialogListItemComparator());
        this.libraryListView.setItems((ObservableList)sortedItems);
        this.libraryListView.setCellFactory(param -> new LibraryDialogListCell());
        Path folder = Paths.get(this.userLibrary.getPath(), new String[0]);
        if (folder != null && folder.toFile().exists()) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(folder);){
                for (Path entry : stream) {
                    if (LibraryUtil.isJarPath(entry) || LibraryUtil.isFxmlPath(entry)) {
                        this.listItems.add((Object)new LibraryDialogListItem(this, entry));
                        continue;
                    }
                    if (!LibraryUtil.isFolderMarkerPath(entry)) continue;
                    List<Path> folderPaths = LibraryUtil.getFolderPaths(entry);
                    for (Path f : folderPaths) {
                        this.listItems.add((Object)new LibraryDialogListItem(this, f));
                    }
                }
            }
            catch (IOException x) {
                Logger.getLogger(LibraryDialogController.class.getName()).log(Level.SEVERE, "Error while getting a new directory stream.", x);
            }
        }
        this.listItems.addAll((Collection)this.preferencesControllerBase.getMavenPreferences().getArtifactsCoordinates().stream().map(c -> new ArtifactDialogListItem(this, (String)c)).collect(Collectors.toList()));
        this.libraryListView.getSelectionModel().selectFirst();
        this.libraryListView.requestFocus();
    }

    @FXML
    private void close() {
        this.listItems.clear();
        this.closeWindow();
    }

    @FXML
    private void manage() {
        RepositoryManagerController repositoryDialogController = new RepositoryManagerController(this.editorController, this.userM2Repository, this.preferencesControllerBase, this.getStage());
        repositoryDialogController.openWindow();
    }

    @FXML
    private void addJar() {
        if (this.onAddJar != null) {
            this.onAddJar.run();
        }
        this.loadLibraryList();
    }

    @FXML
    private void addFolder() {
        if (this.onAddFolder != null) {
            this.onAddFolder.run();
        }
        this.loadLibraryList();
    }

    @FXML
    private void addRelease() {
        final SearchMavenDialogController mavenDialogController = new SearchMavenDialogController(this.editorController, this.userM2Repository, this.preferencesControllerBase, this.getStage());
        mavenDialogController.openWindow();
        mavenDialogController.getStage().showingProperty().addListener(new InvalidationListener(){
            final /* synthetic */ LibraryDialogController this$0;
            {
                this.this$0 = this$0;
            }

            public void invalidated(Observable observable) {
                if (!mavenDialogController.getStage().isShowing()) {
                    this.this$0.loadLibraryList();
                    mavenDialogController.getStage().showingProperty().removeListener((InvalidationListener)this);
                }
            }
        });
    }

    @FXML
    private void addManually() {
        final MavenDialogController mavenDialogController = new MavenDialogController(this.editorController, this.userM2Repository, this.preferencesControllerBase, this.getStage());
        mavenDialogController.openWindow();
        mavenDialogController.getStage().showingProperty().addListener(new InvalidationListener(){
            final /* synthetic */ LibraryDialogController this$0;
            {
                this.this$0 = this$0;
            }

            public void invalidated(Observable observable) {
                if (!mavenDialogController.getStage().isShowing()) {
                    this.this$0.loadLibraryList();
                    mavenDialogController.getStage().showingProperty().removeListener((InvalidationListener)this);
                }
            }
        });
    }

    public void processJarFXMLFolderDelete(DialogListItem dialogListItem) {
        if (dialogListItem instanceof LibraryDialogListItem && LibraryUtil.isFxmlPath(((LibraryDialogListItem)dialogListItem).getFilePath())) {
            this.deleteFile(dialogListItem);
        } else {
            this.userLibrary.stopWatching();
            this.deleteFile(dialogListItem);
            this.userLibrary.startWatching();
        }
    }

    private void deleteFile(DialogListItem dialogListItem) {
        try {
            if (dialogListItem instanceof LibraryDialogListItem) {
                LibraryDialogListItem item = (LibraryDialogListItem)dialogListItem;
                Path path = item.getFilePath();
                if (Files.exists(path, new LinkOption[0])) {
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        String libraryPath = ((UserLibrary)this.editorController.getLibrary()).getPath();
                        Path foldersPath = Paths.get(libraryPath, "library.folders");
                        if (Files.exists(foldersPath, new LinkOption[0])) {
                            List<String> lines = Files.readAllLines(foldersPath);
                            Iterator<String> it = lines.iterator();
                            while (it.hasNext()) {
                                String line = it.next();
                                if (!line.equals(path.toString())) continue;
                                it.remove();
                            }
                            Files.write(foldersPath, lines, new OpenOption[0]);
                        }
                    } else {
                        Files.delete(path);
                        this.listItems.remove((Object)item);
                    }
                }
            } else if (dialogListItem instanceof ArtifactDialogListItem) {
                this.preferencesControllerBase.removeArtifact(((ArtifactDialogListItem)dialogListItem).getCoordinates());
                this.listItems.remove((Object)dialogListItem);
            }
        }
        catch (IOException x) {
            Logger.getLogger(LibraryDialogController.class.getName()).log(Level.SEVERE, "Error while deleting the file.", x);
        }
        this.loadLibraryList();
    }

    public void processJarFXMLFolderEdit(DialogListItem dialogListItem) {
        if (dialogListItem instanceof LibraryDialogListItem) {
            LibraryDialogListItem item = (LibraryDialogListItem)dialogListItem;
            if (Files.exists(item.getFilePath(), new LinkOption[0])) {
                if (LibraryUtil.isJarPath(item.getFilePath()) || Files.isDirectory(item.getFilePath(), new LinkOption[0])) {
                    ImportWindowController iwc = new ImportWindowController(new LibraryPanelController(this.editorController, this.preferencesControllerBase.getMavenPreferences()), Arrays.asList(item.getFilePath().toFile()), this.preferencesControllerBase.getMavenPreferences(), this.getStage());
                    iwc.setToolStylesheet(this.editorController.getToolStylesheet());
                    AbstractModalDialog.ButtonID userChoice = iwc.showAndWait();
                    if (userChoice == AbstractModalDialog.ButtonID.OK) {
                        this.logInfoMessage("log.user.maven.updated", item);
                    }
                } else if (this.onEditFXML != null) {
                    this.onEditFXML.accept(item.getFilePath());
                }
            }
        } else if (dialogListItem instanceof ArtifactDialogListItem) {
            MavenPreferences mavenPreferences = this.preferencesControllerBase.getMavenPreferences();
            MavenArtifact mavenArtifact = mavenPreferences.getRecordArtifact(((ArtifactDialogListItem)dialogListItem).getCoordinates()).getMavenArtifact();
            List<File> files = mavenPreferences.getArtifactFileWithDependencies(mavenArtifact);
            List<String> filter = mavenPreferences.getArtifactFilter(mavenArtifact);
            ImportWindowController iwc = new ImportWindowController(new LibraryPanelController(this.editorController, this.preferencesControllerBase.getMavenPreferences()), files, this.preferencesControllerBase.getMavenPreferences(), this.getStage(), false, filter);
            iwc.setToolStylesheet(this.editorController.getToolStylesheet());
            AbstractModalDialog.ButtonID userChoice = iwc.showAndWait();
            if (userChoice == AbstractModalDialog.ButtonID.OK) {
                mavenArtifact.setFilter(iwc.getNewExcludedItems());
                this.updatePreferences(mavenArtifact);
                this.logInfoMessage("log.user.maven.updated", mavenArtifact.getCoordinates());
            }
        }
    }

    private void logInfoMessage(String key, Object ... args) {
        this.editorController.getMessageLog().logInfoMessage(key, I18N.getBundle(), args);
    }

    private void updatePreferences(MavenArtifact mavenArtifact) {
        if (mavenArtifact == null) {
            return;
        }
        this.userLibrary.stopWatching();
        PreferencesRecordArtifact recordArtifact = this.preferencesControllerBase.getRecordArtifact(mavenArtifact);
        recordArtifact.writeToJavaPreferences();
        this.userLibrary.startWatching();
    }

    public void setOnAddJar(Runnable onAddJar) {
        this.onAddJar = onAddJar;
    }

    public void setOnEditFXML(Consumer<Path> onEditFXML) {
        this.onEditFXML = onEditFXML;
    }

    public void setOnAddFolder(Runnable onAddFolder) {
        this.onAddFolder = onAddFolder;
    }
}

