/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.library.manager;

import com.oracle.javafx.scenebuilder.kit.editor.images.ImageUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.manager.ArtifactDialogListItem;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.manager.DialogListItem;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.manager.LibraryDialogListItem;
import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class LibraryDialogListCell
extends ListCell<DialogListItem> {
    private DialogListItem dialogListItem;

    public void updateItem(DialogListItem item, boolean empty) {
        this.dialogListItem = item;
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setGraphic(null);
        } else {
            this.setPrefWidth(0.0);
            this.setGraphic((Node)this.createCellContent());
        }
    }

    private HBox createCellContent() {
        HBox cellContent = new HBox();
        cellContent.setAlignment(Pos.CENTER_LEFT);
        String name = this.dialogListItem instanceof LibraryDialogListItem ? ((LibraryDialogListItem)this.dialogListItem).toString() : ((ArtifactDialogListItem)this.dialogListItem).getCoordinates();
        Label fileName = new Label(name);
        HBox.setHgrow((Node)fileName, (Priority)Priority.ALWAYS);
        HBox buttonContent = this.createButtonCellContent();
        HBox.setHgrow((Node)buttonContent, (Priority)Priority.ALWAYS);
        cellContent.getChildren().addAll((Object[])new Node[]{fileName, buttonContent});
        return cellContent;
    }

    private HBox createButtonCellContent() {
        HBox buttonContent = new HBox();
        buttonContent.setAlignment(Pos.CENTER_RIGHT);
        buttonContent.setSpacing(5.0);
        Button editButton = new Button("", (Node)new ImageView(ImageUtils.getEditIconImage()));
        editButton.getStyleClass().add((Object)"image-view-button");
        editButton.setOnMouseClicked(event -> this.dialogListItem.getLibraryDialogController().processJarFXMLFolderEdit(this.dialogListItem));
        editButton.setTooltip(new Tooltip(I18N.getString("library.dialog.button.edit.tooltip")));
        Button deleteButton = new Button("", (Node)new ImageView(ImageUtils.getDeleteIconImage()));
        deleteButton.setOnMouseClicked(event -> this.dialogListItem.getLibraryDialogController().processJarFXMLFolderDelete(this.dialogListItem));
        deleteButton.getStyleClass().add((Object)"image-view-button");
        deleteButton.setTooltip(new Tooltip(I18N.getString("library.dialog.button.delete.tooltip")));
        buttonContent.getChildren().addAll((Object[])new Node[]{editButton, deleteButton});
        return buttonContent;
    }
}

