/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.ImportWindowController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.LibraryPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.MavenArtifact;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.MavenRepositorySystem;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.AbstractFxmlWindowController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog.AbstractModalDialog;
import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.library.user.UserLibrary;
import com.oracle.javafx.scenebuilder.kit.preferences.PreferencesControllerBase;
import com.oracle.javafx.scenebuilder.kit.preferences.PreferencesRecordArtifact;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.version.Version;

public class MavenDialogController
extends AbstractFxmlWindowController {
    @FXML
    private TextField groupIDTextfield;
    @FXML
    private TextField artifactIDTextfield;
    @FXML
    private ComboBox<Version> versionsCombo;
    @FXML
    private ProgressIndicator progress;
    @FXML
    private Button installButton;
    private final UserLibrary userLibrary;
    private MavenRepositorySystem maven;
    private RemoteRepository remoteRepository;
    private Service<ObservableList<Version>> versionsService;
    private final Service<MavenArtifact> installService;
    private final Window owner;
    private final EditorController editorController;
    private final ChangeListener<Version> comboBoxListener = (obs, ov, nv) -> {
        this.remoteRepository = this.maven.getRemoteRepository((Version)nv);
    };
    private final ChangeListener<Boolean> serviceListener = (obs, ov, nv) -> {
        if (!nv.booleanValue()) {
            this.callVersionsService();
        }
    };
    private final PreferencesControllerBase preferencesControllerBase;

    public MavenDialogController(EditorController editorController, String userM2Repository, PreferencesControllerBase preferencesControllerBase, Stage owner) {
        super(LibraryPanelController.class.getResource("MavenDialog.fxml"), I18N.getBundle(), owner);
        this.userLibrary = (UserLibrary)editorController.getLibrary();
        this.owner = owner;
        this.editorController = editorController;
        this.preferencesControllerBase = preferencesControllerBase;
        this.maven = new MavenRepositorySystem(false, userM2Repository, preferencesControllerBase.getRepositoryPreferences());
        this.versionsService = new Service<ObservableList<Version>>(){

            protected Task<ObservableList<Version>> createTask() {
                return new Task<ObservableList<Version>>(){

                    protected ObservableList<Version> call() throws Exception {
                        return FXCollections.observableArrayList(MavenDialogController.this.getVersions());
                    }
                };
            }
        };
        this.versionsService.stateProperty().addListener((obs, ov, nv) -> {
            if (nv.equals((Object)Worker.State.SUCCEEDED)) {
                this.versionsCombo.getItems().setAll((Collection)((ObservableList)this.versionsService.getValue()).sorted((v1, v2) -> v2.compareTo(v1)));
                this.versionsCombo.setCellFactory(p -> new ListCell<Version>(){

                    protected void updateItem(Version item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            RemoteRepository remote = MavenDialogController.this.maven.getRemoteRepository(item);
                            this.setText(String.valueOf(item) + " [" + remote.getId() + "]");
                        } else {
                            this.setText(null);
                        }
                    }
                });
                this.versionsCombo.getSelectionModel().selectedItemProperty().addListener(this.comboBoxListener);
                this.versionsCombo.setDisable(false);
            } else if (nv.equals((Object)Worker.State.CANCELLED) || nv.equals((Object)Worker.State.FAILED)) {
                this.versionsCombo.setDisable(false);
            }
        });
        this.installService = new Service<MavenArtifact>(){

            protected Task<MavenArtifact> createTask() {
                return new Task<MavenArtifact>(){

                    protected MavenArtifact call() throws Exception {
                        return MavenDialogController.this.resolveArtifacts();
                    }
                };
            }
        };
        this.installService.stateProperty().addListener((obs, ov, nv) -> {
            if (nv.equals((Object)Worker.State.SUCCEEDED)) {
                MavenArtifact mavenArtifact = (MavenArtifact)this.installService.getValue();
                if (mavenArtifact == null || mavenArtifact.getPath().isEmpty() || !new File(mavenArtifact.getPath()).exists()) {
                    this.logInfoMessage("log.user.maven.failed", this.getArtifactCoordinates());
                } else {
                    ArrayList<File> files = new ArrayList<File>();
                    files.add(new File(mavenArtifact.getPath()));
                    if (!mavenArtifact.getDependencies().isEmpty()) {
                        files.addAll(Stream.of(mavenArtifact.getDependencies().split(File.pathSeparator)).map(File::new).collect(Collectors.toList()));
                    }
                    ImportWindowController iwc = new ImportWindowController(new LibraryPanelController(editorController, preferencesControllerBase.getMavenPreferences()), files, preferencesControllerBase.getMavenPreferences(), (Stage)this.installButton.getScene().getWindow(), false, preferencesControllerBase.getMavenPreferences().getArtifactsFilter());
                    iwc.setToolStylesheet(editorController.getToolStylesheet());
                    AbstractModalDialog.ButtonID userChoice = iwc.showAndWait();
                    if (userChoice == AbstractModalDialog.ButtonID.OK) {
                        mavenArtifact.setFilter(iwc.getNewExcludedItems());
                        this.updatePreferences(mavenArtifact);
                        this.logInfoMessage("log.user.maven.installed", this.getArtifactCoordinates());
                    }
                    this.onCloseRequest(null);
                }
            } else if (nv.equals((Object)Worker.State.CANCELLED) || nv.equals((Object)Worker.State.FAILED)) {
                this.logInfoMessage("log.user.maven.failed", this.getArtifactCoordinates());
            }
        });
    }

    @Override
    protected void controllerDidCreateStage() {
        if (this.owner == null) {
            this.getStage().initModality(Modality.APPLICATION_MODAL);
        } else {
            this.getStage().initOwner(this.owner);
            this.getStage().initModality(Modality.WINDOW_MODAL);
        }
    }

    @Override
    public void onCloseRequest(WindowEvent event) {
        this.cancel();
    }

    @Override
    public void openWindow() {
        super.openWindow();
        super.getStage().setTitle(I18N.getString("maven.dialog.title"));
        this.installButton.disableProperty().bind((ObservableValue)this.groupIDTextfield.textProperty().isEmpty().or((ObservableBooleanValue)this.artifactIDTextfield.textProperty().isEmpty().or((ObservableBooleanValue)this.versionsCombo.getSelectionModel().selectedIndexProperty().lessThan(0))));
        this.installButton.setTooltip(new Tooltip(I18N.getString("maven.dialog.install.tooltip")));
        this.versionsCombo.setDisable(true);
        this.groupIDTextfield.focusedProperty().addListener(this.serviceListener);
        this.groupIDTextfield.setOnAction(e -> this.callVersionsService());
        this.artifactIDTextfield.focusedProperty().addListener(this.serviceListener);
        this.artifactIDTextfield.setOnAction(e -> this.callVersionsService());
        this.progress.visibleProperty().bind((ObservableValue)this.versionsService.runningProperty().or((ObservableBooleanValue)this.installService.runningProperty()));
    }

    @FXML
    private void installJar() {
        this.installService.restart();
    }

    @FXML
    private void cancel() {
        this.groupIDTextfield.focusedProperty().removeListener(this.serviceListener);
        this.artifactIDTextfield.focusedProperty().removeListener(this.serviceListener);
        this.installButton.disableProperty().unbind();
        this.progress.visibleProperty().unbind();
        this.groupIDTextfield.clear();
        this.artifactIDTextfield.clear();
        this.versionsCombo.getSelectionModel().selectedItemProperty().removeListener(this.comboBoxListener);
        this.versionsCombo.getItems().clear();
        this.versionsCombo.setDisable(true);
        this.closeWindow();
    }

    private void callVersionsService() {
        if (this.groupIDTextfield.getText().isEmpty() || this.artifactIDTextfield.getText().isEmpty()) {
            return;
        }
        this.versionsCombo.getSelectionModel().selectedItemProperty().removeListener(this.comboBoxListener);
        this.versionsCombo.getItems().clear();
        this.versionsCombo.setDisable(true);
        this.versionsService.restart();
    }

    private List<Version> getVersions() {
        DefaultArtifact artifact = new DefaultArtifact(this.groupIDTextfield.getText() + ":" + this.artifactIDTextfield.getText() + ":[0,)");
        return this.maven.findVersions(artifact);
    }

    private MavenArtifact resolveArtifacts() {
        if (this.remoteRepository == null) {
            return null;
        }
        String[] coordinates = this.getArtifactCoordinates().split(":");
        DefaultArtifact jarArtifact = new DefaultArtifact(coordinates[0], coordinates[1], "", "jar", coordinates[2]);
        DefaultArtifact javadocArtifact = new DefaultArtifact(coordinates[0], coordinates[1], "javadoc", "jar", coordinates[2]);
        DefaultArtifact pomArtifact = new DefaultArtifact(coordinates[0], coordinates[1], "", "pom", coordinates[2]);
        MavenArtifact mavenArtifact = new MavenArtifact(this.getArtifactCoordinates());
        mavenArtifact.setPath(this.maven.resolveArtifacts(this.remoteRepository, jarArtifact, javadocArtifact, pomArtifact));
        mavenArtifact.setDependencies(this.maven.resolveDependencies(this.remoteRepository, jarArtifact));
        return mavenArtifact;
    }

    private void logInfoMessage(String key, Object ... args) {
        this.editorController.getMessageLog().logInfoMessage(key, I18N.getBundle(), args);
    }

    private String getArtifactCoordinates() {
        return this.groupIDTextfield.getText() + ":" + this.artifactIDTextfield.getText() + ":" + ((Version)this.versionsCombo.getSelectionModel().getSelectedItem()).toString();
    }

    private void updatePreferences(MavenArtifact mavenArtifact) {
        if (mavenArtifact == null) {
            return;
        }
        this.userLibrary.stopWatching();
        PreferencesRecordArtifact recordArtifact = this.preferencesControllerBase.getRecordArtifact(mavenArtifact);
        recordArtifact.writeToJavaPreferences();
        this.userLibrary.startWatching();
    }
}

