/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven;

import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.preset.MavenPresets;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.repository.Repository;
import com.oracle.javafx.scenebuilder.kit.preferences.RepositoryPreferences;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.aether.AbstractRepositoryListener;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.metadata.DefaultMetadata;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.supplier.RepositorySystemSupplier;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.util.graph.selector.AndDependencySelector;
import org.eclipse.aether.util.graph.selector.ExclusionDependencySelector;
import org.eclipse.aether.util.graph.selector.OptionalDependencySelector;
import org.eclipse.aether.util.graph.selector.ScopeDependencySelector;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.version.Version;

public class MavenRepositorySystem {
    private static final Logger LOG = Logger.getLogger(MavenRepositorySystem.class.getName());
    private RepositorySystem system;
    private RepositorySystemSession session;
    private LocalRepository localRepo;
    private VersionRangeResult rangeResult;
    private final boolean onlyReleases;
    private final String userM2Repository;
    private final RepositoryPreferences repositoryPreferences;

    public MavenRepositorySystem(boolean onlyReleases, String userM2Repository, RepositoryPreferences repositoryPreferences) {
        this.onlyReleases = onlyReleases;
        this.userM2Repository = userM2Repository;
        this.repositoryPreferences = repositoryPreferences;
        this.initRepositorySystem();
    }

    private void initRepositorySystem() {
        this.system = new RepositorySystemSupplier().get();
        if (this.system == null) {
            throw new RuntimeException("Error initializing repository system");
        }
        this.localRepo = new LocalRepository(Path.of(this.userM2Repository, new String[0]));
        AndDependencySelector dependencySelector = new AndDependencySelector(new ScopeDependencySelector("test", "provided"), new OptionalDependencySelector(), new ExclusionDependencySelector());
        this.session = this.system.createSessionBuilder().withTransferListener(new AbstractTransferListener(this){

            @Override
            public void transferSucceeded(TransferEvent event) {
                LOG.finest("Transfer succeeded: " + String.valueOf(event));
            }

            @Override
            public void transferFailed(TransferEvent event) {
                LOG.finest("Transfer failed: " + String.valueOf(event));
            }
        }).withRepositoryListener(new AbstractRepositoryListener(this){

            @Override
            public void artifactResolved(RepositoryEvent event) {
                LOG.finest("Artifact resolved: " + String.valueOf(event));
            }
        }).withLocalRepositories(this.localRepo).setDependencySelector(dependencySelector).build();
    }

    public List<RemoteRepository> getRepositories() {
        List<RemoteRepository> list = MavenPresets.getPresetRepositories().stream().filter(r -> !this.onlyReleases || !r.getId().toUpperCase(Locale.ROOT).contains("SNAPSHOT")).map(this::createRepository).collect(Collectors.toList());
        list.addAll(this.repositoryPreferences.getRepositories().stream().filter(r -> !this.onlyReleases || !r.getId().toUpperCase(Locale.ROOT).contains("SNAPSHOT")).map(this::createRepository).toList());
        return list;
    }

    public RemoteRepository getRemoteRepository(Version version) {
        if (this.rangeResult == null || version == null) {
            return null;
        }
        return this.getRepositories().stream().filter(r -> r.getId().equals(this.rangeResult.getRepository(version).getId())).findFirst().orElse(new RemoteRepository.Builder("Local", "default", this.session.getLocalRepository().getBasePath().toAbsolutePath().toString()).build());
    }

    public List<Version> findVersions(Artifact artifact) {
        VersionRangeRequest rangeRequest = new VersionRangeRequest();
        rangeRequest.setArtifact(artifact);
        rangeRequest.setRepositories(this.getRepositories());
        try {
            this.rangeResult = this.system.resolveVersionRange(this.session, rangeRequest);
            this.cleanMetadata(artifact);
            return this.rangeResult.getVersions();
        }
        catch (VersionRangeResolutionException ex) {
            LOG.finer("VersionRangeResolutionException finding version for artifact " + String.valueOf(artifact) + ": " + String.valueOf(ex));
            return new ArrayList<Version>();
        }
    }

    public Version findLatestVersion(Artifact artifact) {
        VersionRangeRequest rangeRequest = new VersionRangeRequest();
        rangeRequest.setArtifact(artifact);
        rangeRequest.setRepositories(this.getRepositories());
        try {
            this.rangeResult = this.system.resolveVersionRange(this.session, rangeRequest);
            this.cleanMetadata(artifact);
            return this.rangeResult.getVersions().stream().filter(v -> !v.toString().toLowerCase(Locale.ROOT).contains("snapshot")).max(Comparator.naturalOrder()).orElse(null);
        }
        catch (VersionRangeResolutionException ex) {
            LOG.finer("VersionRangeResolutionException finding latest version for artifact " + String.valueOf(artifact) + ": " + String.valueOf(ex));
            return null;
        }
    }

    private void cleanMetadata(Artifact artifact) {
        Path path = this.localRepo.getBasePath().resolve(artifact.getGroupId().replaceAll("\\.", Matcher.quoteReplacement(File.separator))).resolve(artifact.getArtifactId());
        DefaultMetadata metadata = new DefaultMetadata("maven-metadata.xml", Metadata.Nature.RELEASE);
        this.getRepositories().stream().map(r -> this.session.getLocalRepositoryManager().getPathForRemoteMetadata(metadata, (RemoteRepository)r, "")).forEach(s -> {
            Path file = path.resolve((String)s);
            if (Files.exists(file, new LinkOption[0])) {
                try {
                    Files.delete(file);
                    Files.delete(new File(String.valueOf(file) + ".sha1").toPath());
                }
                catch (IOException ex) {
                    LOG.finer("Error deleting file " + String.valueOf(file) + ": " + String.valueOf(ex));
                }
            }
        });
    }

    public String resolveArtifacts(RemoteRepository remoteRepository, Artifact ... artifact) {
        List<Artifact> artifacts = Stream.of(artifact).map(a -> {
            ArtifactRequest artifactRequest = new ArtifactRequest();
            artifactRequest.setArtifact((Artifact)a);
            artifactRequest.setRepositories(remoteRepository == null ? this.getRepositories() : List.of(remoteRepository));
            return artifactRequest;
        }).map(ar -> {
            try {
                ArtifactResult result = this.system.resolveArtifact(this.session, (ArtifactRequest)ar);
                return result.getArtifact();
            }
            catch (ArtifactResolutionException ex) {
                LOG.finer("ArtifactResolutionException for artifact request " + String.valueOf(ar) + ": " + String.valueOf(ex));
                return null;
            }
        }).filter(Objects::nonNull).toList();
        List<Path> sha1Paths = null;
        if (!artifacts.isEmpty()) {
            sha1Paths = artifacts.stream().filter(a -> a.getPath() != null).map(a -> Path.of(String.valueOf(a.getPath().toAbsolutePath()) + ".sha1", new String[0])).toList();
            InstallRequest installRequest = new InstallRequest();
            installRequest.setArtifacts(artifacts);
            try {
                this.system.install(this.session, installRequest);
            }
            catch (InstallationException ex) {
                LOG.finer("InstallationException for install request " + String.valueOf(installRequest) + ": " + String.valueOf(ex));
            }
        }
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact(artifact[0]);
        String absolutePath = "";
        try {
            Path jarFile = this.system.resolveArtifact(this.session, artifactRequest).getArtifact().getPath();
            absolutePath = jarFile.toAbsolutePath().toString();
            if (sha1Paths != null) {
                sha1Paths.forEach(path -> MavenRepositorySystem.copyFile(path, jarFile.getParent().resolve(path.getFileName())));
            }
        }
        catch (ArtifactResolutionException ex) {
            LOG.finer("ArtifactResolutionException for artifact request " + String.valueOf(artifactRequest) + ": " + String.valueOf(ex));
        }
        return absolutePath;
    }

    public String resolveDependencies(RemoteRepository remoteRepository, Artifact artifact) {
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(new Dependency(artifact, "compile"));
        collectRequest.setRepositories(remoteRepository == null ? this.getRepositories() : List.of(remoteRepository));
        DependencyRequest dependencyRequest = new DependencyRequest();
        dependencyRequest.setCollectRequest(collectRequest);
        try {
            DependencyResult dependencyResult = this.system.resolveDependencies(this.session, dependencyRequest);
            List<ArtifactResult> artifactResults = dependencyResult.getArtifactResults();
            return artifactResults.stream().skip(1L).map(a -> a.getArtifact().getPath().toAbsolutePath().toString()).collect(Collectors.joining(File.pathSeparator));
        }
        catch (DependencyResolutionException ex) {
            LOG.finer("DependencyResolutionException for artifact " + String.valueOf(artifact) + ": " + String.valueOf(ex));
            return "";
        }
    }

    private RemoteRepository createRepository(Repository repository) {
        Authentication auth = null;
        if (repository.getUser() != null && !repository.getUser().isEmpty() && repository.getPassword() != null && !repository.getPassword().isEmpty()) {
            auth = new AuthenticationBuilder().addUsername(repository.getUser()).addPassword(repository.getPassword()).build();
        }
        return new RemoteRepository.Builder(repository.getId(), repository.getType(), repository.getURL()).setSnapshotPolicy(this.onlyReleases ? new RepositoryPolicy(false, null, null) : new RepositoryPolicy()).setAuthentication(auth).build();
    }

    public String validateRepository(Repository repository) {
        block2: {
            RemoteRepository remoteRepository = this.createRepository(repository);
            ArtifactRequest artifactRequest = new ArtifactRequest();
            artifactRequest.setArtifact(new DefaultArtifact("test:test:1.0"));
            artifactRequest.setRepositories(List.of(remoteRepository));
            try {
                this.system.resolveArtifact(this.session, artifactRequest);
            }
            catch (ArtifactResolutionException ex) {
                String rootCauseMessage = MavenRepositorySystem.getExceptionCause(ex).toString();
                if (rootCauseMessage == null || rootCauseMessage.contains("ArtifactNotFoundException")) break block2;
                return rootCauseMessage;
            }
        }
        return "";
    }

    private static void copyFile(Path source, Path destination) {
        try {
            Files.createDirectories(destination.getParent(), new FileAttribute[0]);
            Files.copy(source, destination, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ex) {
            LOG.finer("Error copying file " + String.valueOf(source) + " to destination " + String.valueOf(destination) + ": " + String.valueOf(ex));
        }
    }

    private static Throwable getExceptionCause(Throwable e) {
        Throwable cause;
        Throwable t = e;
        while (null != (cause = t.getCause()) && t != cause) {
            t = cause;
        }
        return t;
    }
}

