/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.repository;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.LibraryPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.preset.MavenPresets;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.repository.CustomRepositoryListItem;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.repository.Repository;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.repository.RepositoryListItem;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.repository.RepositoryManagerListCell;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.repository.dialog.RepositoryDialogController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.AbstractFxmlWindowController;
import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.preferences.PreferencesControllerBase;
import java.util.Collection;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.ListView;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class RepositoryManagerController
extends AbstractFxmlWindowController {
    @FXML
    private ListView<RepositoryListItem> repositoryListView;
    private final EditorController editorController;
    private final Stage owner;
    private ObservableList<RepositoryListItem> listItems;
    private final String userM2Repository;
    private final PreferencesControllerBase preferencesControllerBase;

    public RepositoryManagerController(EditorController editorController, String userM2Repository, PreferencesControllerBase preferencesControllerBase, Stage owner) {
        super(LibraryPanelController.class.getResource("RepositoryManager.fxml"), I18N.getBundle(), owner);
        this.owner = owner;
        this.editorController = editorController;
        this.userM2Repository = userM2Repository;
        this.preferencesControllerBase = preferencesControllerBase;
    }

    @Override
    protected void controllerDidCreateStage() {
        if (this.owner == null) {
            this.getStage().initModality(Modality.APPLICATION_MODAL);
        } else {
            this.getStage().initOwner((Window)this.owner);
            this.getStage().initModality(Modality.WINDOW_MODAL);
        }
    }

    @Override
    public void onCloseRequest(WindowEvent event) {
        this.close();
    }

    @Override
    public void openWindow() {
        super.openWindow();
        super.getStage().setTitle(I18N.getString("repository.manager.title"));
        this.loadRepositoryList();
    }

    private void loadRepositoryList() {
        if (this.listItems == null) {
            this.listItems = FXCollections.observableArrayList();
        }
        this.listItems.clear();
        this.repositoryListView.setItems(this.listItems);
        this.repositoryListView.setCellFactory(param -> new RepositoryManagerListCell());
        this.listItems.addAll((Collection)this.preferencesControllerBase.getRepositoryPreferences().getRepositories().stream().map(r -> new CustomRepositoryListItem(this, (Repository)r)).collect(Collectors.toList()));
        this.listItems.addAll(0, (Collection)MavenPresets.getPresetRepositories().stream().map(r -> new RepositoryListItem(this, (Repository)r)).collect(Collectors.toList()));
    }

    @FXML
    private void close() {
        this.repositoryListView.getItems().clear();
        this.closeWindow();
    }

    @FXML
    private void addRepository() {
        this.repositoryDialog(null);
    }

    private void repositoryDialog(Repository repository) {
        final RepositoryDialogController repositoryDialogController = new RepositoryDialogController(this.editorController, this.userM2Repository, this.preferencesControllerBase, this.getStage());
        repositoryDialogController.openWindow();
        repositoryDialogController.setRepository(repository);
        repositoryDialogController.getStage().showingProperty().addListener(new InvalidationListener(){
            final /* synthetic */ RepositoryManagerController this$0;
            {
                this.this$0 = this$0;
            }

            public void invalidated(Observable observable) {
                if (!repositoryDialogController.getStage().isShowing()) {
                    this.this$0.loadRepositoryList();
                    repositoryDialogController.getStage().showingProperty().removeListener((InvalidationListener)this);
                }
            }
        });
    }

    public void edit(RepositoryListItem item) {
        this.repositoryDialog(item.getRepository());
    }

    public void delete(RepositoryListItem item) {
        this.logInfoMessage("log.user.repository.removed", item.getRepository().getId());
        this.preferencesControllerBase.removeRepository(item.getRepository().getId());
        this.loadRepositoryList();
    }

    private void logInfoMessage(String key, Object ... args) {
        this.editorController.getMessageLog().logInfoMessage(key, I18N.getBundle(), args);
    }
}

