/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.repository.dialog;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.LibraryPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.MavenRepositorySystem;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.repository.Repository;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.AbstractFxmlWindowController;
import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.preferences.PreferencesControllerBase;
import com.oracle.javafx.scenebuilder.kit.preferences.PreferencesRecordRepository;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class RepositoryDialogController
extends AbstractFxmlWindowController {
    @FXML
    private AnchorPane MavenDialog;
    @FXML
    private TextField nameIDTextfield;
    @FXML
    private TextField typeTextfield;
    @FXML
    private Button searchButton;
    @FXML
    private ProgressIndicator progress;
    @FXML
    private Button cancelButton;
    @FXML
    private Button addButton;
    @FXML
    private TextField urlTextfield;
    @FXML
    private CheckBox privateCheckBox;
    @FXML
    private Label userLabel;
    @FXML
    private TextField userTextfield;
    @FXML
    private Label passwordLabel;
    @FXML
    private PasswordField passwordTextfield;
    @FXML
    private Button testButton;
    @FXML
    private Label resultLabel;
    private final Window owner;
    private final EditorController editorController;
    private MavenRepositorySystem maven;
    private Repository oldRepository;
    private final Service<String> testService;
    private final String userM2Repository;
    private final PreferencesControllerBase preferencesControllerBase;

    public RepositoryDialogController(EditorController editorController, String userM2Repository, PreferencesControllerBase preferencesControllerBase, Stage owner) {
        super(LibraryPanelController.class.getResource("RepositoryDialog.fxml"), I18N.getBundle(), owner);
        this.owner = owner;
        this.editorController = editorController;
        this.userM2Repository = userM2Repository;
        this.preferencesControllerBase = preferencesControllerBase;
        this.testService = new Service<String>(){

            protected Task<String> createTask() {
                return new Task<String>(){

                    protected String call() throws Exception {
                        return RepositoryDialogController.this.maven.validateRepository(new Repository(RepositoryDialogController.this.nameIDTextfield.getText(), RepositoryDialogController.this.typeTextfield.getText(), RepositoryDialogController.this.urlTextfield.getText(), RepositoryDialogController.this.userTextfield.getText(), RepositoryDialogController.this.passwordTextfield.getText()));
                    }
                };
            }
        };
        this.testService.stateProperty().addListener((obs, ov, nv) -> {
            if (nv.equals((Object)Worker.State.SUCCEEDED)) {
                String result = (String)this.testService.getValue();
                if (result.isEmpty()) {
                    if (this.resultLabel.getStyleClass().contains((Object)"label-error")) {
                        this.resultLabel.getStyleClass().remove((Object)"label-error");
                    }
                    result = I18N.getString("repository.dialog.result");
                } else if (!this.resultLabel.getStyleClass().contains((Object)"label-error")) {
                    this.resultLabel.getStyleClass().add((Object)"label-error");
                }
                this.resultLabel.setText(result);
                this.resultLabel.setTooltip(new Tooltip(result));
            }
        });
    }

    @Override
    protected void controllerDidCreateStage() {
        if (this.owner == null) {
            this.getStage().initModality(Modality.APPLICATION_MODAL);
        } else {
            this.getStage().initOwner(this.owner);
            this.getStage().initModality(Modality.WINDOW_MODAL);
        }
    }

    @FXML
    void cancel() {
        this.closeWindow();
        this.nameIDTextfield.clear();
        this.typeTextfield.clear();
        this.urlTextfield.clear();
        this.userTextfield.clear();
        this.passwordTextfield.clear();
        this.privateCheckBox.setSelected(false);
        this.resultLabel.setText("");
    }

    @FXML
    void addRepository() {
        Repository repository = this.privateCheckBox.isSelected() ? new Repository(this.nameIDTextfield.getText(), this.typeTextfield.getText(), this.urlTextfield.getText(), this.userTextfield.getText(), this.passwordTextfield.getText()) : new Repository(this.nameIDTextfield.getText(), this.typeTextfield.getText(), this.urlTextfield.getText());
        if (this.oldRepository != null) {
            this.preferencesControllerBase.removeRepository(this.oldRepository.getId());
        }
        this.updatePreferences(repository);
        this.logInfoMessage(this.oldRepository == null ? "log.user.repository.added" : "log.user.repository.updated", repository.getId());
        this.cancel();
    }

    @FXML
    void test() {
        this.testService.restart();
    }

    @Override
    public void onCloseRequest(WindowEvent event) {
        this.cancel();
    }

    @Override
    public void openWindow() {
        super.openWindow();
        this.userLabel.disableProperty().bind((ObservableValue)this.privateCheckBox.selectedProperty().not());
        this.userTextfield.disableProperty().bind((ObservableValue)this.privateCheckBox.selectedProperty().not());
        this.passwordLabel.disableProperty().bind((ObservableValue)this.privateCheckBox.selectedProperty().not());
        this.passwordTextfield.disableProperty().bind((ObservableValue)this.privateCheckBox.selectedProperty().not());
        this.progress.visibleProperty().bind((ObservableValue)this.testService.runningProperty());
        this.resultLabel.setText("");
        this.maven = new MavenRepositorySystem(false, this.userM2Repository, this.preferencesControllerBase.getRepositoryPreferences());
    }

    private void logInfoMessage(String key, Object ... args) {
        this.editorController.getMessageLog().logInfoMessage(key, I18N.getBundle(), args);
    }

    private void updatePreferences(Repository repository) {
        if (repository == null) {
            return;
        }
        PreferencesRecordRepository recordRepository = this.preferencesControllerBase.getRecordRepository(repository);
        recordRepository.writeToJavaPreferences();
    }

    public void setRepository(Repository repository) {
        this.oldRepository = repository;
        if (repository == null) {
            super.getStage().setTitle(I18N.getString("repository.dialog.title.add"));
            this.addButton.setText(I18N.getString("repository.dialog.add"));
            this.addButton.setTooltip(new Tooltip(I18N.getString("repository.dialog.add.tooltip")));
            this.addButton.disableProperty().bind((ObservableValue)this.nameIDTextfield.textProperty().isEmpty().or((ObservableBooleanValue)this.typeTextfield.textProperty().isEmpty().or((ObservableBooleanValue)this.urlTextfield.textProperty().isEmpty())));
            return;
        }
        this.nameIDTextfield.setText(repository.getId());
        this.typeTextfield.setText(repository.getType());
        this.urlTextfield.setText(repository.getURL());
        this.userTextfield.clear();
        if (repository.getUser() != null) {
            this.userTextfield.setText(repository.getUser());
            this.privateCheckBox.setSelected(true);
        }
        this.passwordTextfield.clear();
        if (repository.getPassword() != null) {
            this.passwordTextfield.setText(repository.getPassword());
            this.privateCheckBox.setSelected(true);
        }
        this.addButton.disableProperty().bind((ObservableValue)this.nameIDTextfield.textProperty().isEqualTo(repository.getId()).and((ObservableBooleanValue)this.typeTextfield.textProperty().isEqualTo(repository.getType()).and((ObservableBooleanValue)this.urlTextfield.textProperty().isEqualTo(repository.getURL()).and((ObservableBooleanValue)this.userTextfield.textProperty().isEqualTo(repository.getUser()).and((ObservableBooleanValue)this.passwordTextfield.textProperty().isEqualTo(repository.getPassword()))))));
        super.getStage().setTitle(I18N.getString("repository.dialog.title.update"));
        this.addButton.setText(I18N.getString("repository.dialog.update"));
        this.addButton.setTooltip(new Tooltip(I18N.getString("repository.dialog.update.tooltip")));
    }
}

