/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.search;

import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.search.Search;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.aether.artifact.DefaultArtifact;

public class LocalSearch
implements Search {
    private final String m2;

    public LocalSearch(String userM2Repostory) {
        this.m2 = userM2Repostory + File.separator;
    }

    @Override
    public List<DefaultArtifact> getCoordinates(String query) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Repository", "Local");
        try {
            return Files.find(Paths.get(this.m2, new String[0]), 999, (p, bfa) -> bfa.isRegularFile(), new FileVisitOption[0]).map(p -> p.toAbsolutePath().toString()).filter(s -> s.endsWith(".jar")).map(s -> {
                String[] d = s.substring(this.m2.length()).split("\\" + File.separator);
                int length = d.length;
                if (length > 3) {
                    String a = d[length - 3];
                    String g = Stream.of(d).limit(length - 3).collect(Collectors.joining("."));
                    return g + ":" + a + ":[0,)";
                }
                return null;
            }).filter(gav -> gav != null && gav.contains(query)).distinct().map(gav -> new DefaultArtifact((String)gav, (Map<String, String>)map)).collect(Collectors.toList());
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

