/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.search;

import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.search.Search;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.aether.artifact.DefaultArtifact;

public class MavenSearch
implements Search {
    private static final String URL_PREFIX = "https://search.maven.org/solrsearch/select?q=";
    private static final String URL_SUFFIX = "&rows=200&wt=json";
    private static final String URL_PREFIX_FULLCLASS = "https://search.maven.org/solrsearch/select?q=fc:%22";
    private static final String URL_SUFFIX_FULLCLASS = "%22&rows=200&wt=json";
    private final HttpClient client = HttpClient.newHttpClient();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<DefaultArtifact> getCoordinates(String query) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Repository", "Maven Central");
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(URL_PREFIX + query + URL_SUFFIX)).build();
            HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            try (JsonReader rdr = Json.createReader(new StringReader(response.body()));){
                JsonObject obj = rdr.readObject();
                if (obj == null) return null;
                if (obj.isEmpty()) return null;
                if (!obj.containsKey("response")) return null;
                JsonObject jsonResponse = obj.getJsonObject("response");
                if (jsonResponse == null) return null;
                if (jsonResponse.isEmpty()) return null;
                if (!jsonResponse.containsKey("docs")) return null;
                JsonArray docResults = jsonResponse.getJsonArray("docs");
                List<DefaultArtifact> list = docResults.getValuesAs(JsonObject.class).stream().map(doc -> doc.getString("id", "") + ":[0,)").distinct().map(gav -> new DefaultArtifact((String)gav, (Map<String, String>)map)).collect(Collectors.toList());
                return list;
            }
        }
        catch (IOException | InterruptedException ex) {
            Logger.getLogger(MavenSearch.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }
}

