/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.search;

import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.search.Search;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.aether.artifact.DefaultArtifact;

public class NexusSearch
implements Search {
    private static final String URL_PREFIX = "/service/local/data_index?q=";
    private static final String URL_PREFIX_CLASS = "https://nexus.gluonhq.com/nexus/service/local/data_index?cn=";
    private static final String URL_SUFFIX = "&from=";
    private final HttpClient client = HttpClient.newHttpClient();
    private final String name;
    private final String domain;
    private final String username;
    private final String password;
    private static boolean first;
    private static int iteration;
    private static final int ITEMS_ITERATION = 200;
    private static final int MAX_RESULTS = 2000;

    public NexusSearch(String name, String domain, String username, String password) {
        this.name = name;
        this.domain = domain;
        this.username = username;
        this.password = password;
        iteration = 0;
        first = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<DefaultArtifact> getCoordinates(String query) {
        try {
            HttpRequest.Builder builder = HttpRequest.newBuilder().uri(URI.create(this.domain + URL_PREFIX + query + (String)(first ? "" : URL_SUFFIX + iteration * 200))).header("Accept", "application/json");
            if (!this.username.isEmpty() && !this.password.isEmpty()) {
                String authStringEnc = Base64.getEncoder().encodeToString((this.username + ":" + this.password).getBytes());
                builder.header("Authorization", "Basic " + authStringEnc);
            }
            HttpRequest request = builder.build();
            HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            try (JsonReader rdr = Json.createReader(new StringReader(response.body()));){
                JsonObject obj = rdr.readObject();
                if (first && obj != null && !obj.isEmpty() && obj.containsKey("totalCount")) {
                    first = false;
                    int totalCount = Math.min(obj.getInt("totalCount", 0), 2000);
                    if (totalCount > 200) {
                        ArrayList<DefaultArtifact> coordinates = new ArrayList<DefaultArtifact>(this.processRequest(obj));
                        while (true) {
                            if (totalCount <= 200) {
                                ArrayList<DefaultArtifact> arrayList = coordinates;
                                return arrayList;
                            }
                            ++iteration;
                            coordinates.addAll(this.getCoordinates(query).stream().filter(ga -> coordinates.stream().noneMatch(ar -> ar.getGroupId().equals(ga.getGroupId()) && ar.getArtifactId().equals(ga.getArtifactId()))).toList());
                            totalCount -= 200;
                        }
                    }
                }
                List<DefaultArtifact> list = this.processRequest(obj);
                return list;
            }
        }
        catch (IOException | InterruptedException ex) {
            Logger.getLogger(NexusSearch.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private List<DefaultArtifact> processRequest(JsonObject obj) {
        if (obj != null && !obj.isEmpty() && obj.containsKey("data")) {
            JsonArray docResults = obj.getJsonArray("data");
            return docResults.getValuesAs(JsonObject.class).stream().map(doc -> {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("Repository", this.name + " (" + doc.getString("repoId", "") + ")");
                return new DefaultArtifact(doc.getString("groupId", "") + ":" + doc.getString("artifactId", "") + ":[0,)", map);
            }).distinct().collect(Collectors.toList());
        }
        return null;
    }
}

