/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.search;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.ImportWindowController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.LibraryPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.MavenArtifact;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.MavenRepositorySystem;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.search.SearchService;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.AbstractFxmlWindowController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog.AbstractModalDialog;
import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.library.user.UserLibrary;
import com.oracle.javafx.scenebuilder.kit.preferences.PreferencesControllerBase;
import com.oracle.javafx.scenebuilder.kit.preferences.PreferencesRecordArtifact;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.version.Version;

public class SearchMavenDialogController
extends AbstractFxmlWindowController {
    @FXML
    private TextField searchTextfield;
    @FXML
    private Button searchButton;
    @FXML
    private ListView<DefaultArtifact> resultsListView;
    @FXML
    private ProgressIndicator progress;
    @FXML
    private Label installLabel;
    @FXML
    private Button installButton;
    private final EditorController editorController;
    private final UserLibrary userLibrary;
    private MavenRepositorySystem maven;
    private RemoteRepository remoteRepository;
    private final SearchService searchService;
    private final Service<MavenArtifact> installService;
    private DefaultArtifact artifact;
    private final Stage owner;
    private final PreferencesControllerBase preferencesControllerBase;

    public SearchMavenDialogController(EditorController editorController, String userM2Repository, PreferencesControllerBase preferencesControllerBase, Stage owner) {
        super(LibraryPanelController.class.getResource("SearchMavenDialog.fxml"), I18N.getBundle(), owner);
        this.userLibrary = (UserLibrary)editorController.getLibrary();
        this.owner = owner;
        this.editorController = editorController;
        this.preferencesControllerBase = preferencesControllerBase;
        this.maven = new MavenRepositorySystem(true, userM2Repository, preferencesControllerBase.getRepositoryPreferences());
        this.searchService = new SearchService(userM2Repository);
        this.searchService.getResult().addListener(c -> {
            while (c.next()) {
                this.resultsListView.getItems().setAll((Collection)this.searchService.getResult().stream().sorted((a1, a2) -> a1.toString().compareTo(a2.toString())).collect(Collectors.toList()));
            }
        });
        this.installService = new Service<MavenArtifact>(){

            protected Task<MavenArtifact> createTask() {
                return new Task<MavenArtifact>(){

                    protected MavenArtifact call() throws Exception {
                        return SearchMavenDialogController.this.resolveArtifacts();
                    }
                };
            }
        };
        this.installService.stateProperty().addListener((obs, ov, nv) -> {
            if (ov.equals((Object)Worker.State.RUNNING)) {
                if (nv.equals((Object)Worker.State.SUCCEEDED)) {
                    MavenArtifact mavenArtifact = (MavenArtifact)this.installService.getValue();
                    if (mavenArtifact == null || mavenArtifact.getPath().isEmpty() || !new File(mavenArtifact.getPath()).exists()) {
                        this.logInfoMessage("log.user.maven.failed", this.getArtifactCoordinates());
                    } else {
                        ArrayList<File> files = new ArrayList<File>();
                        files.add(new File(mavenArtifact.getPath()));
                        if (!mavenArtifact.getDependencies().isEmpty()) {
                            files.addAll(Stream.of(mavenArtifact.getDependencies().split(File.pathSeparator)).map(File::new).collect(Collectors.toList()));
                        }
                        ImportWindowController iwc = new ImportWindowController(new LibraryPanelController(editorController, preferencesControllerBase.getMavenPreferences()), files, preferencesControllerBase.getMavenPreferences(), (Stage)this.installButton.getScene().getWindow(), false, preferencesControllerBase.getMavenPreferences().getArtifactsFilter());
                        iwc.setToolStylesheet(editorController.getToolStylesheet());
                        AbstractModalDialog.ButtonID userChoice = iwc.showAndWait();
                        if (userChoice == AbstractModalDialog.ButtonID.OK) {
                            mavenArtifact.setFilter(iwc.getNewExcludedItems());
                            this.updatePreferences(mavenArtifact);
                            this.logInfoMessage("log.user.maven.installed", this.getArtifactCoordinates());
                        }
                        this.onCloseRequest(null);
                    }
                } else if (nv.equals((Object)Worker.State.CANCELLED) || nv.equals((Object)Worker.State.FAILED)) {
                    this.logInfoMessage("log.user.maven.failed", this.getArtifactCoordinates());
                }
                this.installButton.setDisable(false);
                this.searchButton.setDisable(false);
                this.resultsListView.setDisable(false);
                this.searchTextfield.setDisable(false);
                this.installLabel.setVisible(false);
            }
        });
    }

    @Override
    protected void controllerDidCreateStage() {
        if (this.owner == null) {
            this.getStage().initModality(Modality.APPLICATION_MODAL);
        } else {
            this.getStage().initOwner((Window)this.owner);
            this.getStage().initModality(Modality.WINDOW_MODAL);
        }
    }

    @Override
    public void onCloseRequest(WindowEvent event) {
        this.cancel();
    }

    @Override
    public void openWindow() {
        super.openWindow();
        super.getStage().setTitle(I18N.getString("search.maven.dialog.title"));
        this.installButton.setDisable(true);
        this.installButton.setTooltip(new Tooltip(I18N.getString("search.maven.dialog.install.tooltip")));
        this.searchButton.setDisable(true);
        this.searchTextfield.textProperty().addListener((obs, ov, nv) -> this.searchButton.setDisable(nv.isEmpty()));
        this.searchTextfield.setOnAction(e -> this.searchButton.fire());
        this.searchButton.setOnAction(e -> {
            if (this.progress.isVisible()) {
                this.searchService.cancelSearch();
            } else {
                this.searchService.setQuery(this.searchTextfield.getText());
                this.searchService.restart();
            }
        });
        this.resultsListView.setCellFactory(p -> new ListCell<DefaultArtifact>(this){

            protected void updateItem(DefaultArtifact item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item != null && !empty) {
                    this.setText(item.getGroupId() + ":" + item.getArtifactId());
                } else {
                    this.setText(null);
                }
            }
        });
        this.resultsListView.getSelectionModel().selectedItemProperty().addListener((obs, ov, nv) -> {
            if (nv != null) {
                this.installButton.setDisable(this.resultsListView.getSelectionModel().getSelectedIndex() < 0);
                this.artifact = (DefaultArtifact)this.resultsListView.getSelectionModel().getSelectedItem();
            }
        });
        this.searchButton.textProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.searchService.searchingProperty()).then(I18N.getString("search.maven.dialog.button.cancel")).otherwise(I18N.getString("search.maven.dialog.button.search")));
        this.searchButton.tooltipProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.searchService.searchingProperty()).then((Object)new Tooltip(I18N.getString("search.maven.dialog.button.cancel.tooltip"))).otherwise((Object)new Tooltip(I18N.getString("search.maven.dialog.button.search.tooltip"))));
        this.progress.visibleProperty().bind((ObservableValue)this.installService.runningProperty().or((ObservableBooleanValue)this.searchService.searchingProperty()));
    }

    @FXML
    private void installJar() {
        this.searchTextfield.setDisable(true);
        this.installButton.setDisable(true);
        this.searchButton.setDisable(true);
        this.resultsListView.setDisable(true);
        this.installLabel.setText("");
        this.installLabel.setVisible(true);
        this.installService.restart();
    }

    @FXML
    private void cancel() {
        this.searchService.cancelSearch();
        this.searchService.cancel();
        this.installService.cancel();
        this.progress.visibleProperty().unbind();
        this.searchTextfield.clear();
        this.resultsListView.getItems().clear();
        this.closeWindow();
    }

    private MavenArtifact resolveArtifacts() {
        if (this.artifact == null) {
            return null;
        }
        if (this.artifact.getVersion().equals("[0,)")) {
            this.addVersion();
            Platform.runLater(() -> this.installLabel.setText(I18N.getString("search.maven.dialog.installing", this.getArtifactCoordinates())));
        }
        if (this.remoteRepository == null) {
            return null;
        }
        String[] coordinates = this.getArtifactCoordinates().split(":");
        DefaultArtifact jarArtifact = new DefaultArtifact(coordinates[0], coordinates[1], "", "jar", coordinates[2]);
        DefaultArtifact javadocArtifact = new DefaultArtifact(coordinates[0], coordinates[1], "javadoc", "jar", coordinates[2]);
        DefaultArtifact pomArtifact = new DefaultArtifact(coordinates[0], coordinates[1], "", "pom", coordinates[2]);
        MavenArtifact mavenArtifact = new MavenArtifact(this.getArtifactCoordinates());
        mavenArtifact.setPath(this.maven.resolveArtifacts(this.remoteRepository, jarArtifact, javadocArtifact, pomArtifact));
        mavenArtifact.setDependencies(this.maven.resolveDependencies(this.remoteRepository, jarArtifact));
        return mavenArtifact;
    }

    private void logInfoMessage(String key, Object ... args) {
        this.editorController.getMessageLog().logInfoMessage(key, I18N.getBundle(), args);
    }

    private String getArtifactCoordinates() {
        if (this.artifact == null) {
            return "";
        }
        return this.artifact.getGroupId() + ":" + this.artifact.getArtifactId() + ":" + this.artifact.getVersion();
    }

    private void updatePreferences(MavenArtifact mavenArtifact) {
        if (mavenArtifact == null) {
            return;
        }
        this.userLibrary.stopWatching();
        PreferencesRecordArtifact recordArtifact = this.preferencesControllerBase.getRecordArtifact(mavenArtifact);
        recordArtifact.writeToJavaPreferences();
        this.userLibrary.startWatching();
    }

    private void addVersion() {
        Version version = this.maven.findLatestVersion(this.artifact);
        if (version == null) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Repository", this.maven.getRemoteRepository(version).getId());
        this.artifact = new DefaultArtifact(this.artifact.getGroupId() + ":" + this.artifact.getArtifactId() + ":" + version.toString(), map);
        this.remoteRepository = this.maven.getRemoteRepository(version);
    }
}

