/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.search;

import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.search.LocalSearch;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.search.MavenSearch;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.search.NexusSearch;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.search.Search;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.util.version.GenericVersion;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;

public class SearchService
extends Service<Void> {
    private final ExecutorService exec = Executors.newFixedThreadPool(5, r -> {
        Thread t = new Thread(r);
        t.setDaemon(true);
        return t;
    });
    private String query;
    private final ObservableList<DefaultArtifact> result;
    private final BooleanProperty searching;
    private List<Task<ObservableList<DefaultArtifact>>> tasks;
    private final String userM2Repository;

    public SearchService(String userM2Repository) {
        this.setExecutor(this.exec);
        this.result = FXCollections.observableArrayList();
        this.searching = new SimpleBooleanProperty();
        this.userM2Repository = userM2Repository;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public ObservableList<DefaultArtifact> getResult() {
        return this.result;
    }

    public BooleanProperty searchingProperty() {
        return this.searching;
    }

    public void cancelSearch() {
        if (this.tasks != null) {
            this.tasks.forEach(Task::cancel);
        }
        this.searching.set(false);
    }

    protected Task<Void> createTask() {
        return new Task<Void>(){

            protected Void call() throws Exception {
                if (SearchService.this.query == null || SearchService.this.query.isEmpty()) {
                    return null;
                }
                SearchService.this.tasks = Arrays.asList(SearchService.this.createSearchTask(new MavenSearch()), SearchService.this.createSearchTask(new NexusSearch("Sonatype", "http://oss.sonatype.org", "", "")), SearchService.this.createSearchTask(new NexusSearch("Gluon Nexus", "https://nexus.gluonhq.com/nexus", "", "")), SearchService.this.createSearchTask(new LocalSearch(SearchService.this.userM2Repository)));
                AtomicInteger count = new AtomicInteger();
                SearchService.this.tasks.forEach(task -> task.stateProperty().addListener((obs, oldState, newState) -> {
                    if (newState == Worker.State.SUCCEEDED || newState == Worker.State.CANCELLED || newState == Worker.State.FAILED) {
                        if (count.getAndIncrement() == SearchService.this.tasks.size() - 1) {
                            SearchService.this.searching.set(false);
                        }
                        if (newState == Worker.State.SUCCEEDED && task.getValue() != null) {
                            ArrayList<DefaultArtifact> list = new ArrayList<DefaultArtifact>((Collection<DefaultArtifact>)SearchService.this.result);
                            list.addAll((Collection)task.getValue());
                            SearchService.this.result.setAll(SearchService.this.getLatestVersions(list.stream().distinct().collect(Collectors.groupingBy(a -> a.getGroupId() + ":" + a.getArtifactId()))));
                        }
                    }
                }));
                Platform.runLater(() -> {
                    SearchService.this.result.clear();
                    SearchService.this.searching.set(true);
                });
                SearchService.this.tasks.forEach(SearchService.this.exec::execute);
                return null;
            }
        };
    }

    private Task<ObservableList<DefaultArtifact>> createSearchTask(final Search search) {
        return new Task<ObservableList<DefaultArtifact>>(this){
            final /* synthetic */ SearchService this$0;
            {
                this.this$0 = this$0;
            }

            protected ObservableList<DefaultArtifact> call() throws Exception {
                return FXCollections.observableArrayList(search.getCoordinates(this.this$0.query));
            }
        };
    }

    private List<DefaultArtifact> getLatestVersions(Map<String, List<DefaultArtifact>> mapArtifacts) {
        ArrayList<DefaultArtifact> list = new ArrayList<DefaultArtifact>();
        mapArtifacts.forEach((s, l) -> {
            DefaultArtifact da = l.stream().filter(a -> !a.getVersion().toLowerCase(Locale.ROOT).contains("snapshot")).filter(a -> !a.getVersion().toLowerCase(Locale.ROOT).contains("javadoc")).filter(a -> !a.getVersion().toLowerCase(Locale.ROOT).contains("source")).reduce((a1, a2) -> {
                Version v1 = this.getVersion(a1.getVersion());
                Version v2 = this.getVersion(a2.getVersion());
                if (v1 != null && v2 != null && v1.compareTo(v2) > 0) {
                    return a1;
                }
                return a2;
            }).get();
            list.add(da);
        });
        return list;
    }

    private List<DefaultArtifact> getAllVersions(Map<String, List<DefaultArtifact>> mapArtifacts) {
        ArrayList<DefaultArtifact> list = new ArrayList<DefaultArtifact>();
        mapArtifacts.forEach((s, l) -> l.stream().filter(a -> !a.getVersion().toLowerCase(Locale.ROOT).contains("javadoc")).filter(a -> !a.getVersion().toLowerCase(Locale.ROOT).contains("source")).forEach(list::add));
        return list;
    }

    private Version getVersion(String version) {
        GenericVersion v1 = null;
        try {
            v1 = new GenericVersionScheme().parseVersion(version);
        }
        catch (InvalidVersionSpecificationException invalidVersionSpecificationException) {
            // empty catch block
        }
        return v1;
    }
}

