/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.util;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.AbstractPanelController;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import java.io.IOException;
import java.net.URL;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;

public abstract class AbstractFxmlController
extends AbstractPanelController {
    private final URL fxmlURL;

    protected AbstractFxmlController(URL fxmlURL, EditorController editorController) {
        super(editorController);
        this.fxmlURL = fxmlURL;
        assert (fxmlURL != null) : "Check the name of the FXML file used by " + this.getClass().getSimpleName();
    }

    @Override
    protected void makePanel() {
        FXMLLoader loader = new FXMLLoader();
        loader.setController((Object)this);
        loader.setLocation(this.fxmlURL);
        loader.setResources(I18N.getBundle());
        try {
            this.setPanelRoot((Parent)loader.load());
            this.controllerDidLoadFxml();
        }
        catch (IOException | RuntimeException x) {
            System.out.println("loader.getController()=" + String.valueOf(loader.getController()));
            System.out.println("loader.getLocation()=" + String.valueOf(loader.getLocation()));
            throw new RuntimeException("Failed to load " + this.fxmlURL.getFile(), x);
        }
    }

    protected abstract void controllerDidLoadFxml();

    @Override
    protected void fxomDocumentDidChange(FXOMDocument oldDocument) {
    }

    @Override
    protected void sceneGraphRevisionDidChange() {
    }

    @Override
    protected void cssRevisionDidChange() {
    }

    @Override
    protected void jobManagerRevisionDidChange() {
    }

    @Override
    protected void editorSelectionDidChange() {
    }
}

