/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog;

import com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog.AbstractModalDialog;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog.AlertDialog;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog.TextViewDialog;
import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import java.io.PrintWriter;
import java.io.StringWriter;
import javafx.stage.Window;

public class ErrorDialog
extends AlertDialog {
    private String debugInfo;
    private String detailsTitle;

    public ErrorDialog(Window owner) {
        super(owner);
        this.setOKButtonVisible(false);
        this.setShowDefaultButton(true);
        this.setDefaultButtonID(AbstractModalDialog.ButtonID.CANCEL);
        this.setCancelButtonTitle(I18N.getString("label.close"));
        this.setActionButtonTitle(I18N.getString("error.dialog.label.details"));
        this.setActionButtonVisible(true);
        this.setActionRunnable(() -> this.showDetailsDialog());
        this.updateActionButtonVisibility();
    }

    public String getDebugInfo() {
        return this.debugInfo;
    }

    public void setDebugInfo(String debugInfo) {
        this.debugInfo = debugInfo;
        this.updateActionButtonVisibility();
    }

    public void setDebugInfoWithThrowable(Throwable t) {
        String info;
        if (t == null) {
            info = null;
        } else {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            info = sw.toString();
        }
        this.setDebugInfo(info);
    }

    public void setDetailsTitle(String detailsTitle) {
        this.detailsTitle = detailsTitle;
    }

    private void updateActionButtonVisibility() {
        this.setActionButtonVisible(this.debugInfo != null);
    }

    private void showDetailsDialog() {
        TextViewDialog detailDialog = new TextViewDialog((Window)this.getStage());
        detailDialog.setText(this.debugInfo);
        if (this.detailsTitle != null) {
            detailDialog.setTitle(this.detailsTitle);
        }
        detailDialog.showAndWait();
    }
}

