/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.report;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javafx.css.CssParser;

public class CSSParsingReport {
    private final Path stylesheetPath;
    private IOException ioException;
    private final List<CssParser.ParseError> parseErrors = new ArrayList<CssParser.ParseError>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSSParsingReport(Path stylesheetPath) {
        assert (stylesheetPath != null);
        this.stylesheetPath = stylesheetPath;
        HashSet previousErrors = new HashSet(CssParser.errorsProperty());
        try {
            new CssParser().parse(stylesheetPath.toUri().toURL());
            this.parseErrors.addAll((Collection<CssParser.ParseError>)CssParser.errorsProperty());
            this.parseErrors.removeAll(previousErrors);
        }
        catch (IOException x) {
            this.ioException = x;
        }
        finally {
            CssParser.errorsProperty().removeAll(this.parseErrors);
        }
    }

    public Path getStylesheetPath() {
        return this.stylesheetPath;
    }

    public boolean isEmpty() {
        return this.ioException == null && this.parseErrors.isEmpty();
    }

    public IOException getIOException() {
        return this.ioException;
    }

    public List<CssParser.ParseError> getParseErrors() {
        return Collections.unmodifiableList(this.parseErrors);
    }
}

