/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.search;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.AbstractFxmlController;
import javafx.beans.property.StringProperty;
import javafx.fxml.FXML;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.StackPane;

public class SearchController
extends AbstractFxmlController {
    @FXML
    private TextField searchField;
    @FXML
    private StackPane searchIcon;

    public SearchController(EditorController c) {
        super(SearchController.class.getResource("Search.fxml"), c);
    }

    public final StringProperty textProperty() {
        return this.searchField.textProperty();
    }

    public void requestFocus() {
        this.searchField.requestFocus();
    }

    @Override
    protected void controllerDidLoadFxml() {
        if (this.searchField.getLength() == 0) {
            this.searchIcon.getStyleClass().add((Object)"search-magnifying-glass");
        }
        this.searchField.setId("Search Text");
        this.searchField.textProperty().addListener((ov, oldStr, newStr) -> {
            if (newStr.isEmpty()) {
                this.searchIcon.getStyleClass().clear();
                this.searchIcon.getStyleClass().add((Object)"search-magnifying-glass");
            } else {
                this.searchIcon.getStyleClass().clear();
                this.searchIcon.getStyleClass().add((Object)"search-clear");
            }
        });
        this.searchField.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.ESCAPE) {
                this.searchField.clear();
            }
        });
        this.searchField.setOnMousePressed(event -> this.searchField.selectAll());
        this.searchField.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.searchField.selectAll();
            }
        });
        this.searchIcon.setOnMouseClicked(t -> this.searchField.clear());
    }
}

