/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.selection;

import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.IntegerPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.metadata.util.InspectorPath;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;

public class GridSelectionGroup
extends AbstractSelectionGroup {
    private final FXOMObject parentObject;
    private final Type type;
    private final Set<Integer> indexes = new HashSet<Integer>();
    private static final PropertyName rowConstraintsName = new PropertyName("rowConstraints");
    private static final PropertyName columnConstraintsName = new PropertyName("columnConstraints");
    private static final IntegerPropertyMetadata columnIndexMeta = new IntegerPropertyMetadata(new PropertyName("columnIndex", GridPane.class), true, 0, InspectorPath.UNUSED);
    private static final IntegerPropertyMetadata rowIndexMeta = new IntegerPropertyMetadata(new PropertyName("rowIndex", GridPane.class), true, 0, InspectorPath.UNUSED);

    public GridSelectionGroup(FXOMObject parentObject, Type type, int index) {
        assert (parentObject != null);
        assert (parentObject.getSceneGraphObject() instanceof GridPane);
        assert (index >= 0);
        this.parentObject = parentObject;
        this.type = type;
        this.indexes.add(index);
    }

    public GridSelectionGroup(FXOMObject parentObject, Type type, Set<Integer> indexes) {
        assert (parentObject != null);
        assert (parentObject.getSceneGraphObject() instanceof GridPane);
        assert (indexes != null);
        assert (!indexes.isEmpty());
        this.parentObject = parentObject;
        this.type = type;
        this.indexes.addAll(indexes);
    }

    public FXOMObject getParentObject() {
        return this.parentObject;
    }

    public Type getType() {
        return this.type;
    }

    public Set<Integer> getIndexes() {
        return Collections.unmodifiableSet(this.indexes);
    }

    public List<FXOMInstance> collectConstraintInstances() {
        return switch (this.type.ordinal()) {
            case 0 -> this.collectRowConstraintsInstances();
            case 1 -> this.collectColumnConstraintsInstances();
            default -> throw new RuntimeException("Bug");
        };
    }

    public List<FXOMObject> collectSelectedObjects() {
        return switch (this.type.ordinal()) {
            case 0 -> this.collectSelectedObjectsInRow();
            case 1 -> this.collectSelectedObjectsInColumn();
            default -> throw new RuntimeException("Bug");
        };
    }

    @Override
    public FXOMObject getAncestor() {
        return this.parentObject;
    }

    @Override
    public boolean isValid(FXOMDocument fxomDocument) {
        assert (fxomDocument != null);
        FXOMObject fxomRoot = fxomDocument.getFxomRoot();
        boolean result = fxomRoot == null ? false : this.parentObject == fxomRoot || this.parentObject.isDescendantOf(fxomRoot);
        return result;
    }

    @Override
    public GridSelectionGroup clone() throws CloneNotSupportedException {
        return (GridSelectionGroup)super.clone();
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + Objects.hashCode(this.parentObject);
        hash = 47 * hash + Objects.hashCode((Object)this.type);
        hash = 47 * hash + Objects.hashCode(this.indexes);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GridSelectionGroup other = (GridSelectionGroup)obj;
        if (!Objects.equals(this.parentObject, other.parentObject)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return Objects.equals(this.indexes, other.indexes);
    }

    private List<FXOMInstance> collectRowConstraintsInstances() {
        ArrayList<FXOMInstance> result = new ArrayList<FXOMInstance>();
        FXOMInstance gridPaneInstance = (FXOMInstance)this.parentObject;
        FXOMProperty fxomProperty = gridPaneInstance.getProperties().get(rowConstraintsName);
        if (fxomProperty != null) {
            assert (fxomProperty instanceof FXOMPropertyC);
            FXOMPropertyC fxomPropertyC = (FXOMPropertyC)fxomProperty;
            int index = 0;
            for (FXOMObject v : fxomPropertyC.getValues()) {
                assert (v.getSceneGraphObject() instanceof RowConstraints);
                assert (v instanceof FXOMInstance);
                if (!this.indexes.contains(index++)) continue;
                result.add((FXOMInstance)v);
            }
        }
        return result;
    }

    private List<FXOMInstance> collectColumnConstraintsInstances() {
        ArrayList<FXOMInstance> result = new ArrayList<FXOMInstance>();
        FXOMInstance gridPaneInstance = (FXOMInstance)this.parentObject;
        FXOMProperty fxomProperty = gridPaneInstance.getProperties().get(columnConstraintsName);
        if (fxomProperty != null) {
            assert (fxomProperty instanceof FXOMPropertyC);
            FXOMPropertyC fxomPropertyC = (FXOMPropertyC)fxomProperty;
            int index = 0;
            for (FXOMObject v : fxomPropertyC.getValues()) {
                assert (v.getSceneGraphObject() instanceof ColumnConstraints);
                assert (v instanceof FXOMInstance);
                if (!this.indexes.contains(index++)) continue;
                result.add((FXOMInstance)v);
            }
        }
        return result;
    }

    private List<FXOMObject> collectSelectedObjectsInColumn() {
        ArrayList<FXOMObject> result = new ArrayList<FXOMObject>();
        DesignHierarchyMask m = new DesignHierarchyMask(this.parentObject);
        assert (m.isAcceptingSubComponent());
        int count = m.getSubComponentCount();
        for (int i = 0; i < count; ++i) {
            FXOMInstance childInstance;
            FXOMObject childObject = m.getSubComponentAtIndex(i);
            if (!(childObject instanceof FXOMInstance) || !this.indexes.contains(columnIndexMeta.getValue(childInstance = (FXOMInstance)childObject))) continue;
            result.add(childInstance);
        }
        return result;
    }

    private List<FXOMObject> collectSelectedObjectsInRow() {
        ArrayList<FXOMObject> result = new ArrayList<FXOMObject>();
        DesignHierarchyMask m = new DesignHierarchyMask(this.parentObject);
        assert (m.isAcceptingSubComponent());
        int count = m.getSubComponentCount();
        for (int i = 0; i < count; ++i) {
            FXOMInstance childInstance;
            FXOMObject childObject = m.getSubComponentAtIndex(i);
            if (!(childObject instanceof FXOMInstance) || !this.indexes.contains(rowIndexMeta.getValue(childInstance = (FXOMInstance)childObject))) continue;
            result.add(childInstance);
        }
        return result;
    }

    public static enum Type {
        ROW,
        COLUMN;

    }
}

