/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.selection;

import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMNodes;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyPath;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javafx.scene.Node;

public class ObjectSelectionGroup
extends AbstractSelectionGroup {
    private final Set<FXOMObject> items = new HashSet<FXOMObject>();
    private final FXOMObject hitItem;
    private final Object hitSceneGraphObject;
    private final Node hitNode;

    ObjectSelectionGroup(FXOMObject fxomObject, Node hitNode) {
        assert (fxomObject != null);
        this.items.add(fxomObject);
        this.hitItem = fxomObject;
        this.hitSceneGraphObject = fxomObject.getSceneGraphObject();
        this.hitNode = hitNode;
    }

    public ObjectSelectionGroup(Collection<FXOMObject> fxomObjects, FXOMObject hitItem, Node hitNode) {
        assert (fxomObjects != null);
        assert (hitItem != null);
        assert (fxomObjects.contains(hitItem));
        this.items.addAll(fxomObjects);
        this.hitItem = hitItem;
        this.hitSceneGraphObject = this.hitItem.getSceneGraphObject();
        this.hitNode = hitNode;
    }

    public Set<FXOMObject> getItems() {
        return Collections.unmodifiableSet(this.items);
    }

    public FXOMObject getHitItem() {
        return this.hitItem;
    }

    public Node getHitNode() {
        return this.hitNode;
    }

    public boolean isExpired() {
        return this.hitItem.getSceneGraphObject() != this.hitSceneGraphObject;
    }

    public Node getCheckedHitNode() {
        Node result = this.hitNode == null || this.isExpired() ? this.getFallbackHitNode() : this.hitNode;
        return result;
    }

    public Node getFallbackHitNode() {
        FXOMObject closestNodeObject;
        Object result = this.hitItem.isNode() ? (Node)this.hitItem.getSceneGraphObject() : ((closestNodeObject = this.hitItem.getClosestNode()) != null ? (Node)closestNodeObject.getSceneGraphObject() : null);
        return result;
    }

    public Set<FXOMObject> getFlattenItems() {
        return FXOMNodes.flatten(this.items);
    }

    public List<FXOMObject> getSortedItems() {
        return FXOMNodes.sort(this.items);
    }

    public boolean hasSingleParent() {
        boolean result;
        if (this.items.size() == 1) {
            result = true;
        } else {
            HashSet<FXOMObject> parents = new HashSet<FXOMObject>();
            for (FXOMObject i : this.items) {
                parents.add(i.getParentObject());
            }
            result = parents.size() == 1;
        }
        return result;
    }

    @Override
    public FXOMObject getAncestor() {
        assert (!this.items.isEmpty());
        return switch (this.items.size()) {
            case 0 -> null;
            case 1 -> this.items.iterator().next().getParentObject();
            default -> {
                DesignHierarchyPath commonPath = null;
                for (FXOMObject i : this.items) {
                    FXOMObject parent = i.getParentObject();
                    if (parent == null) continue;
                    DesignHierarchyPath dph = new DesignHierarchyPath(parent);
                    if (commonPath == null) {
                        commonPath = dph;
                        continue;
                    }
                    commonPath = commonPath.getCommonPathWith(dph);
                }
                if (!$assertionsDisabled && commonPath == null) {
                    throw new AssertionError();
                }
                yield commonPath.getLeaf();
            }
        };
    }

    @Override
    public boolean isValid(FXOMDocument fxomDocument) {
        boolean result;
        assert (fxomDocument != null);
        FXOMObject fxomRoot = fxomDocument.getFxomRoot();
        if (fxomRoot == null) {
            result = false;
        } else {
            result = true;
            for (FXOMObject i : this.items) {
                boolean ok = i == fxomRoot || i.isDescendantOf(fxomRoot);
                if (ok) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    @Override
    public ObjectSelectionGroup clone() throws CloneNotSupportedException {
        return (ObjectSelectionGroup)super.clone();
    }

    public int hashCode() {
        int hash = 3;
        hash = 41 * hash + Objects.hashCode(this.items);
        hash = 41 * hash + Objects.hashCode(this.hitItem);
        hash = 41 * hash + Objects.hashCode(this.hitNode);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectSelectionGroup other = (ObjectSelectionGroup)obj;
        if (!Objects.equals(this.items, other.items)) {
            return false;
        }
        if (!Objects.equals(this.hitItem, other.hitItem)) {
            return false;
        }
        return this.hitNode == other.hitNode;
    }
}

