/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.util;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.EditorPlatform;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.AbstractPopupController;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PrefixedValue;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Labeled;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Region;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.stage.Popup;
import javafx.stage.WindowEvent;
import javafx.util.Callback;

public class InlineEditController {
    public static final String INLINE_EDITOR = "inline-editor";
    private static final double TEXT_INPUT_CONTROL_MIN_WIDTH = 15.0;
    private static final double TEXT_AREA_MIN_HEIGHT = 80.0;
    private static final double TEXT_FIELD_MIN_HEIGHT = 15.0;
    private final EditorController editorController;
    private InlineEditPopupController popupController;
    private static final String NID_INLINE_EDITOR = "inlineEditor";

    public InlineEditController(EditorController editorController) {
        this.editorController = editorController;
    }

    public boolean isWindowOpened() {
        return this.popupController == null ? false : this.popupController.isWindowOpened();
    }

    public TextInputControl getEditor() {
        return this.popupController.getEditor();
    }

    public final TextInputControl createTextInputControl(Type type, Node target, String initialValue) {
        TextArea editor = null;
        double minHeight = 0.0;
        switch (type.ordinal()) {
            case 0: {
                editor = new TextArea(initialValue);
                minHeight = 80.0;
                Boolean isWrapText = this.isWrapText(target);
                editor.setWrapText(isWrapText.booleanValue());
                break;
            }
            case 1: {
                editor = new TextField(initialValue);
                minHeight = 15.0;
                Pos alignment = this.getAlignment(target);
                ((TextField)editor).setAlignment(alignment);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        assert (editor != null);
        Bounds targetBounds = target.getLayoutBounds();
        double targetWidth = target.getScaleX() * targetBounds.getWidth();
        double targetHeight = target.getScaleY() * targetBounds.getHeight();
        double editorWidth = Math.max(targetWidth, 15.0);
        double editorHeight = Math.max(targetHeight, minHeight);
        editor.setMaxSize(editorWidth, editorHeight);
        editor.setMinSize(editorWidth, editorHeight);
        editor.setPrefSize(editorWidth, editorHeight);
        editor.setId(NID_INLINE_EDITOR);
        Insets padding = this.getPadding(target);
        editor.setPadding(padding);
        Font font = this.getFont(target);
        editor.setFont(font);
        return editor;
    }

    public void startEditingSession(TextInputControl editor, Node anchor, Callback<String, Boolean> requestCommit, Callback<Void, Boolean> requestRevert) {
        assert (editor != null && anchor != null && requestCommit != null);
        assert (!this.getEditorController().isTextEditingSessionOnGoing());
        this.popupController = new InlineEditPopupController(editor, requestCommit);
        editor.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            switch (event.getCode()) {
                case ENTER: {
                    if (!(editor instanceof TextField) && !this.isModifierDown((KeyEvent)event)) break;
                    this.requestCommitAndClose(requestCommit, editor.getText());
                    event.consume();
                    break;
                }
                case TAB: {
                    this.requestCommitAndClose(requestCommit, editor.getText());
                    event.consume();
                    break;
                }
                case ESCAPE: {
                    this.requestRevertAndClose(requestRevert);
                    event.consume();
                    break;
                }
            }
        });
        this.popupController.openWindow(anchor);
        this.editorController.textEditingSessionDidBegin(new EditingSessionDidBeginCallback(this));
    }

    public EditorController getEditorController() {
        return this.editorController;
    }

    InlineEditPopupController getPopupController() {
        return this.popupController;
    }

    private boolean requestCommitAndClose(Callback<String, Boolean> requestCommit, String newValue) {
        String newPlainValue = new PrefixedValue(PrefixedValue.Type.PLAIN_STRING, newValue).toString();
        boolean commitSucceeded = (Boolean)requestCommit.call((Object)newPlainValue);
        if (commitSucceeded) {
            this.getEditorController().textEditingSessionDidEnd();
            this.popupController.closeWindow();
        }
        return commitSucceeded;
    }

    private boolean requestRevertAndClose(Callback<Void, Boolean> requestRevert) {
        boolean revertSucceeded;
        boolean bl = revertSucceeded = requestRevert == null ? true : (Boolean)requestRevert.call(null);
        if (revertSucceeded) {
            this.getEditorController().textEditingSessionDidEnd();
            this.popupController.closeWindow();
        }
        return revertSucceeded;
    }

    private boolean isModifierDown(KeyEvent ke) {
        if (EditorPlatform.IS_MAC) {
            return ke.isMetaDown();
        }
        return ke.isControlDown();
    }

    private Pos getAlignment(Node node) {
        Pos result = node instanceof Labeled ? ((Labeled)node).getAlignment() : (node instanceof TextField ? ((TextField)node).getAlignment() : Pos.CENTER_LEFT);
        return result;
    }

    private Font getFont(Node node) {
        Font result = node instanceof Labeled ? ((Labeled)node).getFont() : (node instanceof Text ? ((Text)node).getFont() : (node instanceof TextInputControl ? ((TextInputControl)node).getFont() : Font.getDefault()));
        return result;
    }

    private Insets getPadding(Node node) {
        Insets result = node instanceof Region ? ((Region)node).getPadding() : Insets.EMPTY;
        return result;
    }

    private boolean isWrapText(Node node) {
        boolean result = node instanceof TextArea ? ((TextArea)node).isWrapText() : (node instanceof Labeled ? ((Labeled)node).isWrapText() : false);
        return result;
    }

    private class InlineEditPopupController
    extends AbstractPopupController {
        private final TextInputControl editor;
        private final Callback<String, Boolean> requestCommit;
        private final String initialValue;

        public InlineEditPopupController(TextInputControl editor, Callback<String, Boolean> requestCommit) {
            this.editor = editor;
            this.requestCommit = requestCommit;
            this.initialValue = editor.getText();
            this.editor.focusedProperty().addListener((ov, oldValue, newValue) -> {
                if (InlineEditController.this.getEditorController().isTextEditingSessionOnGoing() && !newValue.booleanValue()) {
                    InlineEditController.this.requestCommitAndClose(requestCommit, editor.getText());
                }
            });
        }

        TextInputControl getEditor() {
            return this.editor;
        }

        @Override
        protected void makeRoot() {
            this.setRoot((Parent)this.editor);
        }

        @Override
        protected void onHidden(WindowEvent event) {
        }

        @Override
        protected void anchorBoundsDidChange() {
        }

        @Override
        protected void anchorTransformDidChange() {
        }

        @Override
        protected void anchorXYDidChange() {
            if (InlineEditController.this.getEditorController().isTextEditingSessionOnGoing() && !this.initialValue.equals(this.editor.getText())) {
                InlineEditController.this.requestCommitAndClose(this.requestCommit, this.editor.getText());
            }
        }

        @Override
        protected void controllerDidCreatePopup() {
            this.getPopup().setAutoFix(false);
            this.getPopup().setAutoHide(true);
        }

        @Override
        protected void updatePopupLocation() {
            Node anchor = this.getAnchor();
            Popup popup = this.getPopup();
            assert (anchor != null && popup != null);
            Bounds anchorBounds = anchor.getLayoutBounds();
            assert (anchorBounds != null);
            if (anchor.getScene() != null) {
                Point2D popupLocation = anchor.localToScreen(anchorBounds.getMinX(), anchorBounds.getMinY());
                popup.setX(popupLocation.getX());
                popup.setY(popupLocation.getY());
            }
        }
    }

    public static enum Type {
        TEXT_AREA,
        TEXT_FIELD;

    }

    private static class EditingSessionDidBeginCallback
    implements Callback<Void, Boolean> {
        private final InlineEditController inlineEditController;

        EditingSessionDidBeginCallback(InlineEditController inlineEditController) {
            this.inlineEditController = inlineEditController;
        }

        public Boolean call(Void p) {
            InlineEditPopupController popupController = this.inlineEditController.getPopupController();
            return this.inlineEditController.requestCommitAndClose(popupController.requestCommit, popupController.editor.getText());
        }
    }
}

