/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.fxom;

import com.oracle.javafx.scenebuilder.kit.editor.EditorPlatform;
import java.util.Objects;

class FXMLPropertiesDisabler {
    private final EditorPlatform.OS os;

    public FXMLPropertiesDisabler() {
        this(EditorPlatform.OS.get());
    }

    FXMLPropertiesDisabler(EditorPlatform.OS os) {
        this.os = Objects.requireNonNull(os);
    }

    public String disableProperties(String fxmlText) {
        Objects.requireNonNull(fxmlText, "fxmlText must not be null");
        String modifiedFxml = this.disableUseSystemMenuBarProperty(fxmlText);
        return modifiedFxml;
    }

    private String disableUseSystemMenuBarProperty(String fxmlText) {
        Objects.requireNonNull(fxmlText, "fxmlText must not be null");
        if (EditorPlatform.OS.MAC == this.os) {
            String regex = "(\\s)useSystemMenuBar(\\s*)[=](\\s*)\"true\"";
            return fxmlText.replaceAll(regex, " useSystemMenuBar=\"false\"");
        }
        return fxmlText;
    }
}

