/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.fxom;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMCollection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMIntrinsic;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMNode;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyT;
import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueElement;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PrefixedValue;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import com.oracle.javafx.scenebuilder.kit.util.JavaLanguage;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FXOMInstance
extends FXOMObject {
    private final Map<PropertyName, FXOMProperty> properties = new LinkedHashMap<PropertyName, FXOMProperty>();
    private Class<?> declaredClass;
    private FXOMDocument fxomDocument;

    FXOMInstance(FXOMDocument fxomDocument, GlueElement glueElement, Class<?> declaredClass, Object sceneGraphObject, List<FXOMProperty> properties) {
        super(fxomDocument, glueElement, sceneGraphObject);
        assert (declaredClass != null);
        assert (glueElement.getTagName().equals("fx:root") || glueElement.getTagName().equals(PropertyName.makeClassFullName(declaredClass)) || glueElement.getTagName().equals(declaredClass.getCanonicalName()));
        assert (sceneGraphObject != null);
        assert (properties != null);
        this.fxomDocument = fxomDocument;
        this.declaredClass = declaredClass;
        for (FXOMProperty p : properties) {
            this.properties.put(p.getName(), p);
            p.setParentInstance(this);
        }
    }

    FXOMInstance(FXOMDocument fxomDocument, GlueElement glueElement, List<FXOMProperty> properties) {
        super(fxomDocument, glueElement, null);
        assert (properties != null);
        this.declaredClass = null;
        for (FXOMProperty p : properties) {
            this.properties.put(p.getName(), p);
            p.setParentInstance(this);
        }
    }

    public FXOMInstance(FXOMDocument fxomDocument, GlueElement glueElement) {
        this(fxomDocument, glueElement, Collections.emptyList());
    }

    public FXOMInstance(FXOMDocument fxomDocument, Class<?> declaredClass) {
        super(fxomDocument, PropertyName.makeClassFullName(declaredClass));
        this.declaredClass = declaredClass;
    }

    public FXOMInstance(FXOMDocument fxomDocument, String tagName) {
        super(fxomDocument, tagName);
        this.declaredClass = null;
    }

    public Class<?> getDeclaredClass() {
        return this.declaredClass;
    }

    public void setDeclaredClass(Class<?> declaredClass) {
        this.declaredClass = declaredClass;
    }

    public Map<PropertyName, FXOMProperty> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public boolean isFxRoot() {
        return this.getGlueElement().getTagName().equals("fx:root");
    }

    public void toggleFxRoot() {
        if (this.isFxRoot()) {
            assert (this.getType() != null);
            this.getGlueElement().setTagName(this.getType());
            this.getGlueElement().getAttributes().remove("type");
        } else {
            assert (this.getType() == null);
            this.getGlueElement().getAttributes().put("type", this.getGlueElement().getTagName());
            this.getGlueElement().setTagName("fx:root");
        }
    }

    public String getType() {
        return this.getGlueElement().getAttributes().get("type");
    }

    @Override
    public void addToParentCollection(int index, FXOMCollection newParentCollection) {
        super.addToParentCollection(index, newParentCollection);
        this.resetRootProperties();
    }

    @Override
    public void addToParentProperty(int index, FXOMPropertyC newParentProperty) {
        super.addToParentProperty(index, newParentProperty);
        this.resetRootProperties();
    }

    @Override
    public List<FXOMObject> getChildObjects() {
        ArrayList<FXOMObject> result = new ArrayList<FXOMObject>();
        for (FXOMProperty p : this.properties.values()) {
            if (!(p instanceof FXOMPropertyC)) continue;
            FXOMPropertyC pc = (FXOMPropertyC)p;
            result.addAll(pc.getValues());
        }
        return result;
    }

    @Override
    public FXOMObject searchWithSceneGraphObject(Object sceneGraphObject) {
        FXOMObject result = super.searchWithSceneGraphObject(sceneGraphObject);
        if (result == null) {
            Iterator<FXOMProperty> it = this.properties.values().iterator();
            while (result == null && it.hasNext()) {
                FXOMProperty property = it.next();
                if (!(property instanceof FXOMPropertyC)) continue;
                FXOMPropertyC propertyC = (FXOMPropertyC)property;
                Iterator<FXOMObject> itValue = propertyC.getValues().iterator();
                while (result == null && itValue.hasNext()) {
                    FXOMObject value = itValue.next();
                    result = value.searchWithSceneGraphObject(sceneGraphObject);
                }
            }
        }
        return result;
    }

    @Override
    public FXOMObject searchWithFxId(String fxId) {
        FXOMObject result = super.searchWithFxId(fxId);
        if (result == null) {
            Iterator<FXOMProperty> it = this.properties.values().iterator();
            while (result == null && it.hasNext()) {
                FXOMProperty property = it.next();
                if (!(property instanceof FXOMPropertyC)) continue;
                FXOMPropertyC propertyC = (FXOMPropertyC)property;
                Iterator<FXOMObject> itValue = propertyC.getValues().iterator();
                while (result == null && itValue.hasNext()) {
                    FXOMObject value = itValue.next();
                    result = value.searchWithFxId(fxId);
                }
            }
        }
        return result;
    }

    @Override
    protected void collectDeclaredClasses(Set<Class<?>> result) {
        assert (result != null);
        if (this.declaredClass != null) {
            result.add(this.declaredClass);
        }
        for (FXOMProperty p : this.properties.values()) {
            if (p instanceof FXOMPropertyC) {
                for (FXOMObject v : ((FXOMPropertyC)p).getValues()) {
                    v.collectDeclaredClasses(result);
                }
                continue;
            }
            if (!(p instanceof FXOMPropertyT)) continue;
            this.collectGlueElementPropertiesT(((FXOMPropertyT)p).getValueElement(), result);
        }
    }

    private void collectGlueElementPropertiesT(GlueElement element, Set<Class<?>> result) {
        block3: {
            block4: {
                if (element == null) {
                    return;
                }
                if (element.getChildren().isEmpty()) break block4;
                for (GlueElement e : element.getChildren()) {
                    this.collectGlueElementPropertiesT(e, result);
                }
                break block3;
            }
            String clazz = element.getTagName();
            if (clazz == null) break block3;
            for (Class<?> c : this.fxomDocument.getInitialDeclaredClasses()) {
                if (!c.getCanonicalName().equals(clazz) && !c.getSimpleName().equals(clazz)) continue;
                if (result.contains(c)) break;
                result.add(c);
                break;
            }
        }
    }

    @Override
    protected void collectProperties(PropertyName propertyName, List<FXOMProperty> result) {
        assert (propertyName != null);
        assert (result != null);
        for (FXOMProperty p : this.properties.values()) {
            if (p.getName().equals(propertyName)) {
                result.add(p);
            }
            if (!(p instanceof FXOMPropertyC)) continue;
            for (FXOMObject v : ((FXOMPropertyC)p).getValues()) {
                v.collectProperties(propertyName, result);
            }
        }
    }

    @Override
    protected void collectNullProperties(List<FXOMPropertyT> result) {
        assert (result != null);
        for (FXOMProperty p : this.properties.values()) {
            if (p instanceof FXOMPropertyT) {
                FXOMPropertyT tp = (FXOMPropertyT)p;
                if (!tp.getValue().equals("$null")) continue;
                result.add(tp);
                continue;
            }
            assert (p instanceof FXOMPropertyC);
            for (FXOMObject v : ((FXOMPropertyC)p).getValues()) {
                v.collectNullProperties(result);
            }
        }
    }

    @Override
    protected void collectPropertiesT(List<FXOMPropertyT> result) {
        assert (result != null);
        for (FXOMProperty p : this.properties.values()) {
            if (p instanceof FXOMPropertyT) {
                FXOMPropertyT tp = (FXOMPropertyT)p;
                result.add(tp);
                continue;
            }
            assert (p instanceof FXOMPropertyC);
            for (FXOMObject v : ((FXOMPropertyC)p).getValues()) {
                v.collectPropertiesT(result);
            }
        }
    }

    @Override
    protected void collectReferences(String source, List<FXOMIntrinsic> result) {
        for (FXOMProperty p : this.properties.values()) {
            if (!(p instanceof FXOMPropertyC)) continue;
            for (FXOMObject v : ((FXOMPropertyC)p).getValues()) {
                v.collectReferences(source, result);
            }
        }
    }

    @Override
    protected void collectReferences(String source, FXOMObject scope, List<FXOMNode> result) {
        if (scope == null || scope != this) {
            for (FXOMProperty p : this.properties.values()) {
                String suffix;
                FXOMPropertyT pt;
                PrefixedValue pv;
                if (p instanceof FXOMPropertyC) {
                    for (FXOMObject v : ((FXOMPropertyC)p).getValues()) {
                        v.collectReferences(source, scope, result);
                    }
                    continue;
                }
                if (!(p instanceof FXOMPropertyT) || !(pv = new PrefixedValue((pt = (FXOMPropertyT)p).getValue())).isExpression() || !JavaLanguage.isIdentifier(suffix = pv.getSuffix()) || source != null && !source.equals(suffix)) continue;
                result.add(pt);
            }
        }
    }

    @Override
    protected void collectIncludes(String source, List<FXOMIntrinsic> result) {
        for (FXOMProperty p : this.properties.values()) {
            if (!(p instanceof FXOMPropertyC)) continue;
            for (FXOMObject v : ((FXOMPropertyC)p).getValues()) {
                v.collectIncludes(source, result);
            }
        }
    }

    @Override
    protected void collectFxIds(Map<String, FXOMObject> result) {
        String fxId = this.getFxId();
        if (fxId != null) {
            result.put(fxId, this);
        }
        for (FXOMProperty p : this.properties.values()) {
            if (!(p instanceof FXOMPropertyC)) continue;
            for (FXOMObject v : ((FXOMPropertyC)p).getValues()) {
                v.collectFxIds(result);
            }
        }
    }

    @Override
    protected void collectObjectWithSceneGraphObjectClass(Class<?> sceneGraphObjectClass, List<FXOMObject> result) {
        if (this.getSceneGraphObject() != null) {
            if (this.getSceneGraphObject().getClass() == sceneGraphObjectClass) {
                result.add(this);
            }
            for (FXOMProperty p : this.properties.values()) {
                if (!(p instanceof FXOMPropertyC)) continue;
                for (FXOMObject v : ((FXOMPropertyC)p).getValues()) {
                    v.collectObjectWithSceneGraphObjectClass(sceneGraphObjectClass, result);
                }
            }
        }
    }

    @Override
    protected void collectEventHandlers(List<FXOMPropertyT> result) {
        if (this.getSceneGraphObject() != null) {
            for (FXOMProperty p : this.properties.values()) {
                FXOMPropertyT pt;
                if (!(p instanceof FXOMPropertyT) || !(pt = (FXOMPropertyT)p).getName().getName().startsWith("on") || !pt.getValue().startsWith("#")) continue;
                result.add(pt);
            }
            for (FXOMProperty p : this.properties.values()) {
                if (!(p instanceof FXOMPropertyC)) continue;
                for (FXOMObject v : ((FXOMPropertyC)p).getValues()) {
                    v.collectEventHandlers(result);
                }
            }
        }
    }

    @Override
    protected void changeFxomDocument(FXOMDocument destination) {
        super.changeFxomDocument(destination);
        for (FXOMProperty p : this.properties.values()) {
            p.changeFxomDocument(destination);
        }
    }

    @Override
    public void documentLocationWillChange(URL newLocation) {
        for (FXOMProperty p : this.properties.values()) {
            p.documentLocationWillChange(newLocation);
        }
    }

    void addProperty(FXOMProperty property) {
        assert (property.getParentInstance() == this);
        assert (this.properties.get(property.getName()) == null);
        this.properties.put(property.getName(), property);
    }

    void removeProperty(FXOMProperty property) {
        assert (property.getParentInstance() == null);
        assert (this.properties.get(property.getName()) == property);
        this.properties.remove(property.getName());
    }

    public void fillProperties(Map<PropertyName, FXOMProperty> properties) {
        for (FXOMProperty p : properties.values()) {
            this.properties.put(p.getName(), p);
            p.setParentInstance(this);
        }
    }

    private void resetRootProperties() {
        if (this.isFxRoot()) {
            this.toggleFxRoot();
        }
    }
}

