/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.fxom;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMNode;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyT;
import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueElement;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FXOMIntrinsic
extends FXOMObject {
    private static final String CHARSET_PROPERTY = "charset";
    private static final String SOURCE_PROPERTY = "source";
    private final Map<PropertyName, FXOMProperty> properties = new LinkedHashMap<PropertyName, FXOMProperty>();
    private Object sourceSceneGraphObject;

    FXOMIntrinsic(FXOMDocument document, GlueElement glueElement, Object targetSceneGraphObject, List<FXOMProperty> properties) {
        super(document, glueElement, null);
        this.sourceSceneGraphObject = targetSceneGraphObject;
        for (FXOMProperty p : properties) {
            this.properties.put(p.getName(), p);
        }
    }

    public FXOMIntrinsic(FXOMDocument document, Type type, String source) {
        super(document, FXOMIntrinsic.makeTagNameFromType(type));
        this.getGlueElement().getAttributes().put(SOURCE_PROPERTY, source);
    }

    public void addIntrinsicProperty(FXOMDocument fxomDocument) {
        Map<String, String> attributes = this.getGlueElement().getAttributes();
        if (attributes.containsKey(CHARSET_PROPERTY)) {
            this.createAndInsertProperty(attributes, fxomDocument, CHARSET_PROPERTY);
        }
        if (attributes.containsKey(SOURCE_PROPERTY)) {
            this.createAndInsertProperty(attributes, fxomDocument, SOURCE_PROPERTY);
        }
    }

    private void createAndInsertProperty(Map<String, String> attributes, FXOMDocument fxomDocument, String propertyKey) {
        String valueString = attributes.get(propertyKey);
        PropertyName propertyName = new PropertyName(propertyKey);
        FXOMPropertyT property = new FXOMPropertyT(fxomDocument, propertyName, valueString);
        this.getProperties().put(propertyName, property);
    }

    public void removeCharsetProperty() {
        Map<String, String> attributes = this.getGlueElement().getAttributes();
        if (attributes.containsKey(CHARSET_PROPERTY)) {
            attributes.remove(CHARSET_PROPERTY);
            PropertyName charsetPropertyName = new PropertyName(CHARSET_PROPERTY);
            this.getProperties().remove(charsetPropertyName);
        }
    }

    public Type getType() {
        return switch (this.getGlueElement().getTagName()) {
            case "fx:include" -> Type.FX_INCLUDE;
            case "fx:reference" -> Type.FX_REFERENCE;
            case "fx:copy" -> Type.FX_COPY;
            default -> Type.UNDEFINED;
        };
    }

    public String getSource() {
        return this.getGlueElement().getAttributes().get(SOURCE_PROPERTY);
    }

    public void setSource(String source) {
        if (source == null) {
            this.getGlueElement().getAttributes().remove(SOURCE_PROPERTY);
        } else {
            this.getGlueElement().getAttributes().put(SOURCE_PROPERTY, source);
        }
    }

    public Object getSourceSceneGraphObject() {
        return this.sourceSceneGraphObject;
    }

    public void setSourceSceneGraphObject(Object sourceSceneGraphObject) {
        this.sourceSceneGraphObject = sourceSceneGraphObject;
    }

    public Map<PropertyName, FXOMProperty> getProperties() {
        return this.properties;
    }

    public void fillProperties(Map<PropertyName, FXOMProperty> properties) {
        for (FXOMProperty p : properties.values()) {
            this.properties.put(p.getName(), p);
        }
    }

    public FXOMInstance createFxomInstanceFromIntrinsic() {
        FXOMInstance fxomInstance = new FXOMInstance(this.getFxomDocument(), this.getGlueElement());
        fxomInstance.setSceneGraphObject(this.getSourceSceneGraphObject());
        fxomInstance.setDeclaredClass(this.getClass());
        if (!this.getProperties().isEmpty()) {
            fxomInstance.fillProperties(this.getProperties());
        }
        return fxomInstance;
    }

    @Override
    public List<FXOMObject> getChildObjects() {
        return Collections.emptyList();
    }

    @Override
    public FXOMObject searchWithSceneGraphObject(Object sceneGraphObject) {
        FXOMObject result = this.getType() == Type.FX_INCLUDE ? super.searchWithSceneGraphObject(sceneGraphObject) : null;
        return result;
    }

    @Override
    public FXOMObject searchWithFxId(String fxId) {
        FXOMObject result = this.getType() == Type.FX_INCLUDE ? super.searchWithFxId(fxId) : null;
        return result;
    }

    @Override
    protected void collectDeclaredClasses(Set<Class<?>> result) {
    }

    @Override
    protected void collectNullProperties(List<FXOMPropertyT> result) {
    }

    @Override
    protected void collectPropertiesT(List<FXOMPropertyT> result) {
    }

    @Override
    protected void collectProperties(PropertyName propertyName, List<FXOMProperty> result) {
    }

    @Override
    protected void collectReferences(String source, List<FXOMIntrinsic> result) {
        assert (result != null);
        if (this.getType() == Type.FX_REFERENCE && (source == null || source.equals(this.getSource()))) {
            result.add(this);
        }
    }

    @Override
    protected void collectReferences(String source, FXOMObject scope, List<FXOMNode> result) {
        assert (result != null);
        if (!(scope != null && scope == this || this.getType() != Type.FX_REFERENCE || source != null && !source.equals(this.getSource()))) {
            result.add(this);
        }
    }

    @Override
    protected void collectIncludes(String source, List<FXOMIntrinsic> result) {
        assert (result != null);
        if (this.getType() == Type.FX_INCLUDE && (source == null || source.equals(this.getSource()))) {
            result.add(this);
        }
    }

    @Override
    protected void collectFxIds(Map<String, FXOMObject> result) {
        String fxId = this.getFxId();
        if (fxId != null) {
            result.put(fxId, this);
        }
    }

    @Override
    protected void collectObjectWithSceneGraphObjectClass(Class<?> sceneGraphObjectClass, List<FXOMObject> result) {
    }

    @Override
    protected void collectEventHandlers(List<FXOMPropertyT> result) {
    }

    @Override
    public void documentLocationWillChange(URL newLocation) {
    }

    private static String makeTagNameFromType(Type type) {
        return switch (type.ordinal()) {
            case 2 -> "fx:copy";
            case 1 -> "fx:reference";
            case 0 -> "fx:include";
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                throw new IllegalStateException("Unexpected intrinsic type " + String.valueOf((Object)type));
            }
        };
    }

    public static enum Type {
        FX_INCLUDE,
        FX_REFERENCE,
        FX_COPY,
        UNDEFINED;

    }
}

