/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.fxom;

import com.oracle.javafx.scenebuilder.kit.editor.EditorPlatform;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMCollection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMFxIdMerger;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMIntrinsic;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMNode;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMNodes;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyT;
import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueElement;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PrefixedValue;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import com.oracle.javafx.scenebuilder.kit.util.JavaLanguage;
import com.oracle.javafx.scenebuilder.kit.util.URLUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.scene.Node;
import javafx.scene.Scene;

public abstract class FXOMObject
extends FXOMNode {
    private final GlueElement glueElement;
    private FXOMPropertyC parentProperty;
    private FXOMCollection parentCollection;
    private Object sceneGraphObject;

    FXOMObject(FXOMDocument fxomDocument, GlueElement glueElement, Object sceneGraphObject) {
        super(fxomDocument);
        assert (glueElement != null);
        assert (glueElement.getDocument() == fxomDocument.getGlue());
        this.glueElement = glueElement;
        this.sceneGraphObject = sceneGraphObject;
    }

    FXOMObject(FXOMDocument fxomDocument, String tagName) {
        super(fxomDocument);
        this.glueElement = new GlueElement(fxomDocument.getGlue(), tagName);
    }

    public GlueElement getGlueElement() {
        return this.glueElement;
    }

    public FXOMPropertyC getParentProperty() {
        return this.parentProperty;
    }

    public FXOMCollection getParentCollection() {
        return this.parentCollection;
    }

    public void addToParentProperty(int index, FXOMPropertyC newParentProperty) {
        assert (newParentProperty != null);
        assert (-1 <= index);
        assert (index <= newParentProperty.getValues().size());
        if (this.parentProperty != null) {
            if (this.parentProperty.getValues().size() == 1) {
                if (this.parentProperty.getParentInstance() != null) {
                    this.parentProperty.removeFromParentInstance();
                }
            } else {
                this.removeFromParentProperty();
            }
        } else if (this.parentCollection != null) {
            this.removeFromParentCollection();
        }
        this.parentProperty = newParentProperty;
        newParentProperty.addValue(index, this);
        GlueElement newParentElement = this.parentProperty.getGlueElement();
        this.glueElement.addToParent(index, newParentElement);
        this.resetRootProperties();
    }

    public void removeFromParentProperty() {
        assert (this.parentProperty != null);
        assert (this.parentProperty.getParentInstance() == null || this.parentProperty.getValues().size() >= 2);
        assert (this.glueElement.getParent() == this.parentProperty.getGlueElement());
        this.glueElement.removeFromParent();
        FXOMPropertyC keepParentProperty = this.parentProperty;
        this.parentProperty = null;
        keepParentProperty.removeValue(this);
    }

    public int getIndexInParentProperty() {
        int result;
        if (this.parentProperty == null) {
            result = -1;
        } else {
            result = this.parentProperty.getValues().indexOf(this);
            assert (result != -1);
        }
        return result;
    }

    public void addToParentCollection(int index, FXOMCollection newParentCollection) {
        assert (newParentCollection != null);
        assert (-1 <= index);
        assert (index <= newParentCollection.getItems().size());
        if (this.parentProperty != null) {
            this.removeFromParentProperty();
        } else if (this.parentCollection != null) {
            this.removeFromParentCollection();
        }
        this.parentCollection = newParentCollection;
        newParentCollection.addValue(index, this);
        GlueElement newParentElement = this.parentCollection.getGlueElement();
        this.glueElement.addToParent(index, newParentElement);
        this.resetRootProperties();
    }

    public void removeFromParentCollection() {
        assert (this.parentCollection != null);
        assert (this.glueElement.getParent() == this.parentCollection.getGlueElement());
        this.glueElement.removeFromParent();
        FXOMCollection keepParentCollection = this.parentCollection;
        this.parentCollection = null;
        keepParentCollection.removeValue(this);
    }

    public int getIndexInParentCollection() {
        int result;
        if (this.parentCollection == null) {
            result = -1;
        } else {
            result = this.parentCollection.getItems().indexOf(this);
            assert (result != -1);
        }
        return result;
    }

    public Object getSceneGraphObject() {
        return this.sceneGraphObject;
    }

    public void setSceneGraphObject(Object sceneGraphObject) {
        this.sceneGraphObject = sceneGraphObject;
    }

    public FXOMObject getNextSlibing() {
        FXOMObject result;
        if (this.parentProperty != null) {
            int index = this.getIndexInParentProperty();
            assert (index != -1);
            result = index + 1 < this.parentProperty.getValues().size() ? this.parentProperty.getValues().get(index + 1) : null;
        } else if (this.parentCollection != null) {
            int index = this.getIndexInParentCollection();
            assert (index != -1);
            result = index + 1 < this.parentCollection.getItems().size() ? this.parentCollection.getItems().get(index + 1) : null;
        } else {
            result = null;
        }
        return result;
    }

    public FXOMObject getPreviousSlibing() {
        FXOMObject result;
        if (this.parentProperty != null) {
            int index = this.getIndexInParentProperty();
            assert (index != -1);
            result = index - 1 >= 0 ? this.parentProperty.getValues().get(index - 1) : null;
        } else if (this.parentCollection != null) {
            int index = this.getIndexInParentCollection();
            assert (index != -1);
            result = index - 1 >= 0 ? this.parentCollection.getItems().get(index - 1) : null;
        } else {
            result = null;
        }
        return result;
    }

    public void moveBeforeSibling(FXOMObject sibling) {
        assert (sibling != this);
        assert (this.parentProperty != null || this.parentCollection != null);
        if (this.parentProperty != null) {
            assert (sibling == null || sibling.getParentProperty() == this.parentProperty);
            FXOMPropertyC oldParentProperty = this.parentProperty;
            this.removeFromParentProperty();
            assert (this.parentProperty == null);
            int index = sibling == null ? -1 : sibling.getIndexInParentProperty();
            this.addToParentProperty(index, oldParentProperty);
        } else if (this.parentCollection != null) {
            assert (sibling == null || sibling.getParentCollection() == this.parentCollection);
            FXOMCollection oldParentCollection = this.parentCollection;
            this.removeFromParentCollection();
            assert (this.parentCollection == null);
            int index = sibling == null ? -1 : sibling.getIndexInParentCollection();
            this.addToParentCollection(index, oldParentCollection);
        } else assert (false);
    }

    public Scene getScene() {
        Scene result;
        if (this.sceneGraphObject instanceof Node) {
            Node sceneGraphNode = (Node)this.sceneGraphObject;
            result = sceneGraphNode.getScene();
        } else {
            result = null;
        }
        return result;
    }

    public FXOMObject getFirstAncestorWithNonNullScene() {
        FXOMObject result;
        for (result = this; result != null && result.getScene() == null; result = result.getParentObject()) {
        }
        return result;
    }

    public FXOMObject searchWithSceneGraphObject(Object sceneGraphObject) {
        FXOMObject result = this.sceneGraphObject == sceneGraphObject ? this : null;
        return result;
    }

    public FXOMObject searchWithFxId(String fxId) {
        assert (fxId != null);
        FXOMObject result = fxId.equals(this.getFxId()) ? this : null;
        return result;
    }

    public Set<Class<?>> collectDeclaredClasses() {
        HashSet result = new HashSet();
        this.collectDeclaredClasses(result);
        return result;
    }

    protected abstract void collectDeclaredClasses(Set<Class<?>> var1);

    public List<FXOMProperty> collectProperties(PropertyName propertyName) {
        ArrayList<FXOMProperty> result = new ArrayList<FXOMProperty>();
        this.collectProperties(propertyName, result);
        return result;
    }

    protected abstract void collectProperties(PropertyName var1, List<FXOMProperty> var2);

    public List<FXOMPropertyT> collectNullProperties() {
        ArrayList<FXOMPropertyT> result = new ArrayList<FXOMPropertyT>();
        this.collectNullProperties(result);
        return result;
    }

    protected abstract void collectNullProperties(List<FXOMPropertyT> var1);

    public List<FXOMPropertyT> collectPropertiesT() {
        ArrayList<FXOMPropertyT> result = new ArrayList<FXOMPropertyT>();
        this.collectPropertiesT(result);
        return result;
    }

    protected abstract void collectPropertiesT(List<FXOMPropertyT> var1);

    public List<FXOMIntrinsic> collectReferences(String source) {
        ArrayList<FXOMIntrinsic> result = new ArrayList<FXOMIntrinsic>();
        this.collectReferences(source, result);
        return result;
    }

    protected abstract void collectReferences(String var1, List<FXOMIntrinsic> var2);

    public List<FXOMNode> collectReferences(String source, FXOMObject scope) {
        assert (source != null);
        ArrayList<FXOMNode> result = new ArrayList<FXOMNode>();
        this.collectReferences(source, scope, result);
        return result;
    }

    protected abstract void collectReferences(String var1, FXOMObject var2, List<FXOMNode> var3);

    public List<FXOMIntrinsic> collectIncludes(String source) {
        ArrayList<FXOMIntrinsic> result = new ArrayList<FXOMIntrinsic>();
        this.collectIncludes(source, result);
        return result;
    }

    protected abstract void collectIncludes(String var1, List<FXOMIntrinsic> var2);

    public Map<String, FXOMObject> collectFxIds() {
        LinkedHashMap<String, FXOMObject> result = new LinkedHashMap<String, FXOMObject>();
        this.collectFxIds(result);
        return result;
    }

    protected abstract void collectFxIds(Map<String, FXOMObject> var1);

    public List<FXOMObject> collectObjectWithSceneGraphObjectClass(Class<?> sceneGraphObjectClass) {
        ArrayList<FXOMObject> result = new ArrayList<FXOMObject>();
        this.collectObjectWithSceneGraphObjectClass(sceneGraphObjectClass, result);
        return result;
    }

    protected abstract void collectObjectWithSceneGraphObjectClass(Class<?> var1, List<FXOMObject> var2);

    public List<FXOMPropertyT> collectEventHandlers() {
        ArrayList<FXOMPropertyT> result = new ArrayList<FXOMPropertyT>();
        this.collectEventHandlers(result);
        return result;
    }

    protected abstract void collectEventHandlers(List<FXOMPropertyT> var1);

    public FXOMObject getParentObject() {
        FXOMObject result;
        if (this.parentProperty != null) {
            assert (this.parentCollection == null);
            result = this.parentProperty.getParentInstance();
        } else {
            result = this.parentCollection != null ? this.parentCollection : null;
        }
        return result;
    }

    public void removeFromParentObject() {
        if (this.parentProperty != null) {
            if (this.parentProperty.getValues().size() == 1) {
                if (this.parentProperty.getParentInstance() != null) {
                    this.parentProperty.removeFromParentInstance();
                }
            } else {
                this.removeFromParentProperty();
            }
        } else if (this.parentCollection != null) {
            this.removeFromParentCollection();
        }
    }

    public abstract List<FXOMObject> getChildObjects();

    public boolean isDescendantOf(FXOMObject other) {
        boolean result;
        if (other == null) {
            result = true;
        } else {
            FXOMObject ancestor;
            for (ancestor = this.getParentObject(); ancestor != other && ancestor != null; ancestor = ancestor.getParentObject()) {
            }
            result = ancestor != null;
        }
        return result;
    }

    public boolean isNode() {
        return this.sceneGraphObject instanceof Node;
    }

    public FXOMObject getClosestNode() {
        FXOMObject result = this;
        while (!result.isNode() && result.getParentObject() != null) {
            result = result.getParentObject();
        }
        return result.isNode() ? result : null;
    }

    public String getFxId() {
        return this.glueElement.getAttributes().get("fx:id");
    }

    public void setFxId(String fxId) {
        assert (fxId == null || JavaLanguage.isIdentifier(fxId));
        if (fxId == null) {
            this.glueElement.getAttributes().remove("fx:id");
        } else {
            this.glueElement.getAttributes().put("fx:id", fxId);
        }
    }

    public String getFxValue() {
        return this.glueElement.getAttributes().get("fx:value");
    }

    public void setFxValue(String fxValue) {
        if (fxValue == null) {
            this.glueElement.getAttributes().remove("fx:value");
        } else {
            this.glueElement.getAttributes().put("fx:value", fxValue);
        }
    }

    public String getFxConstant() {
        return this.glueElement.getAttributes().get("fx:constant");
    }

    public void setFxConstant(String fxConstant) {
        if (fxConstant == null) {
            this.glueElement.getAttributes().remove("fx:constant");
        } else {
            this.glueElement.getAttributes().put("fx:constant", fxConstant);
        }
    }

    public String getFxController() {
        return this.glueElement.getAttributes().get("fx:controller");
    }

    public void setFxController(String fxController) {
        if (fxController == null) {
            this.glueElement.getAttributes().remove("fx:controller");
        } else {
            this.glueElement.getAttributes().put("fx:controller", fxController);
        }
    }

    public String getFxFactory() {
        return this.glueElement.getAttributes().get("fx:factory");
    }

    public void setFxFactory(String fxFactory) {
        if (fxFactory == null) {
            this.glueElement.getAttributes().remove("fx:factory");
        } else {
            this.glueElement.getAttributes().put("fx:factory", fxFactory);
        }
    }

    public String getNameSpaceFX() {
        return this.glueElement.getAttributes().get("xmlns");
    }

    public void setNameSpaceFX(String nameSpace) {
        if (nameSpace == null) {
            this.glueElement.getAttributes().remove("xmlns");
        } else {
            this.glueElement.getAttributes().put("xmlns", nameSpace);
        }
    }

    public String getNameSpaceFXML() {
        return this.glueElement.getAttributes().get("xmlns:fx");
    }

    public void setNameSpaceFXML(String nameSpace) {
        if (nameSpace == null) {
            this.glueElement.getAttributes().remove("xmlns:fx");
        } else {
            this.glueElement.getAttributes().put("xmlns:fx", nameSpace);
        }
    }

    @Override
    public void moveToFxomDocument(FXOMDocument destination) {
        assert (destination != null);
        assert (destination != this.getFxomDocument());
        assert (this.parentProperty == null || this.parentProperty.getParentInstance() == null || this.parentProperty.getValues().size() >= 2);
        if (!URLUtils.equals(this.getFxomDocument().getLocation(), destination.getLocation())) {
            this.documentLocationWillChange(destination.getLocation());
        }
        Map<String, FXOMObject> destinationFxIds = destination.collectFxIds();
        Map<String, FXOMObject> importedFxIds = this.collectFxIds();
        FXOMFxIdMerger merger = new FXOMFxIdMerger(destinationFxIds.keySet(), importedFxIds.keySet());
        for (Map.Entry<String, FXOMObject> e : importedFxIds.entrySet()) {
            String originalFxId = e.getKey();
            FXOMObject fxomObject = e.getValue();
            assert (originalFxId.equals(fxomObject.getFxId()));
            String renamedFxId = merger.getRenamedFxId(originalFxId);
            assert (renamedFxId != null);
            if (renamedFxId.equals(originalFxId)) continue;
            fxomObject.setFxId(renamedFxId);
            PrefixedValue pv = new PrefixedValue(PrefixedValue.Type.EXPRESSION, renamedFxId);
            String newValue = pv.toString();
            for (FXOMPropertyT p : FXOMNodes.collectReferenceExpression(this, originalFxId)) {
                p.setValue(newValue);
            }
            for (FXOMObject o : FXOMNodes.serializeObjects(this)) {
                if (!(o instanceof FXOMIntrinsic)) continue;
                FXOMIntrinsic i = (FXOMIntrinsic)o;
                switch (i.getType()) {
                    case FX_REFERENCE: 
                    case FX_COPY: {
                        if (!i.getSource().equals(originalFxId)) break;
                        i.setSource(renamedFxId);
                        break;
                    }
                }
            }
        }
        if (this.parentProperty != null) {
            assert (this.parentProperty.getFxomDocument() == this.getFxomDocument());
            this.removeFromParentProperty();
        } else if (this.parentCollection != null) {
            assert (this.parentCollection.getFxomDocument() == this.getFxomDocument());
            this.removeFromParentCollection();
        } else if (this.getFxomDocument().getFxomRoot() == this) {
            this.getFxomDocument().setFxomRoot(null);
        }
        assert (this.parentProperty == null);
        assert (this.parentCollection == null);
        assert (this.glueElement.getParent() == null);
        this.glueElement.moveToDocument(destination.getGlue());
        this.changeFxomDocument(destination);
    }

    @Override
    protected void changeFxomDocument(FXOMDocument destination) {
        assert (destination != null);
        assert (destination != this.getFxomDocument());
        assert (destination.getGlue() == this.glueElement.getDocument());
        assert (this.parentProperty == null || destination == this.parentProperty.getFxomDocument());
        assert (this.parentCollection == null || destination == this.parentCollection.getFxomDocument());
        super.changeFxomDocument(destination);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName());
        result.append("[tagName=");
        result.append(this.glueElement.getTagName());
        if (this.getFxId() != null) {
            result.append(",fx:id=");
            result.append(this.getFxId());
        }
        result.append(']');
        return result.toString();
    }

    void setParentProperty(FXOMPropertyC newParentProperty) {
        assert (this.parentProperty == null);
        assert (this.parentCollection == null);
        assert (newParentProperty.getValues().contains(this));
        this.parentProperty = newParentProperty;
    }

    void setParentCollection(FXOMCollection newParentCollection) {
        assert (this.parentProperty == null);
        assert (this.parentCollection == null);
        assert (newParentCollection.getItems().contains(this));
        this.parentCollection = newParentCollection;
    }

    public boolean isClassFromExternalPlugin() {
        return this.sceneGraphObject != null && EditorPlatform.hasClassFromExternalPlugin(this.sceneGraphObject.getClass().getName());
    }

    private void resetRootProperties() {
        this.setFxController(null);
        this.setNameSpaceFX(null);
        this.setNameSpaceFXML(null);
    }
}

