/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.fxom;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMCollection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMIntrinsic;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyT;
import com.oracle.javafx.scenebuilder.kit.fxom.TransientStateBackup;
import com.oracle.javafx.scenebuilder.kit.metadata.Metadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.DoubleArrayPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.list.ListValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Set;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.SplitPane;
import javafx.stage.Window;

class FXOMRefresher {
    FXOMRefresher() {
    }

    public void refresh(FXOMDocument document) {
        String fxmlText = null;
        try {
            fxmlText = document.getFxmlText(false);
            FXOMDocument newDocument = new FXOMDocument(fxmlText, document.getLocation(), document.getClassLoader(), document.getResources(), new FXOMDocument.FXOMDocumentSwitch[0]);
            TransientStateBackup backup = new TransientStateBackup(document);
            if (newDocument.getSceneGraphRoot() == null && newDocument.getFxomRoot() == null) {
                this.removeIntrinsicProperty(document);
            } else {
                this.refreshDocument(document, newDocument);
            }
            backup.restore();
            this.synchronizeDividerPositions(document);
        }
        catch (IOException | RuntimeException x) {
            StringBuilder sb = new StringBuilder();
            sb.append("Bug in ");
            sb.append(this.getClass().getSimpleName());
            if (fxmlText != null) {
                try {
                    File fxmlFile = File.createTempFile("DTL-5996-", ".fxml");
                    try (PrintWriter pw = new PrintWriter(fxmlFile, "UTF-8");){
                        pw.write(fxmlText);
                        sb.append(": FXML dumped in ");
                        sb.append(fxmlFile.getPath());
                    }
                }
                catch (IOException xx) {
                    sb.append(": no FXML dumped");
                }
            } else {
                sb.append(": no FXML dumped");
            }
            throw new IllegalStateException(sb.toString(), x);
        }
    }

    private void removeIntrinsicProperty(FXOMDocument document) {
        FXOMPropertyC propertyC;
        FXOMInstance fxomRoot = (FXOMInstance)document.getFxomRoot();
        if (fxomRoot != null && (propertyC = (FXOMPropertyC)fxomRoot.getProperties().get(new PropertyName("children"))).getValues().get(0) instanceof FXOMIntrinsic) {
            FXOMIntrinsic fxomIntrinsic = (FXOMIntrinsic)propertyC.getValues().get(0);
            fxomIntrinsic.removeCharsetProperty();
        }
    }

    private void refreshDocument(FXOMDocument currentDocument, FXOMDocument newDocument) {
        Node displayNode;
        currentDocument.setSceneGraphRoot(newDocument.getSceneGraphRoot());
        currentDocument.setDisplayNode(newDocument.getDisplayNode());
        currentDocument.setDisplayStylesheets(newDocument.getDisplayStylesheets());
        if (currentDocument.getSceneGraphRoot() instanceof Parent) {
            Parent rootParent = (Parent)currentDocument.getSceneGraphRoot();
            rootParent.getStyleClass().add(0, (Object)"root");
        } else if ((currentDocument.getSceneGraphRoot() instanceof Scene || currentDocument.getSceneGraphRoot() instanceof Window) && (displayNode = currentDocument.getDisplayNode()) != null && displayNode instanceof Parent) {
            displayNode.getStyleClass().add(0, (Object)"root");
        }
        if (currentDocument.getFxomRoot() != null) {
            this.refreshFxomObject(currentDocument.getFxomRoot(), newDocument.getFxomRoot());
        }
    }

    private void refreshFxomObject(FXOMObject currentObject, FXOMObject newObject) {
        assert (currentObject != null);
        assert (newObject != null);
        assert (currentObject.getClass() == newObject.getClass());
        currentObject.setSceneGraphObject(newObject.getSceneGraphObject());
        if (currentObject instanceof FXOMInstance) {
            this.refreshFxomInstance((FXOMInstance)currentObject, (FXOMInstance)newObject);
        } else if (currentObject instanceof FXOMCollection) {
            this.refreshFxomCollection((FXOMCollection)currentObject, (FXOMCollection)newObject);
        } else if (currentObject instanceof FXOMIntrinsic) {
            this.refreshFxomIntrinsic((FXOMIntrinsic)currentObject, (FXOMIntrinsic)newObject);
        } else assert (false) : "Unexpected fxom object " + String.valueOf(currentObject);
    }

    private void refreshFxomInstance(FXOMInstance currentInstance, FXOMInstance newInstance) {
        assert (currentInstance != null);
        assert (newInstance != null);
        assert (currentInstance.getClass() == newInstance.getClass());
        currentInstance.setDeclaredClass(newInstance.getDeclaredClass());
        Set<PropertyName> currentNames = currentInstance.getProperties().keySet();
        Set<PropertyName> newNames = newInstance.getProperties().keySet();
        assert (currentNames.equals(newNames));
        for (PropertyName name : currentNames) {
            FXOMProperty currentProperty = currentInstance.getProperties().get(name);
            FXOMProperty newProperty = newInstance.getProperties().get(name);
            this.refreshFxomProperty(currentProperty, newProperty);
        }
    }

    private void refreshFxomCollection(FXOMCollection currentCollection, FXOMCollection newCollection) {
        assert (currentCollection != null);
        assert (newCollection != null);
        currentCollection.setDeclaredClass(newCollection.getDeclaredClass());
        this.refreshFxomObjects(currentCollection.getItems(), newCollection.getItems());
    }

    private void refreshFxomIntrinsic(FXOMIntrinsic currentIntrinsic, FXOMIntrinsic newIntrinsic) {
        assert (currentIntrinsic != null);
        assert (newIntrinsic != null);
        currentIntrinsic.setSourceSceneGraphObject(newIntrinsic.getSourceSceneGraphObject());
        currentIntrinsic.getProperties().clear();
        currentIntrinsic.fillProperties(newIntrinsic.getProperties());
    }

    private void refreshFxomProperty(FXOMProperty currentProperty, FXOMProperty newProperty) {
        assert (currentProperty != null);
        assert (newProperty != null);
        assert (currentProperty.getName().equals(newProperty.getName()));
        if (currentProperty instanceof FXOMPropertyT) {
            assert (newProperty instanceof FXOMPropertyT);
            assert (((FXOMPropertyT)currentProperty).getValue().equals(((FXOMPropertyT)newProperty).getValue()));
        } else {
            assert (currentProperty instanceof FXOMPropertyC);
            assert (newProperty instanceof FXOMPropertyC);
            FXOMPropertyC currentPC = (FXOMPropertyC)currentProperty;
            FXOMPropertyC newPC = (FXOMPropertyC)newProperty;
            this.refreshFxomObjects(currentPC.getValues(), newPC.getValues());
        }
    }

    private void refreshFxomObjects(List<FXOMObject> currentObjects, List<FXOMObject> newObjects) {
        assert (currentObjects != null);
        assert (newObjects != null);
        assert (currentObjects.size() == newObjects.size());
        int count = currentObjects.size();
        for (int i = 0; i < count; ++i) {
            FXOMObject currentObject = currentObjects.get(i);
            FXOMObject newObject = newObjects.get(i);
            if (currentObject instanceof FXOMIntrinsic || newObject instanceof FXOMIntrinsic) {
                this.handleRefreshIntrinsic(currentObject, newObject);
                continue;
            }
            this.refreshFxomObject(currentObject, newObject);
        }
    }

    private void handleRefreshIntrinsic(FXOMObject currentObject, FXOMObject newObject) {
        if (currentObject instanceof FXOMIntrinsic && newObject instanceof FXOMIntrinsic) {
            this.refreshFxomObject(currentObject, newObject);
        } else if (newObject instanceof FXOMIntrinsic) {
            FXOMInstance fxomInstance = this.getFxomInstance((FXOMIntrinsic)newObject);
            this.refreshFxomObject(currentObject, fxomInstance);
        } else if (currentObject instanceof FXOMIntrinsic) {
            FXOMInstance fxomInstance = this.getFxomInstance((FXOMIntrinsic)currentObject);
            this.refreshFxomObject(fxomInstance, newObject);
        }
    }

    private FXOMInstance getFxomInstance(FXOMIntrinsic intrinsic) {
        FXOMInstance fxomInstance = new FXOMInstance(intrinsic.getFxomDocument(), intrinsic.getGlueElement());
        fxomInstance.setSceneGraphObject(intrinsic.getSourceSceneGraphObject());
        fxomInstance.setDeclaredClass(intrinsic.getClass());
        if (!intrinsic.getProperties().isEmpty()) {
            fxomInstance.fillProperties(intrinsic.getProperties());
        }
        return fxomInstance;
    }

    private void synchronizeDividerPositions(FXOMDocument document) {
        FXOMObject fxomRoot = document.getFxomRoot();
        if (fxomRoot != null) {
            Metadata metadata = Metadata.getMetadata();
            PropertyName dividerPositionsName = new PropertyName("dividerPositions");
            List<FXOMObject> candidates = fxomRoot.collectObjectWithSceneGraphObjectClass(SplitPane.class);
            for (FXOMObject fxomObject : candidates) {
                if (!(fxomObject instanceof FXOMInstance)) continue;
                FXOMInstance fxomInstance = (FXOMInstance)fxomObject;
                assert (fxomInstance.getSceneGraphObject() instanceof SplitPane);
                SplitPane splitPane = (SplitPane)fxomInstance.getSceneGraphObject();
                splitPane.layout();
                ValuePropertyMetadata vpm = metadata.queryValueProperty(fxomInstance, dividerPositionsName);
                assert (vpm instanceof ListValuePropertyMetadata) : "vpm.getClass()=" + vpm.getClass().getSimpleName();
                DoubleArrayPropertyMetadata davpm = (DoubleArrayPropertyMetadata)vpm;
                davpm.synchronizeWithSceneGraphObject(fxomInstance);
            }
        }
    }
}

