/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.fxom;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueInstruction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javafx.fxml.FXMLLoader;

class FXOMSaver {
    private boolean wildcardImports;
    private static final String NAME_SPACE_FX = "http://javafx.com/javafx/" + FXMLLoader.JAVAFX_VERSION;
    private static final String NAME_SPACE_FXML = "http://javafx.com/fxml/1";

    FXOMSaver() {
    }

    FXOMSaver(boolean wildcardImports) {
        this.wildcardImports = wildcardImports;
    }

    public String save(FXOMDocument fxomDocument) {
        assert (fxomDocument != null);
        assert (fxomDocument.getGlue() != null);
        if (fxomDocument.getFxomRoot() != null) {
            this.updateNameSpace(fxomDocument);
            this.updateImportInstructions(fxomDocument);
        }
        return fxomDocument.getGlue().toString();
    }

    private void updateNameSpace(FXOMDocument fxomDocument) {
        assert (fxomDocument.getFxomRoot() != null);
        FXOMObject fxomRoot = fxomDocument.getFxomRoot();
        String currentNameSpaceFX = fxomRoot.getNameSpaceFX();
        String currentNameSpaceFXML = fxomRoot.getNameSpaceFXML();
        if (currentNameSpaceFX == null || !currentNameSpaceFX.equals(NAME_SPACE_FX)) {
            fxomRoot.setNameSpaceFX(NAME_SPACE_FX);
        }
        if (currentNameSpaceFXML == null || !currentNameSpaceFXML.equals(NAME_SPACE_FXML)) {
            fxomRoot.setNameSpaceFXML(NAME_SPACE_FXML);
        }
    }

    private void updateImportInstructions(FXOMDocument fxomDocument) {
        assert (fxomDocument.getFxomRoot() != null);
        List<GlueInstruction> importList = this.getHeaderIncludes(fxomDocument);
        this.synchronizeHeader(fxomDocument.getGlue(), importList);
    }

    private List<GlueInstruction> getHeaderIncludes(FXOMDocument fxomDocument) {
        TreeSet<String> imports = new TreeSet<String>();
        fxomDocument.getFxomRoot().collectDeclaredClasses().forEach(dc -> imports.add((String)(this.wildcardImports ? dc.getPackageName() + ".*" : dc.getCanonicalName())));
        FXOMObject root = fxomDocument.getFxomRoot();
        imports.addAll(this.findPropertyClasses((FXOMObject[])root.getChildObjects().toArray(FXOMObject[]::new)));
        imports.addAll(this.findPropertyClasses(root));
        return this.createGlueInstructionsForImports(fxomDocument, imports);
    }

    private Set<String> findPropertyClasses(FXOMObject ... fxomObjects) {
        return Arrays.stream(fxomObjects).map(FXOMObject::collectPropertiesT).flatMap(Collection::stream).map(FXOMProperty::getName).filter(prop -> prop.getResidenceClass() != null).map(prop -> this.wildcardImports ? prop.getResidenceClass().getPackageName() + ".*" : prop.getResidenceClass().getName()).collect(Collectors.toSet());
    }

    private List<GlueInstruction> createGlueInstructionsForImports(FXOMDocument fxomDocument, Set<String> imports) {
        ArrayList<GlueInstruction> importsList = new ArrayList<GlueInstruction>();
        imports.forEach(name -> {
            GlueInstruction instruction = new GlueInstruction(fxomDocument.getGlue(), "import", (String)name);
            importsList.add(instruction);
        });
        return importsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeHeader(GlueDocument glue, List<GlueInstruction> importList) {
        FXOMSaver fXOMSaver = this;
        synchronized (fXOMSaver) {
            int firstImportIndex;
            List<GlueInstruction> existingImports = glue.collectInstructions("import");
            if (existingImports.isEmpty()) {
                firstImportIndex = 0;
            } else {
                GlueInstruction firstImport = existingImports.get(0);
                firstImportIndex = glue.getHeader().indexOf(firstImport);
            }
            glue.getHeader().removeIf(glueAuxiliary -> glueAuxiliary instanceof GlueInstruction && "import".equals(((GlueInstruction)glueAuxiliary).getTarget()));
            glue.getHeader().addAll(firstImportIndex, importList);
        }
    }
}

