/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.fxom;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class FxIdCollector {
    private final Set<String> fxIds = new HashSet<String>();
    private Map<String, Integer> nextIndexes;

    public FxIdCollector(Set<String> fxIds) {
        assert (fxIds != null);
        this.fxIds.addAll(fxIds);
    }

    public FxIdCollector(FXOMDocument fxomDocument) {
        this(fxomDocument.collectFxIds().keySet());
    }

    public String importFxId(String sourceFxId) {
        Object result;
        assert (sourceFxId != null);
        if (this.fxIds.contains(sourceFxId)) {
            if (this.nextIndexes == null) {
                this.createNextIndexes();
                assert (this.nextIndexes != null);
            }
            PrefixSuffix pf = new PrefixSuffix(sourceFxId);
            Integer nextIndex = this.nextIndexes.get(pf.getPrefix());
            assert (nextIndex != null);
            result = pf.getPrefix() + nextIndex;
        } else {
            result = sourceFxId;
        }
        this.fxIds.add((String)result);
        if (this.nextIndexes != null) {
            this.updateNextIndexes((String)result);
        }
        return result;
    }

    private void createNextIndexes() {
        this.nextIndexes = new HashMap<String, Integer>();
        for (String fxId : this.fxIds) {
            this.updateNextIndexes(fxId);
        }
    }

    private void updateNextIndexes(String fxId) {
        assert (this.nextIndexes != null);
        PrefixSuffix pf = new PrefixSuffix(fxId);
        Integer nextIndex = this.nextIndexes.get(pf.getPrefix());
        if (nextIndex == null || pf.getSuffix() >= nextIndex) {
            this.nextIndexes.put(pf.getPrefix(), pf.getSuffix() + 1);
        }
    }

    private static class PrefixSuffix {
        private final String prefix;
        private final int suffix;

        public PrefixSuffix(String fxId) {
            int endIndex;
            assert (fxId != null);
            assert (!fxId.isEmpty());
            for (endIndex = fxId.length(); endIndex >= 1 && Character.isDigit(fxId.charAt(endIndex - 1)); --endIndex) {
            }
            if (endIndex < fxId.length()) {
                this.prefix = fxId.substring(0, endIndex);
                this.suffix = Integer.parseInt(fxId.substring(endIndex));
            } else {
                this.prefix = fxId;
                this.suffix = -1;
            }
        }

        public String getPrefix() {
            return this.prefix;
        }

        public int getSuffix() {
            return this.suffix;
        }

        public String toString() {
            return this.suffix == -1 ? this.prefix : this.prefix + this.suffix;
        }
    }
}

