/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.glossary;

import com.oracle.javafx.scenebuilder.kit.glossary.JavaTokenizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ControllerClass {
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("#package# (.*?)#;#");
    private static final Pattern CLASS_PATTERN = Pattern.compile("#class# (.*?)\\s");
    private static final Pattern INITIALIZABLE_PATTERN = Pattern.compile("#implements# (.*?)\\s#\\{#");
    private static final Pattern FXID_PATTERN_1 = Pattern.compile("#@#FXML#(\\s*?[^\\(]*?\\s*?)[;|=]#");
    private static final Pattern FXID_PATTERN_2 = Pattern.compile("#public#(\\s*?[^\\(\\{]*?\\s*?)[;|=]#");
    private static final Pattern EVENT_PATTERN_1 = Pattern.compile("#@#FXML#(\\s*?[^=]*?\\s*?)#\\{#");
    private static final String anyMethodToken = "\\s*?[^\\(\\{]*?\\s*?";
    private static final String staticFinalToken = "\\s*?(?:#static#|#final#)?\\s*?";
    private static final String voidToken = "\\s*?#void#\\s*?";
    private static final String publicToken = "#public#";
    private static final String methodNameToken = "#[^\\(\\{]*?#\\s*?#?";
    private static final String typeEventToken = "#\\s*?.*?Event#\\s*?#";
    private static final String argEventToken = ".*?#\\s*?#?";
    private static final String throwsToken = "\\s*?(?:#throws#)?\\s*?";
    private static final String exceptionToken = "\\s*?[^\\(\\{]*?\\s*?";
    private static final String startBlockToken = "#?\\{#";
    private static final Pattern EVENT_PATTERN_2 = Pattern.compile("#public#\\s*?(?:#static#|#final#)?\\s*?\\s*?(?:#static#|#final#)?\\s*?\\s*?#void#\\s*?(#[^\\(\\{]*?#\\s*?#?\\(#\\s*?.*?Event#\\s*?#.*?#\\s*?#?\\)#)\\s*?(?:#throws#)?\\s*?\\s*?[^\\(\\{]*?\\s*?#?\\{#");
    private static final Pattern EVENT_PATTERN_3 = Pattern.compile("#public#\\s*?(?:#static#|#final#)?\\s*?\\s*?(?:#static#|#final#)?\\s*?\\s*?#void#\\s*?(#[^\\(\\{]*?#\\s*?#?\\(#\\s*?#?\\)#)\\s*?(?:#throws#)?\\s*?\\s*?[^\\(\\{]*?\\s*?#?\\{#");
    private final String javaContent;
    private final String tokenizedContent;
    private final boolean isInitializable;
    private final File file;
    private final String className;
    private Set<String> fxids;
    private Set<String> events;
    private static final String FILE_SEPARATOR = FileSystems.getDefault().getSeparator();
    private static final String MAVEN_JAVA_SOURCES_DIR = "java";
    private static final String MAVEN_RESOURCES_DIR = "resources";
    private static final String MAVEN_DIR_PATTERN_STRING = "(.*src" + FILE_SEPARATOR + "(?:main|test)" + FILE_SEPARATOR + ")resources(" + FILE_SEPARATOR + "(?:.*))";
    private static final Pattern MAVEN_DIR_PATTERN = Pattern.compile(FILE_SEPARATOR.equals("\\") ? MAVEN_DIR_PATTERN_STRING.replace("\\", "\\\\") : MAVEN_DIR_PATTERN_STRING);
    private static final String MAVEN_DIR_REPLACEMENT_STRING = "$1java$2";
    private static final boolean IGNORE_MAVEN_DIR_STRUCTURE = System.getProperty("ignore.maven.structure") != null;

    private ControllerClass(File file) throws IOException, JavaTokenizer.ParseException {
        assert (file != null);
        this.file = file;
        this.javaContent = ControllerClass.readFile(file);
        this.tokenizedContent = JavaTokenizer.tokenize(this.javaContent);
        this.className = ControllerClass.retrieveControllerClassName(this.tokenizedContent);
        assert (this.className != null);
        this.isInitializable = this.retrieveInitializableInterface();
    }

    public String getClassName() {
        return this.className;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isInitializable() {
        return this.isInitializable;
    }

    public static Set<ControllerClass> discoverFXMLControllerClasses(File fxmlFile) {
        Matcher matcher;
        ScanData data = new ScanData();
        File parentFile = fxmlFile.getParentFile();
        if (!IGNORE_MAVEN_DIR_STRUCTURE && (matcher = MAVEN_DIR_PATTERN.matcher(parentFile.getAbsolutePath())).matches()) {
            parentFile = new File(matcher.replaceFirst(MAVEN_DIR_REPLACEMENT_STRING));
        }
        try {
            String name = ControllerClass.getNoExtensionName(fxmlFile);
            int maxDepth = 2;
            for (int i = 0; i < maxDepth; ++i) {
                ControllerClass.scanDirectory(name, parentFile, data);
                if (data.continueScanning()) {
                    continue;
                }
                break;
            }
        }
        catch (RuntimeException ex) {
            System.err.println(ex);
        }
        return data.getClasses();
    }

    private static void scanDirectory(String name, File directory, ScanData data) {
        try {
            File f2;
            File f = new File(directory, name + ".java");
            if (f.exists()) {
                try {
                    ControllerClass clazz = new ControllerClass(f);
                    data.add(clazz);
                }
                catch (JavaTokenizer.ParseException | IOException clazz) {
                    // empty catch block
                }
            }
            if ((f2 = new File(directory, name + "Controller.java")).exists()) {
                try {
                    ControllerClass clazz = new ControllerClass(f2);
                    data.add(clazz);
                }
                catch (JavaTokenizer.ParseException | IOException exception) {
                    // empty catch block
                }
            }
            for (File javaFile : ControllerClass.filterJavaFiles(directory)) {
                if (javaFile.equals(f) || javaFile.equals(f2)) continue;
                try {
                    ControllerClass clazz = new ControllerClass(javaFile);
                    if (!clazz.getFxIds().isEmpty() || !clazz.getEventHandlers().isEmpty() || clazz.isInitializable()) {
                        data.add(clazz);
                    } else {
                        data.javaScanned();
                    }
                }
                catch (JavaTokenizer.ParseException | IOException exception) {
                    // empty catch block
                }
                if (data.continueScanning()) continue;
                return;
            }
        }
        catch (RuntimeException ex) {
            System.err.println(ex);
        }
    }

    private static String getNoExtensionName(File file) {
        String name = file.getName();
        int index = name.lastIndexOf(46);
        if (index == -1) {
            index = name.length();
        }
        return name.substring(0, index);
    }

    private static File[] filterJavaFiles(File directory) {
        ArrayList fileList = new ArrayList();
        FilenameFilter ff = (dir, name) -> {
            File file;
            if (name.endsWith(".java") && (file = new File(dir, name)).canRead() && !file.isDirectory()) {
                fileList.add(file);
                return true;
            }
            return false;
        };
        if (directory != null) {
            directory.list(ff);
        }
        return fileList.toArray(new File[fileList.size()]);
    }

    private static String retrieveControllerClassName(String content) {
        Object clazzName = null;
        Matcher m = CLASS_PATTERN.matcher(content);
        if (m.find()) {
            clazzName = m.group(1);
            clazzName = ((String)clazzName).replaceAll("#", "");
        }
        if ((m = PACKAGE_PATTERN.matcher(content)).find()) {
            String packageName = m.group(1);
            packageName = packageName.replaceAll("#", "");
            clazzName = packageName + "." + (String)clazzName;
        }
        return clazzName;
    }

    private boolean retrieveInitializableInterface() {
        List<String> str = this.extract(INITIALIZABLE_PATTERN);
        if (str.isEmpty()) {
            return false;
        }
        for (String s : str) {
            if (!s.contains("Initializable")) continue;
            return true;
        }
        return false;
    }

    private static List<String> extract(Pattern p, String content) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher m = p.matcher(content);
        while (m.find()) {
            result.add(m.group(1));
        }
        return Collections.unmodifiableList(result);
    }

    private List<String> extract(Pattern p) {
        return ControllerClass.extract(p, this.tokenizedContent);
    }

    public Set<String> getFxIds() {
        if (this.fxids == null) {
            Set<String> fxids1 = ControllerClass.cleanFxIds(this.extract(FXID_PATTERN_1));
            Set<String> fxids2 = ControllerClass.cleanFxIds(this.extract(FXID_PATTERN_2));
            this.fxids = new HashSet<String>();
            this.fxids.addAll(fxids1);
            this.fxids.addAll(fxids2);
        }
        return this.fxids;
    }

    public Set<String> getEventHandlers() {
        if (this.events == null) {
            List<String> events1 = this.extract(EVENT_PATTERN_1);
            List<String> events2 = this.extract(EVENT_PATTERN_2);
            List<String> events3 = this.extract(EVENT_PATTERN_3);
            this.events = new HashSet<String>();
            this.events.addAll(ControllerClass.cleanEvents(events1));
            this.events.addAll(ControllerClass.cleanEvents(events2));
            this.events.addAll(ControllerClass.cleanEvents(events3));
        }
        return this.events;
    }

    private static List<String> cleanEvents(List<String> extracted) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String str : extracted) {
            String subStr;
            String cleaned;
            int index = str.indexOf("#(#");
            if (index == -1 || (cleaned = ControllerClass.lastJavaIdentifierPart(subStr = str.substring(0, index))) == null) continue;
            ret.add(cleaned);
        }
        return ret;
    }

    private static Set<String> cleanFxIds(List<String> extracted) {
        HashSet<String> ret = new HashSet<String>();
        for (String str : extracted) {
            String instanceName = ControllerClass.lastJavaIdentifierPart(str);
            if (instanceName == null) continue;
            ret.add(instanceName);
        }
        return ret;
    }

    private static String lastJavaIdentifierPart(String str) {
        try {
            int index;
            assert (str != null);
            for (index = str.length() - 1; !Character.isJavaIdentifierPart(str.charAt(index)) && index >= 0; --index) {
            }
            int indexEnd = index + 1;
            while (Character.isJavaIdentifierPart(str.charAt(index)) && index >= 0) {
                --index;
            }
            int indexStart = index + 1;
            return str.substring(indexStart, indexEnd);
        }
        catch (RuntimeException ex) {
            System.err.println(ex);
            return null;
        }
    }

    private static String readFile(File file) throws FileNotFoundException, IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader bufReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("UTF-8")));){
            String line;
            while ((line = bufReader.readLine()) != null) {
                sb.append(line).append("\n");
            }
        }
        return sb.toString();
    }

    private static class ScanData {
        private Set<ControllerClass> files = new HashSet<ControllerClass>();
        private int numJavaParsed;

        private ScanData() {
        }

        private boolean continueScanning() {
            return this.numJavaParsed < 200 && this.files.size() < 100;
        }

        private void javaScanned() {
            ++this.numJavaParsed;
        }

        private void add(ControllerClass clazz) {
            ++this.numJavaParsed;
            this.files.add(clazz);
        }

        private Set<ControllerClass> getClasses() {
            return this.files;
        }
    }
}

