/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.library;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.library.Library;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LibraryItem {
    private final String name;
    private final String section;
    private final String fxmlText;
    private final URL iconURL;
    private final Library library;

    public LibraryItem(String name, String section, String fxmlText, URL iconURL, Library library) {
        assert (name != null);
        assert (fxmlText != null);
        assert (library != null);
        this.name = name;
        this.section = section;
        this.fxmlText = fxmlText;
        this.library = library;
        this.iconURL = iconURL;
    }

    public String getName() {
        return this.name;
    }

    public String getSection() {
        return this.section;
    }

    public String getFxmlText() {
        return this.fxmlText;
    }

    public URL getIconURL() {
        return this.iconURL;
    }

    public Library getLibrary() {
        return this.library;
    }

    public FXOMDocument instantiate() {
        FXOMDocument result;
        try {
            result = new FXOMDocument(this.fxmlText, null, this.library.getClassLoader(), null, FXOMDocument.FXOMDocumentSwitch.NORMALIZED);
        }
        catch (IOException | Error e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Failed to instantiate a library item: ", e);
            result = null;
        }
        return result;
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.name);
        hash = 67 * hash + Objects.hashCode(this.section);
        hash = 67 * hash + Objects.hashCode(this.fxmlText);
        hash = 67 * hash + Objects.hashCode(this.iconURL);
        hash = 67 * hash + Objects.hashCode(this.library);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LibraryItem other = (LibraryItem)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.section, other.section)) {
            return false;
        }
        if (!Objects.equals(this.fxmlText, other.fxmlText)) {
            return false;
        }
        if (!Objects.equals(this.iconURL, other.iconURL)) {
            return false;
        }
        return Objects.equals(this.library, other.library);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName());
        result.append('[');
        result.append(this.name);
        result.append(']');
        return result.toString();
    }
}

