/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.library.user;

import com.oracle.javafx.scenebuilder.kit.editor.images.ImageUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.LibraryUtil;
import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.library.BuiltinLibrary;
import com.oracle.javafx.scenebuilder.kit.library.LibraryItem;
import com.oracle.javafx.scenebuilder.kit.library.user.UserLibrary;
import com.oracle.javafx.scenebuilder.kit.library.util.FolderExplorer;
import com.oracle.javafx.scenebuilder.kit.library.util.JarExplorer;
import com.oracle.javafx.scenebuilder.kit.library.util.JarReport;
import com.oracle.javafx.scenebuilder.kit.library.util.JarReportEntry;
import com.oracle.javafx.scenebuilder.kit.library.util.ModuleExplorer;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.module.ModuleReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;

class LibraryFolderWatcher
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(LibraryFolderWatcher.class.getSimpleName());
    private final UserLibrary library;
    private static final List<String> JAVAFX_MODULES = Arrays.asList("javafx-base", "javafx-graphics", "javafx-controls", "javafx-fxml", "javafx-media", "javafx-web", "javafx-swing");

    public LibraryFolderWatcher(UserLibrary library) {
        this.library = library;
    }

    @Override
    public void run() {
        try {
            this.library.updateExplorationCount(0);
            this.library.updateExplorationDate(new Date());
            this.runDiscovery();
            this.runWatching();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDiscovery() throws InterruptedException {
        this.library.setItems((Collection<LibraryItem>)BuiltinLibrary.getLibrary().getItems());
        List<Path> additionalJars = this.library.getAdditionalJarPaths().get();
        HashSet<Path> currentJarsOrFolders = new HashSet<Path>(additionalJars);
        HashSet<Path> currentFxmls = new HashSet<Path>();
        Path folder = Paths.get(this.library.getPath(), new String[0]);
        if (folder != null && folder.toFile().exists()) {
            boolean retry;
            do {
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(folder);){
                    for (Path entry : stream) {
                        if (LibraryUtil.isJarPath(entry)) {
                            currentJarsOrFolders.add(entry);
                            continue;
                        }
                        if (LibraryUtil.isFxmlPath(entry)) {
                            currentFxmls.add(entry);
                            continue;
                        }
                        if (!LibraryUtil.isFolderMarkerPath(entry)) continue;
                        List<Path> folderPaths = LibraryUtil.getFolderPaths(entry);
                        for (Path f : folderPaths) {
                            currentJarsOrFolders.add(f);
                        }
                    }
                    retry = false;
                }
                catch (IOException x) {
                    Thread.sleep(2000L);
                    retry = true;
                }
                finally {
                    this.library.updateExplorationCount(this.library.getExplorationCount() + 1);
                }
            } while (retry && this.library.getExplorationCount() < 10);
        }
        try {
            this.library.setExploring(true);
            try {
                this.updateLibrary(currentFxmls);
                this.exploreAndUpdateLibrary(currentJarsOrFolders);
            }
            finally {
                this.library.setExploring(false);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWatching() throws InterruptedException {
        WatchService watchService = null;
        try {
            block11: while (true) {
                Path folder = Paths.get(this.library.getPath(), new String[0]);
                while (watchService == null) {
                    try {
                        watchService = folder.getFileSystem().newWatchService();
                    }
                    catch (IOException x) {
                        System.out.println("FileSystem.newWatchService() failed");
                        System.out.println("Sleeping...");
                        Thread.sleep(1000L);
                    }
                }
                WatchKey watchKey = null;
                while (true) {
                    if (watchKey != null && watchKey.isValid()) continue block11;
                    try {
                        WatchKey wk;
                        watchKey = folder.register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                        do {
                            wk = watchService.take();
                            assert (wk == watchKey);
                            boolean isDirty = false;
                            for (WatchEvent<?> e : wk.pollEvents()) {
                                WatchEvent.Kind<?> kind = e.kind();
                                Object context = e.context();
                                if (kind == StandardWatchEventKinds.ENTRY_CREATE || kind == StandardWatchEventKinds.ENTRY_DELETE || kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                                    assert (context instanceof Path);
                                    if (LibraryUtil.isJarPath((Path)context)) {
                                        if (this.hasJarBeenAdded((Path)context)) continue;
                                        isDirty = true;
                                        continue;
                                    }
                                    if (LibraryUtil.isFxmlPath((Path)context)) {
                                        isDirty = true;
                                        continue;
                                    }
                                    if (!LibraryUtil.isFolderMarkerPath((Path)context)) continue;
                                    isDirty = true;
                                    continue;
                                }
                                assert (kind == StandardWatchEventKinds.OVERFLOW);
                            }
                            if (!isDirty) continue;
                            this.library.setExploring(true);
                            try {
                                this.library.setItems((Collection<LibraryItem>)BuiltinLibrary.getLibrary().getItems());
                                List<Path> currentMavenJars = this.library.getAdditionalJarPaths().get();
                                HashSet<Path> fxmls = new HashSet<Path>();
                                fxmls.addAll(this.getAllFiles(FILE_TYPE.FXML));
                                this.updateLibrary(fxmls);
                                HashSet<Path> jarsAndFolders = new HashSet<Path>(currentMavenJars);
                                jarsAndFolders.addAll(this.getAllFiles(FILE_TYPE.JAR));
                                Set<Path> foldersMarkers = this.getAllFiles(FILE_TYPE.FOLDER_MARKER);
                                for (Path path : foldersMarkers) {
                                    List<Path> folderPaths = LibraryUtil.getFolderPaths(path);
                                    for (Path f : folderPaths) {
                                        jarsAndFolders.add(f);
                                    }
                                }
                                this.exploreAndUpdateLibrary(jarsAndFolders);
                                this.library.updateExplorationCount(this.library.getExplorationCount() + 1);
                            }
                            finally {
                                this.library.setExploring(false);
                            }
                        } while (wk.reset());
                    }
                    catch (IOException x) {
                        Thread.sleep(1000L);
                    }
                }
                break;
            }
        }
        catch (Throwable throwable) {
            if (watchService != null) {
                try {
                    watchService.close();
                }
                catch (IOException e) {
                    LOGGER.severe("Error closing FileSystemWatchService: " + e.getMessage());
                }
            }
            throw throwable;
        }
    }

    private Set<Path> getAllFiles(FILE_TYPE fileType) throws IOException {
        HashSet<Path> res = new HashSet<Path>();
        Path folder = Paths.get(this.library.getPath(), new String[0]);
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(folder);){
            for (Path p : ds) {
                switch (fileType.ordinal()) {
                    case 0: {
                        if (!LibraryUtil.isFxmlPath(p)) break;
                        res.add(p);
                        break;
                    }
                    case 1: {
                        if (!LibraryUtil.isJarPath(p)) break;
                        res.add(p);
                        break;
                    }
                    case 2: {
                        if (!LibraryUtil.isFolderMarkerPath(p)) break;
                        res.add(p);
                        break;
                    }
                }
            }
        }
        return res;
    }

    private boolean hasJarBeenAdded(Path context) {
        boolean hasJarBeenAdded = false;
        for (JarReport report : this.library.getJarReports()) {
            if (!report.getJar().getFileName().equals(context)) continue;
            hasJarBeenAdded = true;
            break;
        }
        return hasJarBeenAdded;
    }

    private void updateLibrary(Collection<Path> paths) throws IOException {
        ArrayList<LibraryItem> newItems = new ArrayList<LibraryItem>();
        for (Path path : paths) {
            newItems.add(this.makeLibraryItem(path));
        }
        this.library.addItems(newItems);
        this.library.updateFxmlFileReports(paths);
        this.library.updateExplorationDate(new Date());
    }

    private LibraryItem makeLibraryItem(Path path) throws IOException {
        URL iconURL = ImageUtils.getNodeIconURL(null);
        String fileName = path.getFileName().toString();
        String itemName = fileName.substring(0, fileName.indexOf(".fxml"));
        String fxmlText = "";
        StringBuilder buf = new StringBuilder();
        try (LineNumberReader reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(path.toFile()), "UTF-8"));){
            String line;
            while ((line = reader.readLine()) != null) {
                buf.append(line).append("\n");
            }
            fxmlText = buf.toString();
        }
        LibraryItem res = new LibraryItem(itemName, "Custom", fxmlText, iconURL, this.library);
        return res;
    }

    private void exploreAndUpdateLibrary(Collection<Path> modulesOrJarsOrFolders) throws IOException {
        URLClassLoader classLoader = modulesOrJarsOrFolders.isEmpty() ? null : new URLClassLoader(this.makeURLArrayFromPaths(modulesOrJarsOrFolders));
        ArrayList<JarReport> moduleOrJarOrFolderReports = new ArrayList<JarReport>();
        for (Path currentModuleOrJarOrFolder : modulesOrJarsOrFolders) {
            JarReport jarReport;
            String jarName = currentModuleOrJarOrFolder.getName(currentModuleOrJarOrFolder.getNameCount() - 1).toString();
            if (JAVAFX_MODULES.stream().anyMatch(jarName::startsWith)) continue;
            String resultText = "";
            Optional<ModuleReference> moduleReference = LibraryUtil.getModuleReference(currentModuleOrJarOrFolder);
            if (moduleReference.isPresent()) {
                LOGGER.info(I18N.getString("log.info.explore.module", moduleReference.get().descriptor()));
                explorer = new ModuleExplorer(moduleReference.get());
                jarReport = ((ModuleExplorer)explorer).explore();
                resultText = I18N.getString("log.info.explore.module.results", jarName);
            } else if (LibraryUtil.isJarPath(currentModuleOrJarOrFolder)) {
                LOGGER.info(I18N.getString("log.info.explore.jar", currentModuleOrJarOrFolder));
                explorer = new JarExplorer(currentModuleOrJarOrFolder);
                jarReport = ((JarExplorer)explorer).explore(classLoader);
                resultText = I18N.getString("log.info.explore.jar.results", jarName);
            } else {
                if (!Files.isDirectory(currentModuleOrJarOrFolder, new LinkOption[0])) continue;
                LOGGER.info(I18N.getString("log.info.explore.folder", currentModuleOrJarOrFolder));
                explorer = new FolderExplorer(currentModuleOrJarOrFolder);
                jarReport = ((FolderExplorer)explorer).explore(classLoader);
                resultText = I18N.getString("log.info.explore.folder.results", jarName);
            }
            moduleOrJarOrFolderReports.add(jarReport);
            StringBuilder sb = new StringBuilder(resultText).append("\n");
            if (jarReport.getEntries().isEmpty()) {
                sb.append("> ").append(I18N.getString("log.info.explore.no.results"));
            } else {
                jarReport.getEntries().forEach(entry -> sb.append("> ").append(entry.toString()).append("\n"));
            }
            LOGGER.info(sb.toString());
            LOGGER.info(I18N.getString("log.info.explore.end", currentModuleOrJarOrFolder));
        }
        ArrayList<LibraryItem> newItems = new ArrayList<LibraryItem>();
        for (JarReport moduleOrJarOrFolderReport : moduleOrJarOrFolderReports) {
            newItems.addAll(this.makeLibraryItems(moduleOrJarOrFolderReport));
        }
        this.library.updateClassLoader(classLoader);
        this.library.addItems(newItems.stream().distinct().collect(Collectors.toList()));
        this.library.updateJarReports(new ArrayList<JarReport>(moduleOrJarOrFolderReports));
        this.library.getOnFinishedUpdatingJarReports().accept(moduleOrJarOrFolderReports);
        this.library.updateExplorationDate(new Date());
        this.library.updateFirstExplorationCompleted();
    }

    private Collection<LibraryItem> makeLibraryItems(JarReport jarOrFolderReport) throws IOException {
        ArrayList<LibraryItem> result = new ArrayList<LibraryItem>();
        URL iconURL = ImageUtils.getNodeIconURL(null);
        List<String> excludedItems = this.library.getFilter();
        List<String> artifactsFilter = this.library.getAdditionalFilter().get();
        for (JarReportEntry e : jarOrFolderReport.getEntries()) {
            String canonicalName;
            if (e.getStatus() != JarReportEntry.Status.OK || !e.isNode() || excludedItems.contains(canonicalName = e.getKlass().getCanonicalName()) || artifactsFilter.contains(canonicalName)) continue;
            String name = e.getKlass().getSimpleName();
            String fxmlText = BuiltinLibrary.makeFxmlText(e.getKlass());
            result.add(new LibraryItem(name, "Custom", fxmlText, iconURL, this.library));
        }
        return result;
    }

    private URL[] makeURLArrayFromPaths(Collection<Path> paths) {
        URL[] result = new URL[paths.size()];
        int i = 0;
        for (Path p : paths) {
            try {
                URL url = p.toUri().toURL();
                if (url.toString().endsWith(".jar")) {
                    result[i++] = new URL("jar", "", String.valueOf(url) + "!/");
                    continue;
                }
                result[i++] = url;
            }
            catch (MalformedURLException x) {
                throw new RuntimeException("Bug in " + this.getClass().getSimpleName(), x);
            }
        }
        return result;
    }

    private static enum FILE_TYPE {
        FXML,
        JAR,
        FOLDER_MARKER;

    }
}

