/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.library.util;

import com.oracle.javafx.scenebuilder.kit.editor.EditorPlatform;
import com.oracle.javafx.scenebuilder.kit.library.BuiltinLibrary;
import com.oracle.javafx.scenebuilder.kit.library.util.JarReportEntry;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;

abstract class ExplorerBase {
    ExplorerBase() {
    }

    static Object instantiateWithFXMLLoader(Class<?> klass, ClassLoader classLoader) throws IOException {
        Object result;
        String fxmlText = BuiltinLibrary.makeFxmlText(klass);
        byte[] fxmlBytes = fxmlText.getBytes(Charset.forName("UTF-8"));
        FXMLLoader fxmlLoader = new FXMLLoader();
        try {
            fxmlLoader.setClassLoader(classLoader);
            result = fxmlLoader.load((InputStream)new ByteArrayInputStream(fxmlBytes));
        }
        catch (IOException x) {
            throw x;
        }
        catch (Error | RuntimeException x) {
            throw new IOException(x);
        }
        return result;
    }

    String makeClassName(String entryName, String separator) {
        String result;
        if (!entryName.endsWith(".class")) {
            result = null;
        } else if (entryName.contains("$")) {
            result = null;
        } else {
            int endIndex = entryName.length() - 6;
            result = entryName.substring(0, endIndex).replace(separator, ".");
        }
        return result;
    }

    JarReportEntry exploreEntry(String entryName, ClassLoader classLoader, String className) {
        Throwable entryException;
        JarReportEntry.Status status;
        Class<?> entryClass = null;
        if (className == null || className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("javafx.") || className.startsWith("com.oracle.javafx.scenebuilder.") || className.startsWith("com.javafx.") || className.startsWith("module-info") || EditorPlatform.hasClassFromExternalPlugin(className)) {
            status = JarReportEntry.Status.IGNORED;
            entryClass = null;
            entryException = null;
        } else {
            try {
                entryClass = classLoader.loadClass(className);
                int modifiers = entryClass.getModifiers();
                if (Modifier.isAbstract(modifiers) || !Node.class.isAssignableFrom(entryClass) || !Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers)) {
                    status = JarReportEntry.Status.IGNORED;
                    entryClass = null;
                    entryException = null;
                } else {
                    ExplorerBase.instantiateWithFXMLLoader(entryClass, classLoader);
                    status = JarReportEntry.Status.OK;
                    entryException = null;
                }
            }
            catch (IOException | RuntimeException x) {
                status = JarReportEntry.Status.CANNOT_INSTANTIATE;
                entryException = x;
            }
            catch (ClassNotFoundException | Error x) {
                status = JarReportEntry.Status.CANNOT_LOAD;
                entryClass = null;
                entryException = x;
            }
        }
        return new JarReportEntry(entryName, status, entryException, entryClass, className);
    }
}

