/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.library.util;

import com.oracle.javafx.scenebuilder.kit.library.util.ExplorerBase;
import com.oracle.javafx.scenebuilder.kit.library.util.JarReport;
import com.oracle.javafx.scenebuilder.kit.library.util.JarReportEntry;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Stream;

public class FolderExplorer
extends ExplorerBase {
    private final Path rootFolderPath;

    public FolderExplorer(Path folderPath) {
        assert (folderPath != null);
        assert (folderPath.isAbsolute());
        this.rootFolderPath = folderPath;
    }

    public JarReport explore(ClassLoader classLoader) throws IOException {
        JarReport result = new JarReport(this.rootFolderPath);
        try (Stream<Path> stream = Files.walk(this.rootFolderPath, new FileVisitOption[0]).filter(p -> !p.toFile().isDirectory());){
            stream.forEach(p -> {
                JarReportEntry explored = this.exploreEntry(this.rootFolderPath, (Path)p, classLoader);
                if (explored.getStatus() != JarReportEntry.Status.IGNORED) {
                    result.getEntries().add(explored);
                }
            });
        }
        return result;
    }

    private JarReportEntry exploreEntry(Path rootpath, Path path, ClassLoader classLoader) {
        File file = path.toFile();
        if (file.isDirectory()) {
            return new JarReportEntry(file.getName(), JarReportEntry.Status.IGNORED, null, null, null);
        }
        Path relativepath = rootpath.relativize(path);
        String className = this.makeClassName(relativepath.toString(), File.separator);
        return super.exploreEntry(file.getName(), classLoader, className);
    }
}

