/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.library.util;

import com.oracle.javafx.scenebuilder.kit.library.util.ExplorerBase;
import com.oracle.javafx.scenebuilder.kit.library.util.JarReport;
import com.oracle.javafx.scenebuilder.kit.library.util.JarReportEntry;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarExplorer
extends ExplorerBase {
    private final Path jar;

    public JarExplorer(Path jar) {
        assert (jar != null);
        assert (jar.isAbsolute());
        this.jar = jar;
    }

    public JarReport explore(ClassLoader classLoader) throws IOException {
        JarReport result = new JarReport(this.jar);
        try (JarFile jarFile = new JarFile(this.jar.toFile());){
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                JarReportEntry explored = this.exploreEntry(entry, classLoader);
                if (explored.getStatus() == JarReportEntry.Status.IGNORED) continue;
                result.getEntries().add(explored);
            }
        }
        return result;
    }

    private JarReportEntry exploreEntry(JarEntry entry, ClassLoader classLoader) {
        if (entry.isDirectory()) {
            return new JarReportEntry(entry.getName(), JarReportEntry.Status.IGNORED, null, null, null);
        }
        String className = this.makeClassName(entry.getName(), "/");
        return super.exploreEntry(entry.getName(), classLoader, className);
    }
}

