/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.library.util;

import com.oracle.javafx.scenebuilder.kit.library.util.JarReportEntry;
import java.nio.file.Path;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class JarReport {
    private final Path jar;
    private final ObservableList<JarReportEntry> entries = FXCollections.observableArrayList();
    private boolean hasControlsFromExternalPlugin = false;

    public JarReport(Path jar) {
        this.jar = jar;
        this.entries.addListener(c -> {
            while (c.next()) {
                if (!c.wasAdded()) continue;
                for (JarReportEntry entry : c.getAddedSubList()) {
                    if (!entry.isClassFromExternalPlugin()) continue;
                    this.hasControlsFromExternalPlugin = true;
                }
            }
        });
    }

    public Path getJar() {
        return this.jar;
    }

    public List<JarReportEntry> getEntries() {
        return this.entries;
    }

    public boolean hasControlsFromExternalPlugin() {
        return this.hasControlsFromExternalPlugin;
    }
}

