/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.library.util;

import com.oracle.javafx.scenebuilder.kit.editor.EditorPlatform;
import javafx.scene.Node;

public class JarReportEntry {
    private final String name;
    private final Status status;
    private final Class<?> klass;
    private final Throwable exception;
    private final String className;

    public JarReportEntry(String name, Status status, Throwable exception, Class<?> klass, String className) {
        assert (name != null);
        assert (klass != null || status != Status.OK);
        assert (exception == null || status != Status.OK);
        this.name = name;
        this.status = status;
        this.klass = klass;
        this.exception = exception;
        this.className = className;
    }

    public String getName() {
        return this.name;
    }

    public Status getStatus() {
        return this.status;
    }

    public Class<?> getKlass() {
        return this.klass;
    }

    public Throwable getException() {
        return this.exception;
    }

    public boolean isNode() {
        return this.klass != null && Node.class.isAssignableFrom(this.klass);
    }

    public boolean isClassFromExternalPlugin() {
        return EditorPlatform.hasClassFromExternalPlugin(this.className);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        switch (this.status.ordinal()) {
            case 3: {
                assert (this.klass != null);
                sb.append(this.klass.getCanonicalName());
                sb.append(" - OK");
                break;
            }
            case 1: {
                assert (this.klass == null);
                assert (this.exception != null);
                sb.append(this.name);
                sb.append(" - CANNOT_LOAD - ");
                sb.append(this.exception.getMessage());
                break;
            }
            case 2: {
                assert (this.klass != null);
                sb.append(this.klass.getCanonicalName());
                sb.append(" - CANNOT_INSTANTIATE - ");
                sb.append(this.exception.getMessage());
                break;
            }
            case 0: {
                assert (this.klass == null);
                sb.append(this.name);
                sb.append(" - IGNORED");
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected status " + String.valueOf((Object)this.status));
            }
        }
        return sb.toString();
    }

    public static enum Status {
        IGNORED,
        CANNOT_LOAD,
        CANNOT_INSTANTIATE,
        OK;

    }
}

