/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.library.util;

import com.oracle.javafx.scenebuilder.kit.library.util.ExplorerBase;
import com.oracle.javafx.scenebuilder.kit.library.util.JarReport;
import com.oracle.javafx.scenebuilder.kit.library.util.JarReportEntry;
import java.io.IOException;
import java.lang.module.ModuleReader;
import java.lang.module.ModuleReference;
import java.nio.file.Path;

public class ModuleExplorer
extends ExplorerBase {
    private final ModuleReference moduleReference;
    private final Module module;

    public ModuleExplorer(ModuleReference moduleReference) {
        assert (moduleReference != null);
        this.moduleReference = moduleReference;
        this.module = ModuleLayer.boot().findModule(moduleReference.descriptor().name()).orElseThrow();
    }

    public JarReport explore() throws IOException {
        ClassLoader classLoader = this.module.getClassLoader();
        JarReport result = new JarReport(this.moduleReference.location().map(Path::of).orElse(null));
        try (ModuleReader reader = this.moduleReference.open();){
            reader.list().forEach(cl -> {
                String className;
                JarReportEntry explored;
                if (cl.endsWith(".class") && (explored = super.exploreEntry((String)cl, classLoader, className = cl.substring(0, cl.length() - ".class".length()).replaceAll("/", "."))).getStatus() != JarReportEntry.Status.IGNORED) {
                    result.getEntries().add(explored);
                }
            });
        }
        return result;
    }
}

