/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.metadata;

import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.util.SBDuration;
import com.oracle.javafx.scenebuilder.kit.metadata.Metadata;
import com.oracle.javafx.scenebuilder.kit.metadata.klass.ComponentClassMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.klass.CustomComponentClassMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.PropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.BooleanPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.DoublePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.DurationPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.EnumerationPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.EventHandlerPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.FontPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.ImagePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.InsetsPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.IntegerPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.StringPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.list.StringListPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.paint.ColorPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.paint.PaintPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.InspectorPath;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.util.Duration;

class MetadataIntrospector {
    private final Class<?> componentClass;
    private final ComponentClassMetadata ancestorMetadata;
    private int counter;

    public MetadataIntrospector(Class<?> componentClass, ComponentClassMetadata ancestorMetadata) {
        this.componentClass = componentClass;
        this.ancestorMetadata = ancestorMetadata;
    }

    public ComponentClassMetadata introspect() {
        Exception exception;
        HashSet<PropertyMetadata> properties = new HashSet<PropertyMetadata>();
        Set<PropertyName> hiddenProperties = Metadata.getMetadata().getHiddenProperties();
        try {
            Object sample = this.instantiate();
            BeanInfo beanInfo = Introspector.getBeanInfo(this.componentClass);
            for (PropertyDescriptor d : beanInfo.getPropertyDescriptors()) {
                PropertyName name = new PropertyName(d.getName());
                PropertyMetadata propertyMetadata = this.lookupPropertyMetadata(this.ancestorMetadata, name);
                if (propertyMetadata != null || hiddenProperties.contains(name) || (propertyMetadata = this.makePropertyMetadata(name, d, sample)) == null) continue;
                properties.add(propertyMetadata);
            }
            exception = null;
        }
        catch (IntrospectionException | IOException x) {
            exception = x;
        }
        CustomComponentClassMetadata result = new CustomComponentClassMetadata(this.componentClass, this.ancestorMetadata, exception);
        result.getProperties().addAll(properties);
        return result;
    }

    private Object instantiate() throws IOException {
        Object result;
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<?import ");
        sb.append(this.componentClass.getCanonicalName());
        sb.append("?>");
        sb.append("<");
        sb.append(this.componentClass.getSimpleName());
        sb.append("/>\n");
        FXMLLoader fxmlLoader = new FXMLLoader();
        String fxmlText = sb.toString();
        byte[] fxmlBytes = fxmlText.getBytes(Charset.forName("UTF-8"));
        try {
            fxmlLoader.setClassLoader(this.componentClass.getClassLoader());
            result = fxmlLoader.load((InputStream)new ByteArrayInputStream(fxmlBytes));
        }
        catch (RuntimeException x) {
            throw new IOException(x);
        }
        return result;
    }

    private PropertyMetadata lookupPropertyMetadata(ComponentClassMetadata ccm, PropertyName propertyName) {
        PropertyMetadata result = null;
        while (ccm != null && result == null) {
            result = ccm.lookupProperty(propertyName);
            ccm = ccm.getParentMetadata();
        }
        return result;
    }

    private PropertyMetadata makePropertyMetadata(PropertyName name, PropertyDescriptor propertyDescriptor, Object sample) {
        ValuePropertyMetadata result;
        if (propertyDescriptor.getPropertyType() == null) {
            result = null;
        } else if (propertyDescriptor.getReadMethod() == null) {
            result = null;
        } else {
            Class<?> propertyType = this.canonizeClass(propertyDescriptor.getPropertyType());
            boolean readWrite = propertyDescriptor.getWriteMethod() != null;
            InspectorPath inspectorPath = new InspectorPath("Properties", "Custom", this.counter++);
            if (propertyType.isArray()) {
                result = null;
            } else if (propertyType.isEnum()) {
                Object fallback = propertyType.getEnumConstants()[0];
                result = new EnumerationPropertyMetadata(name, propertyType, readWrite, (Enum)this.getDefaultValue(sample, propertyDescriptor.getReadMethod(), fallback), inspectorPath);
            } else if (propertyType == Boolean.class) {
                result = new BooleanPropertyMetadata(name, readWrite, (Boolean)this.getDefaultValue(sample, propertyDescriptor.getReadMethod(), false), inspectorPath);
            } else if (propertyType == Integer.class) {
                result = new IntegerPropertyMetadata(name, readWrite, (Integer)this.getDefaultValue(sample, propertyDescriptor.getReadMethod(), 0), inspectorPath);
            } else if (propertyType == Double.class) {
                result = new DoublePropertyMetadata(name, DoublePropertyMetadata.DoubleKind.COORDINATE, readWrite, (Double)this.getDefaultValue(sample, propertyDescriptor.getReadMethod(), 0.0), inspectorPath);
            } else if (propertyType == String.class) {
                result = new StringPropertyMetadata(name, readWrite, (String)this.getDefaultValue(sample, propertyDescriptor.getReadMethod(), null), inspectorPath);
            } else if (propertyType == Color.class) {
                result = new ColorPropertyMetadata(name, readWrite, (Color)this.getDefaultValue(sample, propertyDescriptor.getReadMethod(), null), inspectorPath);
            } else if (propertyType == Paint.class) {
                result = new PaintPropertyMetadata(name, readWrite, (Paint)this.getDefaultValue(sample, propertyDescriptor.getReadMethod(), null), inspectorPath);
            } else if (propertyType == Font.class) {
                result = new FontPropertyMetadata(name, readWrite, (Font)this.getDefaultValue(sample, propertyDescriptor.getReadMethod(), null), inspectorPath);
            } else if (propertyType == Image.class) {
                result = new ImagePropertyMetadata(name, readWrite, null, inspectorPath);
            } else if (propertyType == Insets.class) {
                Insets defaultValues = (Insets)this.getDefaultValue(sample, propertyDescriptor.getReadMethod(), Insets.EMPTY);
                result = new InsetsPropertyMetadata(name, readWrite, defaultValues, inspectorPath);
            } else if (propertyType == Duration.class) {
                Duration defaultValue = (Duration)this.getDefaultValue(sample, propertyDescriptor.getReadMethod(), null);
                result = new DurationPropertyMetadata(name, readWrite, defaultValue == null ? null : new SBDuration(defaultValue), inspectorPath);
            } else if (propertyType == EventHandler.class) {
                result = new EventHandlerPropertyMetadata(name, readWrite, null, inspectorPath);
            } else if (propertyType == ObservableList.class) {
                String propertyName = name.getName();
                String methodName = "get" + propertyName.substring(0, 1).toUpperCase(Locale.ROOT) + propertyName.substring(1);
                result = null;
                try {
                    Class genericClass;
                    ParameterizedType parameterizedType;
                    Type genericType;
                    Method method = sample.getClass().getMethod(methodName, new Class[0]);
                    Type type = method.getGenericReturnType();
                    if (type instanceof ParameterizedType && (genericType = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()[0]) instanceof Class && (genericClass = (Class)parameterizedType.getActualTypeArguments()[0]).equals(String.class)) {
                        result = new StringListPropertyMetadata(name, readWrite, Collections.emptyList(), inspectorPath);
                    }
                }
                catch (NoSuchMethodException e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Failed to find method: " + methodName, e);
                }
            } else {
                result = null;
            }
        }
        return result;
    }

    private Class<?> canonizeClass(Class<?> c) {
        Class result = c.equals(Boolean.TYPE) ? Boolean.class : (c.equals(Double.TYPE) ? Double.class : (c.equals(Integer.TYPE) ? Integer.class : c));
        return result;
    }

    private Object getDefaultValue(Object sample, Method readMethod, Object fallback) {
        Object result;
        try {
            result = readMethod.invoke(sample, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException x) {
            result = fallback;
        }
        return result;
    }
}

