/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.metadata.property.value;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.ComplexPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.InspectorPath;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.control.ButtonType;

public class ButtonTypePropertyMetadata
extends ComplexPropertyMetadata<ButtonType> {
    private static Map<ButtonType, String> buttonTypeMap;

    public ButtonTypePropertyMetadata(PropertyName name, boolean readWrite, ButtonType defaultValue, InspectorPath inspectorPath) {
        super(name, ButtonType.class, readWrite, defaultValue, inspectorPath);
    }

    public static synchronized Map<ButtonType, String> getButtonTypeMap() {
        if (buttonTypeMap == null) {
            buttonTypeMap = new HashMap<ButtonType, String>();
            buttonTypeMap.put(ButtonType.APPLY, "APPLY");
            buttonTypeMap.put(ButtonType.CANCEL, "CANCEL");
            buttonTypeMap.put(ButtonType.CLOSE, "CLOSE");
            buttonTypeMap.put(ButtonType.FINISH, "FINISH");
            buttonTypeMap.put(ButtonType.NEXT, "NEXT");
            buttonTypeMap.put(ButtonType.NO, "NO");
            buttonTypeMap.put(ButtonType.OK, "OK");
            buttonTypeMap.put(ButtonType.PREVIOUS, "PREVIOUS");
            buttonTypeMap.put(ButtonType.YES, "YES");
            buttonTypeMap = Collections.unmodifiableMap(buttonTypeMap);
        }
        return buttonTypeMap;
    }

    @Override
    public FXOMInstance makeFxomInstanceFromValue(ButtonType value, FXOMDocument fxomDocument) {
        FXOMInstance result;
        String buttonName = ButtonTypePropertyMetadata.getButtonTypeMap().get(value);
        if (buttonName != null) {
            result = new FXOMInstance(fxomDocument, ButtonType.class);
            result.setFxConstant(buttonName);
        } else {
            assert (false);
            result = new FXOMInstance(fxomDocument, ButtonType.class);
            result.setFxConstant(ButtonTypePropertyMetadata.getButtonTypeMap().get(ButtonType.APPLY));
        }
        return result;
    }
}

