/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.metadata.property.value;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.BooleanPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.ComplexPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.DoublePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.EnumerationPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.InspectorPath;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import com.oracle.javafx.scenebuilder.kit.util.MathUtils;
import java.util.Objects;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.Priority;

public class ColumnConstraintsPropertyMetadata
extends ComplexPropertyMetadata<ColumnConstraints> {
    private static final ColumnConstraints DEFAULT = new ColumnConstraints();
    private final BooleanPropertyMetadata fillWidthMetadata = new BooleanPropertyMetadata(new PropertyName("fillWidth"), true, DEFAULT.isFillWidth(), InspectorPath.UNUSED);
    private final DoublePropertyMetadata maxWidthMetadata = new DoublePropertyMetadata(new PropertyName("maxWidth"), DoublePropertyMetadata.DoubleKind.USE_COMPUTED_SIZE, true, DEFAULT.getMaxWidth(), InspectorPath.UNUSED);
    private final DoublePropertyMetadata minWidthMetadata = new DoublePropertyMetadata(new PropertyName("minWidth"), DoublePropertyMetadata.DoubleKind.USE_COMPUTED_SIZE, true, DEFAULT.getMinWidth(), InspectorPath.UNUSED);
    private final DoublePropertyMetadata percentWidthMetadata = new DoublePropertyMetadata(new PropertyName("percentWidth"), DoublePropertyMetadata.DoubleKind.PERCENTAGE, true, DEFAULT.getPercentWidth(), InspectorPath.UNUSED);
    private final DoublePropertyMetadata prefWidthMetadata = new DoublePropertyMetadata(new PropertyName("prefWidth"), DoublePropertyMetadata.DoubleKind.USE_PREF_SIZE, true, DEFAULT.getPrefWidth(), InspectorPath.UNUSED);
    private final EnumerationPropertyMetadata halignmentMetadata = new EnumerationPropertyMetadata(new PropertyName("halignment"), VPos.class, "INHERIT", true, InspectorPath.UNUSED);
    private final EnumerationPropertyMetadata hgrowMetadata = new EnumerationPropertyMetadata(new PropertyName("hgrow"), Priority.class, "INHERIT", true, InspectorPath.UNUSED);

    public ColumnConstraintsPropertyMetadata(PropertyName name, boolean readWrite, ColumnConstraints defaultValue, InspectorPath inspectorPath) {
        super(name, ColumnConstraints.class, readWrite, defaultValue, inspectorPath);
    }

    public static boolean equals(ColumnConstraints c1, ColumnConstraints c2) {
        assert (c1 != null);
        assert (c2 != null);
        boolean result = c1 == c2 ? true : Objects.equals(c1.getHalignment(), c2.getHalignment()) && Objects.equals(c1.getHgrow(), c2.getHgrow()) && MathUtils.equals(c1.getMaxWidth(), c2.getMaxWidth()) && MathUtils.equals(c1.getMinWidth(), c2.getMinWidth()) && MathUtils.equals(c1.getPercentWidth(), c2.getPercentWidth()) && MathUtils.equals(c1.getPrefWidth(), c2.getPrefWidth());
        return result;
    }

    @Override
    public FXOMInstance makeFxomInstanceFromValue(ColumnConstraints value, FXOMDocument fxomDocument) {
        FXOMInstance result = new FXOMInstance(fxomDocument, value.getClass());
        this.fillWidthMetadata.setValue(result, value.isFillWidth());
        this.maxWidthMetadata.setValue(result, value.getMaxWidth());
        this.minWidthMetadata.setValue(result, value.getMinWidth());
        this.percentWidthMetadata.setValue(result, value.getPercentWidth());
        this.prefWidthMetadata.setValue(result, value.getPrefWidth());
        HPos halignment = value.getHalignment();
        if (halignment == null) {
            this.halignmentMetadata.setValue(result, this.halignmentMetadata.getDefaultValue());
        } else {
            this.halignmentMetadata.setValue(result, halignment.toString());
        }
        Priority hgrow = value.getHgrow();
        if (hgrow == null) {
            this.hgrowMetadata.setValue(result, this.hgrowMetadata.getDefaultValue());
        } else {
            this.hgrowMetadata.setValue(result, hgrow.toString());
        }
        return result;
    }
}

