/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.metadata.property.value;

import com.oracle.javafx.scenebuilder.kit.metadata.property.value.TextEncodablePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.InspectorPath;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;

public class DoublePropertyMetadata
extends TextEncodablePropertyMetadata<Double> {
    private final DoubleKind kind;

    public DoublePropertyMetadata(PropertyName name, DoubleKind kind, boolean readWrite, Double defaultValue, InspectorPath inspectorPath) {
        super(name, Double.class, readWrite, defaultValue, inspectorPath);
        assert (kind != DoubleKind.NULLABLE_COORDINATE || defaultValue == null);
        this.kind = kind;
    }

    public DoubleKind getKind() {
        return this.kind;
    }

    public boolean isValidValue(Double value) {
        boolean result;
        if (this.kind == DoubleKind.NULLABLE_COORDINATE) {
            result = true;
        } else if (value == null) {
            result = false;
        } else {
            switch (this.kind.ordinal()) {
                case 0: {
                    result = true;
                    break;
                }
                case 2: {
                    result = 0.0 <= value;
                    break;
                }
                case 3: {
                    result = 0.0 <= value || value == -1.0;
                    break;
                }
                case 4: {
                    result = 0.0 <= value || value == -1.0 || value == Double.NEGATIVE_INFINITY;
                    break;
                }
                case 9: {
                    result = value == -1.0 || 0.0 <= value && value <= 100.0;
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    result = true;
                    break;
                }
                default: {
                    assert (false);
                    result = false;
                }
            }
        }
        return result;
    }

    public Double getCanonicalValue(Double value) {
        Double result;
        if (value == null) {
            result = null;
        } else {
            switch (this.kind.ordinal()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    result = value;
                    break;
                }
                case 5: {
                    result = Math.min(255.0, Math.max(0.0, value));
                    break;
                }
                case 6: {
                    result = Math.IEEEremainder(value, 360.0);
                    break;
                }
                case 7: 
                case 8: {
                    result = Math.min(1.0, Math.max(0.0, value));
                    break;
                }
                default: {
                    assert (false);
                    result = value;
                }
            }
        }
        return result;
    }

    @Override
    public Double makeValueFromString(String string) {
        return Double.valueOf(string);
    }

    public static enum DoubleKind {
        COORDINATE,
        NULLABLE_COORDINATE,
        SIZE,
        USE_COMPUTED_SIZE,
        USE_PREF_SIZE,
        EFFECT_SIZE,
        ANGLE,
        OPACITY,
        PROGRESS,
        PERCENTAGE;

    }
}

