/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.metadata.property.value;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.BooleanPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.ComplexPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.DoublePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.StringPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignImage;
import com.oracle.javafx.scenebuilder.kit.metadata.util.InspectorPath;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import javafx.scene.image.Image;

public class ImagePropertyMetadata
extends ComplexPropertyMetadata<DesignImage> {
    private final StringPropertyMetadata urlMetadata = new StringPropertyMetadata(new PropertyName("url"), true, null, InspectorPath.UNUSED);
    private final DoublePropertyMetadata requestedWidthMetadata = new DoublePropertyMetadata(new PropertyName("requestedWidth"), DoublePropertyMetadata.DoubleKind.SIZE, true, 0.0, InspectorPath.UNUSED);
    private final DoublePropertyMetadata requestedHeightMetadata = new DoublePropertyMetadata(new PropertyName("requestedHeight"), DoublePropertyMetadata.DoubleKind.SIZE, true, 0.0, InspectorPath.UNUSED);
    private final BooleanPropertyMetadata preserveRatioMetadata = new BooleanPropertyMetadata(new PropertyName("preserveRatio"), true, false, InspectorPath.UNUSED);
    private final BooleanPropertyMetadata smoothMetadata = new BooleanPropertyMetadata(new PropertyName("smooth"), true, false, InspectorPath.UNUSED);
    private final BooleanPropertyMetadata backgroundLoading = new BooleanPropertyMetadata(new PropertyName("backgroundLoading"), true, false, InspectorPath.UNUSED);

    public ImagePropertyMetadata(PropertyName name, boolean readWrite, DesignImage defaultValue, InspectorPath inspectorPath) {
        super(name, DesignImage.class, readWrite, defaultValue, inspectorPath);
    }

    @Override
    public FXOMInstance makeFxomInstanceFromValue(DesignImage value, FXOMDocument fxomDocument) {
        FXOMInstance result = new FXOMInstance(fxomDocument, Image.class);
        this.urlMetadata.setValue(result, value.getLocation());
        this.requestedWidthMetadata.setValue(result, value.getImage().getRequestedWidth());
        this.requestedHeightMetadata.setValue(result, value.getImage().getRequestedHeight());
        this.preserveRatioMetadata.setValue(result, value.getImage().isPreserveRatio());
        this.smoothMetadata.setValue(result, value.getImage().isSmooth());
        this.backgroundLoading.setValue(result, value.getImage().isBackgroundLoading());
        return result;
    }

    @Override
    public DesignImage makeValueFromFxomInstance(FXOMInstance valueFxomInstance) {
        String location = (String)this.urlMetadata.getValue(valueFxomInstance);
        Image image = (Image)valueFxomInstance.getSceneGraphObject();
        return new DesignImage(image, location);
    }
}

