/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.metadata.property.value.paint;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.ComplexPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.DoublePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.ColorEncoder;
import com.oracle.javafx.scenebuilder.kit.metadata.util.InspectorPath;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import javafx.scene.paint.Color;

public class ColorPropertyMetadata
extends ComplexPropertyMetadata<Color> {
    private final DoublePropertyMetadata redMetadata = new DoublePropertyMetadata(new PropertyName("red"), DoublePropertyMetadata.DoubleKind.OPACITY, true, 0.0, InspectorPath.UNUSED);
    private final DoublePropertyMetadata greenMetadata = new DoublePropertyMetadata(new PropertyName("green"), DoublePropertyMetadata.DoubleKind.OPACITY, true, 0.0, InspectorPath.UNUSED);
    private final DoublePropertyMetadata blueMetadata = new DoublePropertyMetadata(new PropertyName("blue"), DoublePropertyMetadata.DoubleKind.OPACITY, true, 0.0, InspectorPath.UNUSED);
    private final DoublePropertyMetadata opacityMetadata = new DoublePropertyMetadata(new PropertyName("opacity"), DoublePropertyMetadata.DoubleKind.OPACITY, true, 1.0, InspectorPath.UNUSED);

    public ColorPropertyMetadata(PropertyName name, boolean readWrite, Color defaultValue, InspectorPath inspectorPath) {
        super(name, Color.class, readWrite, defaultValue, inspectorPath);
    }

    @Override
    public FXOMInstance makeFxomInstanceFromValue(Color value, FXOMDocument fxomDocument) {
        FXOMInstance result = new FXOMInstance(fxomDocument, Color.class);
        this.redMetadata.setValue(result, value.getRed());
        this.greenMetadata.setValue(result, value.getGreen());
        this.blueMetadata.setValue(result, value.getBlue());
        this.opacityMetadata.setValue(result, value.getOpacity());
        return result;
    }

    @Override
    public Color makeValueFromString(String string) {
        return Color.valueOf((String)string);
    }

    @Override
    public String makeStringFromValue(Color value) {
        assert (value != null);
        return ColorEncoder.encodeColor(value);
    }
}

