/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.metadata.util;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMArchive;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMNodes;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.ClipboardEncoder;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javafx.scene.input.Clipboard;

public class ClipboardDecoder {
    final Clipboard clipboard;

    public ClipboardDecoder(Clipboard clipboard) {
        this.clipboard = clipboard;
    }

    public List<FXOMObject> decode(FXOMDocument targetDocument) {
        Object content;
        assert (targetDocument != null);
        List<FXOMObject> result = null;
        if (this.clipboard.hasContent(ClipboardEncoder.SB_DATA_FORMAT) && (content = this.clipboard.getContent(ClipboardEncoder.SB_DATA_FORMAT)) instanceof FXOMArchive) {
            FXOMArchive archive = (FXOMArchive)content;
            try {
                result = archive.decode(targetDocument);
            }
            catch (IOException x) {
                result = null;
            }
        }
        if (result == null && this.clipboard.hasContent(ClipboardEncoder.FXML_DATA_FORMAT) && (content = this.clipboard.getContent(ClipboardEncoder.FXML_DATA_FORMAT)) instanceof String) {
            String fxmlText = (String)content;
            try {
                URL location = targetDocument.getLocation();
                ClassLoader classLoader = targetDocument.getClassLoader();
                ResourceBundle resources = targetDocument.getResources();
                FXOMDocument transientDoc = new FXOMDocument(fxmlText, location, classLoader, resources, FXOMDocument.FXOMDocumentSwitch.NORMALIZED);
                result = Arrays.asList(transientDoc.getFxomRoot());
            }
            catch (IOException x) {
                result = null;
            }
        }
        if (result == null && this.clipboard.hasFiles()) {
            result = new ArrayList<FXOMObject>();
            for (File file : this.clipboard.getFiles()) {
                try {
                    FXOMObject newObject = FXOMNodes.newObject(targetDocument, file);
                    if (newObject == null) continue;
                    result.add(newObject);
                }
                catch (IOException iOException) {}
            }
        }
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }
}

