/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.metadata.util;

import com.oracle.javafx.scenebuilder.kit.editor.images.ImageUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.HierarchyItem;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMCollection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMIntrinsic;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.library.ExternalSectionProvider;
import com.oracle.javafx.scenebuilder.kit.metadata.Metadata;
import com.oracle.javafx.scenebuilder.kit.metadata.klass.ComponentClassMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ComponentPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.ExternalDesignHierarchyMaskProvider;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PrefixedValue;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import com.oracle.javafx.scenebuilder.kit.util.Deprecation;
import java.lang.runtime.SwitchBootstraps;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javafx.geometry.Orientation;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.chart.Axis;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Labeled;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.Separator;
import javafx.scene.control.Slider;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.image.Image;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.text.Text;
import javafx.stage.Stage;

public class DesignHierarchyMask {
    private final FXOMObject fxomObject;
    private Map<PropertyName, ComponentPropertyMetadata> propertyMetadataMap;
    private final Collection<ExternalDesignHierarchyMaskProvider> externalDesignHierarchyMaskProviders = this.getExternalDesignHierarchyMaskProviders();
    private final Collection<ExternalSectionProvider> externalItemProviders = this.getExternalItemProviders();

    public List<Accessory> getAccessoryList() {
        ArrayList<Accessory> accessories = new ArrayList<Accessory>(List.of(Accessory.PLACEHOLDER, Accessory.TOOLTIP, Accessory.CONTEXT_MENU, Accessory.CLIP, Accessory.ROOT, Accessory.SCENE, Accessory.TOP, Accessory.BOTTOM, Accessory.LEFT, Accessory.RIGHT, Accessory.CENTER, Accessory.XAXIS, Accessory.YAXIS, Accessory.TREE_COLUMN, Accessory.EXPANDABLE_CONTENT, Accessory.HEADER, Accessory.CONTENT, Accessory.GRAPHIC, Accessory.DP_CONTENT, Accessory.DP_GRAPHIC));
        accessories.addAll(this.getExternalAccessories());
        return accessories;
    }

    public DesignHierarchyMask(FXOMObject fxomObject) {
        assert (fxomObject != null);
        this.fxomObject = fxomObject;
    }

    public FXOMObject getFxomObject() {
        return this.fxomObject;
    }

    public FXOMObject getParentFXOMObject() {
        return this.fxomObject.getParentObject();
    }

    public boolean isFxNode() {
        return this.fxomObject.getSceneGraphObject() instanceof Node;
    }

    public FXOMObject getClosestFxNode() {
        FXOMObject result = this.fxomObject;
        DesignHierarchyMask mask = this;
        while (result != null && !mask.isFxNode()) {
            result = mask.getParentFXOMObject();
            mask = result == null ? null : new DesignHierarchyMask(result);
        }
        return result;
    }

    public URL getClassNameIconURL() {
        Object sceneGraphObject = this.fxomObject instanceof FXOMIntrinsic ? ((FXOMIntrinsic)this.fxomObject).getSourceSceneGraphObject() : this.fxomObject.getSceneGraphObject();
        if (sceneGraphObject == null) {
            return null;
        }
        Object object = sceneGraphObject;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Separator.class, ScrollBar.class, Slider.class, SplitPane.class}, (Object)object2, n)) {
            case 0 -> {
                Separator obj = (Separator)object2;
                if (Orientation.HORIZONTAL.equals((Object)obj.getOrientation())) {
                    yield ImageUtils.getNodeIconURL("Separator-h.png");
                }
                yield ImageUtils.getNodeIconURL("Separator-v.png");
            }
            case 1 -> {
                ScrollBar obj = (ScrollBar)object2;
                if (Orientation.HORIZONTAL.equals((Object)obj.getOrientation())) {
                    yield ImageUtils.getNodeIconURL("ScrollBar-h.png");
                }
                yield ImageUtils.getNodeIconURL("ScrollBar-v.png");
            }
            case 2 -> {
                Slider obj = (Slider)object2;
                if (Orientation.HORIZONTAL.equals((Object)obj.getOrientation())) {
                    yield ImageUtils.getNodeIconURL("Slider-h.png");
                }
                yield ImageUtils.getNodeIconURL("Slider-v.png");
            }
            case 3 -> {
                SplitPane obj = (SplitPane)object2;
                if (Orientation.HORIZONTAL.equals((Object)obj.getOrientation())) {
                    yield ImageUtils.getNodeIconURL("SplitPane-h.png");
                }
                yield ImageUtils.getNodeIconURL("SplitPane-v.png");
            }
            default -> {
                Class<?> componentClass = sceneGraphObject.getClass();
                URL externalURL = this.findExternalItemImage(componentClass);
                if (externalURL == null) {
                    String fileName = componentClass.getSimpleName();
                    yield ImageUtils.getNodeIconURL(fileName + ".png");
                }
                yield externalURL;
            }
        };
    }

    public Image getClassNameIcon() {
        URL resource = this.getClassNameIconURL();
        return ImageUtils.getImage(resource);
    }

    public String getClassNameInfo() {
        String classNameInfo;
        Object sceneGraphObject;
        Object prefix = "";
        Object suffix = "";
        FXOMObject fXOMObject = this.fxomObject;
        if (fXOMObject instanceof FXOMIntrinsic) {
            FXOMIntrinsic fxomIntrinsic = (FXOMIntrinsic)fXOMObject;
            sceneGraphObject = fxomIntrinsic.getSourceSceneGraphObject();
            if (fxomIntrinsic.getType() == FXOMIntrinsic.Type.FX_INCLUDE) {
                prefix = (String)prefix + "FXML ";
            }
        } else {
            sceneGraphObject = this.fxomObject.getSceneGraphObject();
        }
        if (sceneGraphObject == null) {
            classNameInfo = (String)prefix + this.fxomObject.getGlueElement().getTagName() + (String)suffix;
        } else {
            if (sceneGraphObject instanceof Node) {
                Object parentSceneGraphObject;
                FXOMObject parentFxomObject;
                Node node = (Node)sceneGraphObject;
                if (node instanceof GridPane) {
                    int columnsSize = this.getColumnsSize();
                    int rowsSize = this.getRowsSize();
                    suffix = (String)suffix + " (" + columnsSize + " x " + rowsSize + ")";
                }
                if ((parentFxomObject = this.fxomObject.getParentObject()) != null && (parentSceneGraphObject = parentFxomObject.getSceneGraphObject()) instanceof GridPane) {
                    int columnIndex = this.getColumnIndex();
                    int rowIndex = this.getRowIndex();
                    suffix = (String)suffix + " (" + columnIndex + ", " + rowIndex + ")";
                }
            }
            classNameInfo = (String)prefix + sceneGraphObject.getClass().getSimpleName() + (String)suffix;
        }
        return classNameInfo;
    }

    public String getDescription() {
        if (this.hasDescription()) {
            PropertyName propertyName = this.getPropertyNameForDescription();
            assert (propertyName != null);
            assert (this.fxomObject instanceof FXOMInstance);
            FXOMInstance fxomInstance = (FXOMInstance)this.fxomObject;
            ValuePropertyMetadata vpm = Metadata.getMetadata().queryValueProperty(fxomInstance, propertyName);
            Object description = vpm.getValueInSceneGraphObject(fxomInstance);
            return description == null ? null : description.toString();
        }
        return null;
    }

    public String getSingleLineDescription() {
        Object result = this.getDescription();
        if (result != null && DesignHierarchyMask.containsLineFeed((String)result)) {
            result = ((String)result).substring(0, ((String)result).indexOf(10)) + "...";
        }
        return result;
    }

    public Object getNodeIdValue() {
        Object result = null;
        FXOMObject fXOMObject = this.fxomObject;
        if (fXOMObject instanceof FXOMInstance) {
            FXOMInstance fxomInstance = (FXOMInstance)fXOMObject;
            PropertyName propertyName = new PropertyName("id");
            ValuePropertyMetadata vpm = Metadata.getMetadata().queryValueProperty(fxomInstance, propertyName);
            result = vpm.getValueObject(fxomInstance);
        }
        return result;
    }

    public String getNodeId() {
        Object value = this.getNodeIdValue();
        String result = null;
        if (value != null) {
            result = value.toString();
        }
        return result;
    }

    public String getFxId() {
        String result = null;
        FXOMObject fXOMObject = this.fxomObject;
        if (fXOMObject instanceof FXOMInstance) {
            FXOMInstance fxomInstance = (FXOMInstance)fXOMObject;
            String fxId = fxomInstance.getFxId();
            result = fxId == null ? "" : fxId;
        }
        return result;
    }

    public boolean hasDescription() {
        Object sceneGraphObject = this.fxomObject.getSceneGraphObject();
        if (sceneGraphObject == null) {
            return false;
        }
        return sceneGraphObject instanceof ComboBox || sceneGraphObject instanceof Labeled || sceneGraphObject instanceof Menu || sceneGraphObject instanceof MenuItem || sceneGraphObject instanceof Tab || sceneGraphObject instanceof TableColumn || sceneGraphObject instanceof Text || sceneGraphObject instanceof TextInputControl || sceneGraphObject instanceof TitledPane || sceneGraphObject instanceof Tooltip || sceneGraphObject instanceof TreeTableColumn || sceneGraphObject instanceof Stage;
    }

    public boolean isResourceKey() {
        if (this.hasDescription()) {
            PropertyName propertyName = this.getPropertyNameForDescription();
            assert (propertyName != null);
            assert (this.fxomObject instanceof FXOMInstance);
            FXOMInstance fxomInstance = (FXOMInstance)this.fxomObject;
            ValuePropertyMetadata vpm = Metadata.getMetadata().queryValueProperty(fxomInstance, propertyName);
            Object description = vpm.getValueObject(fxomInstance);
            PrefixedValue pv = new PrefixedValue(description.toString());
            return pv.isResourceKey();
        }
        return false;
    }

    public boolean isFreeChildPositioning() {
        boolean result = false;
        FXOMObject fXOMObject = this.fxomObject;
        if (fXOMObject instanceof FXOMInstance) {
            FXOMInstance fxomInstance = (FXOMInstance)fXOMObject;
            Class<?> componentClass = fxomInstance.getDeclaredClass();
            result = componentClass == AnchorPane.class || componentClass == Group.class || componentClass == Pane.class;
        }
        return result;
    }

    public boolean isAcceptingAccessory(Accessory accessory) {
        Object sceneGraphObject = this.fxomObject.getSceneGraphObject();
        if (!accessory.isAccepting().test(sceneGraphObject) || !this.isExternalAccepting(accessory, sceneGraphObject)) {
            return false;
        }
        return this.isAcceptingProperty(accessory.propertyName(), accessory.classForAccessory());
    }

    public boolean isAcceptingAccessory(Accessory accessory, FXOMObject fxomObject) {
        Object sceneGraphObject;
        if (fxomObject instanceof FXOMIntrinsic) {
            FXOMIntrinsic fxomIntrinsic = (FXOMIntrinsic)fxomObject;
            sceneGraphObject = fxomIntrinsic.getSourceSceneGraphObject();
        } else {
            sceneGraphObject = fxomObject.getSceneGraphObject();
        }
        return this.isAcceptingAccessory(accessory) && accessory.classForAccessory().isInstance(sceneGraphObject);
    }

    public FXOMObject getAccessory(Accessory accessory) {
        FXOMObject result;
        assert (this.isAcceptingAccessory(accessory));
        assert (this.fxomObject instanceof FXOMInstance);
        FXOMInstance fxomInstance = (FXOMInstance)this.fxomObject;
        PropertyName propertyName = this.getPropertyNameForAccessory(accessory);
        FXOMProperty fxomProperty = fxomInstance.getProperties().get(propertyName);
        if (fxomProperty instanceof FXOMPropertyC) {
            FXOMPropertyC fxomPropertyC = (FXOMPropertyC)fxomProperty;
            assert (!fxomPropertyC.getValues().isEmpty()) : "accessory=" + String.valueOf(accessory);
            result = fxomPropertyC.getValues().get(0);
        } else {
            result = null;
        }
        return result;
    }

    public boolean isAcceptingSubComponent() {
        PropertyName propertyName = this.getSubComponentPropertyName();
        return propertyName != null;
    }

    public boolean isAcceptingSubComponent(FXOMObject obj) {
        boolean result;
        assert (obj != null);
        PropertyName propertyName = this.getSubComponentPropertyName();
        if (propertyName == null) {
            result = false;
        } else {
            this.queryPropertyMetadata();
            ComponentPropertyMetadata subComponentMetadata = this.propertyMetadataMap.get(propertyName);
            assert (subComponentMetadata != null);
            Class<?> subComponentClass = subComponentMetadata.getClassMetadata().getKlass();
            Object sceneGraphObject = obj instanceof FXOMIntrinsic ? ((FXOMIntrinsic)obj).getSourceSceneGraphObject() : obj.getSceneGraphObject();
            result = subComponentClass.isInstance(sceneGraphObject);
        }
        return result;
    }

    public boolean isAcceptingSubComponent(Collection<FXOMObject> fxomObjects) {
        PropertyName propertyName = this.getSubComponentPropertyName();
        if (propertyName != null) {
            this.queryPropertyMetadata();
            ComponentPropertyMetadata subComponentMetadata = this.propertyMetadataMap.get(propertyName);
            assert (subComponentMetadata != null);
            Class<?> subComponentClass = subComponentMetadata.getClassMetadata().getKlass();
            for (FXOMObject obj : fxomObjects) {
                Object sceneGraphObject;
                if (obj instanceof FXOMIntrinsic) {
                    FXOMIntrinsic intrinsicObj = (FXOMIntrinsic)obj;
                    sceneGraphObject = intrinsicObj.getSourceSceneGraphObject();
                } else {
                    sceneGraphObject = obj.getSceneGraphObject();
                }
                if (subComponentClass.isInstance(sceneGraphObject)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public PropertyName getSubComponentPropertyName() {
        PropertyName result;
        Object sceneGraphObject = this.fxomObject.getSceneGraphObject();
        if (this.fxomObject instanceof FXOMCollection) {
            result = null;
        } else if (sceneGraphObject == null) {
            result = null;
        } else {
            Class<?> componentClass = sceneGraphObject.getClass();
            ComponentClassMetadata componentClassMetadata = Metadata.getMetadata().queryComponentMetadata(componentClass);
            assert (componentClassMetadata != null);
            result = componentClassMetadata.getSubComponentProperty();
        }
        return result;
    }

    public int getSubComponentCount() {
        PropertyName name = this.getSubComponentPropertyName();
        return name == null ? 0 : this.getSubComponents().size();
    }

    public FXOMObject getSubComponentAtIndex(int i) {
        assert (0 <= i);
        assert (i < this.getSubComponentCount());
        assert (this.getSubComponentPropertyName() != null);
        return this.getSubComponents().get(i);
    }

    public List<FXOMObject> getSubComponents() {
        assert (this.getSubComponentPropertyName() != null);
        assert (this.fxomObject instanceof FXOMInstance);
        PropertyName subComponentPropertyName = this.getSubComponentPropertyName();
        FXOMInstance fxomInstance = (FXOMInstance)this.fxomObject;
        FXOMProperty fxomProperty = fxomInstance.getProperties().get(subComponentPropertyName);
        List<FXOMObject> result = fxomProperty instanceof FXOMPropertyC ? ((FXOMPropertyC)fxomProperty).getValues() : Collections.emptyList();
        return result;
    }

    public PropertyName getPropertyNameForDescription() {
        Object sceneGraphObject = this.fxomObject.getSceneGraphObject();
        if (sceneGraphObject == null) {
            return null;
        }
        PropertyName propertyName = null;
        if (sceneGraphObject instanceof ComboBox) {
            propertyName = new PropertyName("promptText");
        } else if (sceneGraphObject instanceof Labeled || sceneGraphObject instanceof Menu || sceneGraphObject instanceof MenuItem || sceneGraphObject instanceof Tab || sceneGraphObject instanceof TableColumn || sceneGraphObject instanceof TextInputControl || sceneGraphObject instanceof TitledPane || sceneGraphObject instanceof Text || sceneGraphObject instanceof Tooltip || sceneGraphObject instanceof TreeTableColumn) {
            propertyName = new PropertyName("text");
        } else if (sceneGraphObject instanceof Stage) {
            propertyName = new PropertyName("title");
        }
        return propertyName;
    }

    public PropertyName getPropertyNameForAccessory(Accessory accessory) {
        return accessory.propertyName();
    }

    private boolean isAcceptingProperty(PropertyName propertyName, Class<?> valueClass) {
        this.queryPropertyMetadata();
        ComponentPropertyMetadata cpm = this.propertyMetadataMap.get(propertyName);
        boolean result = cpm == null ? false : valueClass.isAssignableFrom(cpm.getClassMetadata().getKlass());
        return result;
    }

    public FXOMPropertyC getAccessoryProperty(Accessory accessory) {
        assert (this.getPropertyNameForAccessory(accessory) != null);
        assert (this.fxomObject instanceof FXOMInstance);
        PropertyName accessoryPropertyName = this.getPropertyNameForAccessory(accessory);
        FXOMInstance fxomInstance = (FXOMInstance)this.fxomObject;
        FXOMProperty result = fxomInstance.getProperties().get(accessoryPropertyName);
        assert (result == null || result instanceof FXOMPropertyC);
        return (FXOMPropertyC)result;
    }

    private void queryPropertyMetadata() {
        if (this.propertyMetadataMap == null) {
            FXOMInstance fxomInstance;
            this.propertyMetadataMap = new HashMap<PropertyName, ComponentPropertyMetadata>();
            FXOMObject fXOMObject = this.fxomObject;
            if (fXOMObject instanceof FXOMInstance && (fxomInstance = (FXOMInstance)fXOMObject).getSceneGraphObject() != null) {
                Class<?> componentClass = fxomInstance.getSceneGraphObject().getClass();
                for (ComponentPropertyMetadata cpm : Metadata.getMetadata().queryComponentProperties(componentClass)) {
                    this.propertyMetadataMap.put(cpm.getName(), cpm);
                }
            }
        }
        assert (this.propertyMetadataMap != null);
    }

    public int getColumnsConstraintsSize() {
        int result;
        assert (this.fxomObject instanceof FXOMInstance);
        FXOMInstance fxomInstance = (FXOMInstance)this.fxomObject;
        assert (fxomInstance.getSceneGraphObject() instanceof GridPane);
        PropertyName propertyName = new PropertyName("columnConstraints");
        FXOMProperty fxomProperty = fxomInstance.getProperties().get(propertyName);
        if (fxomProperty == null) {
            result = 0;
        } else {
            assert (fxomProperty instanceof FXOMPropertyC);
            FXOMPropertyC fxomPropertyC = (FXOMPropertyC)fxomProperty;
            result = fxomPropertyC.getValues().size();
        }
        return result;
    }

    public int getRowsConstraintsSize() {
        int result;
        assert (this.fxomObject instanceof FXOMInstance);
        FXOMInstance fxomInstance = (FXOMInstance)this.fxomObject;
        assert (fxomInstance.getSceneGraphObject() instanceof GridPane);
        PropertyName propertyName = new PropertyName("rowConstraints");
        FXOMProperty fxomProperty = fxomInstance.getProperties().get(propertyName);
        if (fxomProperty == null) {
            result = 0;
        } else {
            assert (fxomProperty instanceof FXOMPropertyC);
            FXOMPropertyC fxomPropertyC = (FXOMPropertyC)fxomProperty;
            result = fxomPropertyC.getValues().size();
        }
        return result;
    }

    public int getColumnsSize() {
        Object sceneGraphObject = this.fxomObject instanceof FXOMIntrinsic ? ((FXOMIntrinsic)this.fxomObject).getSourceSceneGraphObject() : this.fxomObject.getSceneGraphObject();
        assert (sceneGraphObject instanceof GridPane);
        return Deprecation.getGridPaneColumnCount((GridPane)sceneGraphObject);
    }

    public int getRowsSize() {
        Object sceneGraphObject = this.fxomObject instanceof FXOMIntrinsic ? ((FXOMIntrinsic)this.fxomObject).getSourceSceneGraphObject() : this.fxomObject.getSceneGraphObject();
        assert (sceneGraphObject instanceof GridPane);
        return Deprecation.getGridPaneRowCount((GridPane)sceneGraphObject);
    }

    public List<FXOMObject> getColumnContentAtIndex(int index) {
        assert (0 <= index);
        assert (this.fxomObject instanceof FXOMInstance);
        FXOMInstance fxomInstance = (FXOMInstance)this.fxomObject;
        assert (fxomInstance.getSceneGraphObject() instanceof GridPane);
        ArrayList<FXOMObject> result = new ArrayList<FXOMObject>();
        int count = this.getSubComponentCount();
        for (int i = 0; i < count; ++i) {
            FXOMObject childObject = this.getSubComponentAtIndex(i);
            DesignHierarchyMask childMask = new DesignHierarchyMask(childObject);
            if (childMask.getColumnIndex() != index) continue;
            result.add(childObject);
        }
        return result;
    }

    public List<FXOMObject> getRowContentAtIndex(int index) {
        assert (0 <= index);
        assert (this.fxomObject instanceof FXOMInstance);
        FXOMInstance fxomInstance = (FXOMInstance)this.fxomObject;
        assert (fxomInstance.getSceneGraphObject() instanceof GridPane);
        ArrayList<FXOMObject> result = new ArrayList<FXOMObject>();
        int count = this.getSubComponentCount();
        for (int i = 0; i < count; ++i) {
            FXOMObject childObject = this.getSubComponentAtIndex(i);
            DesignHierarchyMask childMask = new DesignHierarchyMask(childObject);
            if (childMask.getRowIndex() != index) continue;
            result.add(childObject);
        }
        return result;
    }

    public FXOMObject getColumnConstraintsAtIndex(int index) {
        assert (0 <= index);
        assert (this.fxomObject instanceof FXOMInstance);
        FXOMInstance fxomInstance = (FXOMInstance)this.fxomObject;
        assert (fxomInstance.getSceneGraphObject() instanceof GridPane);
        FXOMObject result = null;
        PropertyName propertyName = new PropertyName("columnConstraints");
        FXOMProperty constraintsProperty = fxomInstance.getProperties().get(propertyName);
        if (constraintsProperty != null) {
            assert (constraintsProperty instanceof FXOMPropertyC);
            List<FXOMObject> constraintsValues = ((FXOMPropertyC)constraintsProperty).getValues();
            if (index < constraintsValues.size()) {
                result = constraintsValues.get(index);
            }
        }
        return result;
    }

    public FXOMObject getRowConstraintsAtIndex(int index) {
        assert (0 <= index);
        assert (this.fxomObject instanceof FXOMInstance);
        FXOMInstance fxomInstance = (FXOMInstance)this.fxomObject;
        assert (fxomInstance.getSceneGraphObject() instanceof GridPane);
        FXOMObject result = null;
        PropertyName propertyName = new PropertyName("rowConstraints");
        FXOMProperty constraintsProperty = fxomInstance.getProperties().get(propertyName);
        if (constraintsProperty != null) {
            assert (constraintsProperty instanceof FXOMPropertyC);
            List<FXOMObject> constraintsValues = ((FXOMPropertyC)constraintsProperty).getValues();
            if (index < constraintsValues.size()) {
                result = constraintsValues.get(index);
            }
        }
        return result;
    }

    public int getColumnIndex() {
        int result = 0;
        FXOMObject fXOMObject = this.fxomObject;
        if (fXOMObject instanceof FXOMInstance) {
            FXOMInstance fxomInstance = (FXOMInstance)fXOMObject;
            assert (this.fxomObject.getSceneGraphObject() != null);
            result = this.getIndexFromGrid(fxomInstance, "columnIndex");
        } else {
            fXOMObject = this.fxomObject;
            if (fXOMObject instanceof FXOMIntrinsic) {
                FXOMIntrinsic fxomIntrinsic = (FXOMIntrinsic)fXOMObject;
                FXOMInstance fxomInstance = fxomIntrinsic.createFxomInstanceFromIntrinsic();
                result = this.getIndexFromGrid(fxomInstance, "columnIndex");
            }
        }
        return result;
    }

    public int getRowIndex() {
        int result = 0;
        FXOMObject fXOMObject = this.fxomObject;
        if (fXOMObject instanceof FXOMInstance) {
            FXOMInstance fxomInstance = (FXOMInstance)fXOMObject;
            assert (this.fxomObject.getSceneGraphObject() != null);
            result = this.getIndexFromGrid(fxomInstance, "rowIndex");
        } else {
            fXOMObject = this.fxomObject;
            if (fXOMObject instanceof FXOMIntrinsic) {
                FXOMIntrinsic fxomIntrinsic = (FXOMIntrinsic)fXOMObject;
                FXOMInstance fxomInstance = fxomIntrinsic.createFxomInstanceFromIntrinsic();
                result = this.getIndexFromGrid(fxomInstance, "rowIndex");
            }
        }
        return result;
    }

    private int getIndexFromGrid(FXOMInstance fxomInstance, String columnOrRow) {
        int result;
        FXOMObject parentFxomObject = fxomInstance.getParentObject();
        assert (parentFxomObject.getSceneGraphObject() instanceof GridPane);
        PropertyName propertyName = new PropertyName(columnOrRow, GridPane.class);
        ValuePropertyMetadata vpm = Metadata.getMetadata().queryValueProperty(fxomInstance, propertyName);
        Object value = vpm.getValueObject(fxomInstance);
        if (value == null) {
            result = 0;
        } else {
            assert (value instanceof Integer);
            result = (Integer)value;
        }
        return result;
    }

    public static boolean containsLineFeed(String str) {
        if (str == null) {
            return false;
        }
        return str.contains("\n");
    }

    public boolean needResizeWhenTopElement() {
        Object sceneGraphObject = this.fxomObject.getSceneGraphObject();
        return (this.isAcceptingSubComponent() || this.isAcceptingAccessory(Accessory.CONTENT) || this.isAcceptingAccessory(Accessory.ROOT) || this.isAcceptingAccessory(Accessory.SCENE) || this.isAcceptingAccessory(Accessory.CENTER) || this.isAcceptingAccessory(Accessory.TOP) || this.isAcceptingAccessory(Accessory.RIGHT) || this.isAcceptingAccessory(Accessory.BOTTOM) || this.isAcceptingAccessory(Accessory.LEFT)) && !(sceneGraphObject instanceof MenuButton) && !(sceneGraphObject instanceof MenuBar) && !(sceneGraphObject instanceof ToolBar) && !this.isExternalNonResizable(sceneGraphObject);
    }

    private boolean isExternalNonResizable(Object object) {
        for (ExternalDesignHierarchyMaskProvider provider : this.externalDesignHierarchyMaskProviders) {
            for (Class<?> item : provider.getExternalNonResizableItems()) {
                if (!item.isInstance(object)) continue;
                return true;
            }
        }
        return false;
    }

    private List<Accessory> getExternalAccessories() {
        ArrayList<Accessory> result = new ArrayList<Accessory>();
        for (ExternalDesignHierarchyMaskProvider provider : this.externalDesignHierarchyMaskProviders) {
            result.addAll(provider.getExternalAccessories());
        }
        return result;
    }

    private boolean isExternalAccepting(Accessory accessory, Object object) {
        for (ExternalDesignHierarchyMaskProvider provider : this.externalDesignHierarchyMaskProviders) {
            if (provider.isExternalAccepting(accessory).test(object)) continue;
            return false;
        }
        return true;
    }

    public Map<Accessory, BiFunction<DesignHierarchyMask, FXOMObject, HierarchyItem>> getExternalHierarchyItemGeneratorMap() {
        HashMap<Accessory, BiFunction<DesignHierarchyMask, FXOMObject, HierarchyItem>> map = new HashMap<Accessory, BiFunction<DesignHierarchyMask, FXOMObject, HierarchyItem>>();
        for (ExternalDesignHierarchyMaskProvider provider : this.externalDesignHierarchyMaskProviders) {
            map.putAll(provider.getExternalHierarchyItemGeneratorMap());
        }
        return map;
    }

    private URL findExternalItemImage(Class<?> clazz) {
        for (ExternalSectionProvider provider : this.externalItemProviders) {
            for (Class<?> item : provider.getExternalSectionItems()) {
                if (item != clazz) continue;
                URL iconURL = provider.getClass().getResource(provider.getItemsIconPath() + "/" + item.getSimpleName() + ".png");
                assert (iconURL != null);
                return iconURL;
            }
        }
        return null;
    }

    private Collection<ExternalDesignHierarchyMaskProvider> getExternalDesignHierarchyMaskProviders() {
        ServiceLoader<ExternalDesignHierarchyMaskProvider> loader = ServiceLoader.load(ExternalDesignHierarchyMaskProvider.class);
        ArrayList<ExternalDesignHierarchyMaskProvider> providers = new ArrayList<ExternalDesignHierarchyMaskProvider>();
        loader.iterator().forEachRemaining(providers::add);
        return providers;
    }

    private Collection<ExternalSectionProvider> getExternalItemProviders() {
        ServiceLoader<ExternalSectionProvider> loader = ServiceLoader.load(ExternalSectionProvider.class);
        ArrayList<ExternalSectionProvider> providers = new ArrayList<ExternalSectionProvider>();
        loader.iterator().forEachRemaining(providers::add);
        return providers;
    }

    public record Accessory(String name, PropertyName propertyName, Class<?> classForAccessory, Predicate<Object> isAccepting) {
        public static final Accessory PLACEHOLDER = new Accessory("PLACEHOLDER", new PropertyName("placeholder"), Node.class, o -> true);
        public static final Accessory TOOLTIP = new Accessory("TOOLTIP", new PropertyName("tooltip"), Tooltip.class, o -> true);
        public static final Accessory CONTEXT_MENU = new Accessory("CONTEXT_MENU", new PropertyName("contextMenu"), ContextMenu.class, o -> true);
        public static final Accessory CLIP = new Accessory("CLIP", new PropertyName("clip"), Node.class, o -> true);
        public static final Accessory ROOT = new Accessory("ROOT", new PropertyName("root"), Node.class, o -> true);
        public static final Accessory SCENE = new Accessory("SCENE", new PropertyName("scene"), Scene.class, o -> true);
        public static final Accessory TOP = new Accessory("TOP", new PropertyName("top"), Node.class, o -> true);
        public static final Accessory BOTTOM = new Accessory("BOTTOM", new PropertyName("bottom"), Node.class, o -> true);
        public static final Accessory LEFT = new Accessory("LEFT", new PropertyName("left"), Node.class, o -> true);
        public static final Accessory RIGHT = new Accessory("RIGHT", new PropertyName("right"), Node.class, o -> true);
        public static final Accessory CENTER = new Accessory("CENTER", new PropertyName("center"), Node.class, o -> true);
        public static final Accessory XAXIS = new Accessory("XAXIS", new PropertyName("xAxis"), Axis.class, o -> true);
        public static final Accessory YAXIS = new Accessory("YAXIS", new PropertyName("xAxis"), Axis.class, o -> true);
        public static final Accessory TREE_COLUMN = new Accessory("TREE_COLUMN", new PropertyName("treeColumn"), TreeTableColumn.class, o -> true);
        public static final Accessory EXPANDABLE_CONTENT = new Accessory("EXPANDABLE_CONTENT", new PropertyName("expandableContent"), Node.class, o -> true);
        public static final Accessory HEADER = new Accessory("HEADER", new PropertyName("header"), Node.class, o -> true);
        public static final Accessory CONTENT = new Accessory("CONTENT", new PropertyName("content"), Node.class, o -> !(o instanceof DialogPane));
        public static final Accessory GRAPHIC = new Accessory("GRAPHIC", new PropertyName("graphic"), Node.class, o -> !(o instanceof DialogPane));
        public static final Accessory DP_CONTENT = new Accessory("CONTENT", new PropertyName("content"), Node.class, o -> o instanceof DialogPane);
        public static final Accessory DP_GRAPHIC = new Accessory("GRAPHIC", new PropertyName("graphic"), Node.class, o -> o instanceof DialogPane);

        @Override
        public String toString() {
            return this.name;
        }
    }
}

