/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.metadata.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;

public class PrefixedValue {
    private final String value;
    private final Type type;

    public PrefixedValue(String value) {
        assert (value != null);
        this.value = value;
        this.type = PrefixedValue.getPrefixedValueType(this.value);
    }

    public PrefixedValue(Type type, String suffix) {
        assert (type != Type.INVALID);
        assert (suffix != null);
        this.type = type;
        switch (this.type.ordinal()) {
            case 0: {
                String encoding = PrefixedValue.encodePath(new File(suffix));
                this.value = "@" + encoding;
                break;
            }
            case 1: {
                String encoding = PrefixedValue.encodePath(new File(suffix));
                this.value = "@/" + encoding;
                break;
            }
            case 2: {
                this.value = "%" + suffix;
                break;
            }
            case 3: {
                this.value = "$" + suffix;
                break;
            }
            case 4: {
                this.value = "${" + suffix + "}";
                break;
            }
            case 5: {
                if (suffix.startsWith("\\") || suffix.startsWith("@") || suffix.startsWith("%") || suffix.startsWith("$")) {
                    this.value = "\\" + suffix;
                    break;
                }
                this.value = suffix;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected type " + String.valueOf((Object)Type.INVALID));
            }
        }
    }

    public Type getType() {
        return this.type;
    }

    public boolean isDocumentRelativePath() {
        return this.type == Type.DOCUMENT_RELATIVE_PATH;
    }

    public boolean isClassLoaderRelativePath() {
        return this.type == Type.CLASSLOADER_RELATIVE_PATH;
    }

    public boolean isResourceKey() {
        return this.type == Type.RESOURCE_KEY;
    }

    public boolean isExpression() {
        return this.type == Type.EXPRESSION;
    }

    public boolean isBindingExpression() {
        return this.type == Type.BINDING_EXPRESSION;
    }

    public boolean isPlainString() {
        return this.type == Type.PLAIN_STRING;
    }

    public boolean isInvalid() {
        return this.type == Type.INVALID;
    }

    public String getSuffix() {
        return switch (this.type.ordinal()) {
            case 0 -> {
                if (!$assertionsDisabled && !this.value.startsWith("@")) {
                    throw new AssertionError();
                }
                String encoding = this.value.substring("@".length());
                yield PrefixedValue.decodePath(encoding).getPath();
            }
            case 1 -> {
                if (!$assertionsDisabled && !this.value.startsWith("@/")) {
                    throw new AssertionError();
                }
                String encoding = this.value.substring("@".length() + 1);
                yield PrefixedValue.decodePath(encoding).getPath();
            }
            case 2 -> {
                if (!$assertionsDisabled && !this.value.startsWith("%")) {
                    throw new AssertionError();
                }
                yield this.value.substring("%".length());
            }
            case 3 -> {
                if (!$assertionsDisabled && !this.value.startsWith("$")) {
                    throw new AssertionError();
                }
                yield this.value.substring("$".length());
            }
            case 4 -> {
                if (!$assertionsDisabled && !this.value.startsWith("${")) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && !this.value.endsWith("}")) {
                    throw new AssertionError();
                }
                yield this.value.substring("${".length() - "}".length());
            }
            case 5 -> {
                if (this.value.startsWith("\\")) {
                    yield this.value.substring("\\".length());
                }
                if (this.value.startsWith("@@")) {
                    yield this.value.substring("@".length());
                }
                if (this.value.startsWith("%%")) {
                    yield this.value.substring("%".length());
                }
                if (this.value.startsWith("$$")) {
                    yield this.value.substring("$".length());
                }
                yield this.value;
            }
            default -> null;
        };
    }

    public URL resolveDocumentRelativePath(URL document) {
        URL result;
        assert (document != null);
        assert (this.type == Type.DOCUMENT_RELATIVE_PATH);
        try {
            String path = this.value.substring("@".length());
            result = new URL(document, path);
        }
        catch (MalformedURLException x) {
            result = null;
        }
        return result;
    }

    public URL resolveClassLoaderRelativePath(ClassLoader classLoader) {
        assert (classLoader != null);
        assert (this.type == Type.CLASSLOADER_RELATIVE_PATH);
        assert (this.value.startsWith("@/"));
        String path = this.value.substring("@".length() + 1);
        return classLoader.getResource(path);
    }

    public String resolveResourceKey(ResourceBundle resources) {
        String result;
        assert (resources != null);
        assert (this.type == Type.RESOURCE_KEY);
        assert (this.value.startsWith("%"));
        try {
            String key = this.value.substring("%".length());
            result = resources.getString(key);
        }
        catch (MissingResourceException x) {
            result = null;
        }
        return result;
    }

    public static Type getPrefixedValueType(String prefixedValue) {
        String v = prefixedValue;
        Type result = v.startsWith("\\") ? ((v = v.substring("\\".length())).isEmpty() || !v.startsWith("\\") && !v.startsWith("@") && !v.startsWith("%") && !v.startsWith("$") && !v.startsWith("#{") ? Type.INVALID : Type.PLAIN_STRING) : (v.startsWith("@") ? ((v = v.substring("@".length())).isEmpty() ? Type.INVALID : (v.startsWith("@") ? Type.PLAIN_STRING : (v.charAt(0) == '/' ? Type.CLASSLOADER_RELATIVE_PATH : Type.DOCUMENT_RELATIVE_PATH))) : (v.startsWith("%") ? ((v = v.substring("%".length())).isEmpty() ? Type.INVALID : (v.startsWith("%") ? Type.PLAIN_STRING : Type.RESOURCE_KEY)) : (v.startsWith("${") ? ((v = v.substring("${".length())).isEmpty() || !v.endsWith("}") ? Type.INVALID : Type.BINDING_EXPRESSION) : (v.startsWith("$") ? ((v = v.substring("$".length())).isEmpty() ? Type.INVALID : (v.startsWith("$") ? Type.PLAIN_STRING : Type.EXPRESSION)) : Type.PLAIN_STRING))));
        return result;
    }

    public static PrefixedValue makePrefixedValue(URL assetURL, URL documentURL) {
        File documentFile;
        File assetFile;
        try {
            assetFile = new File(assetURL.toURI());
            documentFile = new File(documentURL.toURI());
        }
        catch (URISyntaxException x) {
            throw new IllegalArgumentException(x);
        }
        File parentFile = documentFile.getParentFile();
        if (parentFile == null || parentFile.equals(assetFile)) {
            throw new IllegalArgumentException(documentURL.toString());
        }
        Path relativePath = parentFile.toPath().relativize(assetFile.toPath());
        PrefixedValue result = new PrefixedValue(Type.DOCUMENT_RELATIVE_PATH, relativePath.toString());
        return result;
    }

    public String toString() {
        return this.value;
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + Objects.hashCode(this.getSuffix());
        hash = 97 * hash + Objects.hashCode((Object)this.type);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrefixedValue other = (PrefixedValue)obj;
        if (!Objects.equals(this.getSuffix(), other.getSuffix())) {
            return false;
        }
        return this.type == other.type;
    }

    private static String encodePath(File file) {
        String result;
        try {
            if (file.isAbsolute()) {
                result = file.toURI().toURL().getPath();
            } else {
                Path tmpPath = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
                String tmpPathEncoding = tmpPath.toFile().toURI().toURL().getPath();
                Path absolutePath = tmpPath.resolve(file.toPath());
                String absoluteEncoding = absolutePath.toFile().toURI().toURL().getPath();
                assert (absoluteEncoding.startsWith(tmpPathEncoding));
                result = absoluteEncoding.substring(tmpPathEncoding.length());
            }
        }
        catch (MalformedURLException x) {
            throw new IllegalStateException(x);
        }
        return result;
    }

    private static File decodePath(String encoding) {
        File result;
        try {
            if (encoding.startsWith("/")) {
                result = new File(new URI("file:" + encoding));
            } else {
                Path tmpPath = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
                URL tmpPathURL = tmpPath.toFile().toURI().toURL();
                URL absoluteURL = new URL(tmpPathURL.toString() + "/" + encoding);
                File absoluteFile = new File(absoluteURL.toURI());
                Path absolutePath = absoluteFile.toPath();
                assert (absolutePath.startsWith(tmpPath));
                Path relativePath = tmpPath.relativize(absolutePath);
                result = relativePath.toFile();
            }
            assert (encoding.equals(PrefixedValue.encodePath(result)));
        }
        catch (MalformedURLException | URISyntaxException x) {
            result = new File(encoding);
        }
        return result;
    }

    public static enum Type {
        DOCUMENT_RELATIVE_PATH,
        CLASSLOADER_RELATIVE_PATH,
        RESOURCE_KEY,
        EXPRESSION,
        BINDING_EXPRESSION,
        PLAIN_STRING,
        INVALID;

    }
}

