/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.preferences;

import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.MavenArtifact;
import com.oracle.javafx.scenebuilder.kit.preferences.PreferencesRecordArtifact;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MavenPreferences {
    private final Map<String, PreferencesRecordArtifact> recordArtifacts = new HashMap<String, PreferencesRecordArtifact>();

    public PreferencesRecordArtifact getRecordArtifact(String coordinates) {
        return this.recordArtifacts.get(coordinates);
    }

    public void addRecordArtifact(String key, PreferencesRecordArtifact object) {
        this.recordArtifacts.put(key, object);
    }

    public void removeRecordArtifact(String coordinates) {
        this.recordArtifacts.remove(coordinates);
    }

    private String getArtifactJarPath(MavenArtifact artifact) {
        return this.recordArtifacts.get(artifact.getCoordinates()).getPath();
    }

    private List<String> getArtifactJarDependencies(MavenArtifact artifact) {
        String dep = this.recordArtifacts.get(artifact.getCoordinates()).getMavenArtifact().getDependencies();
        if (dep != null && !dep.isEmpty()) {
            return Stream.of(dep.split(File.pathSeparator)).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    public File getArtifactFile(MavenArtifact artifact) {
        File file;
        String path = this.getArtifactJarPath(artifact);
        if (path != null && !path.isEmpty() && (file = new File(path)).exists()) {
            return file;
        }
        return null;
    }

    public List<File> getArtifactFileWithDependencies(MavenArtifact artifact) {
        String path = this.getArtifactJarPath(artifact);
        if (path != null && !path.isEmpty()) {
            ArrayList<File> jarPaths = new ArrayList<File>();
            jarPaths.add(this.getArtifactFile(artifact));
            jarPaths.addAll(this.getArtifactJarDependencies(artifact).stream().filter(d -> d != null && !d.isEmpty()).map(File::new).filter(File::exists).collect(Collectors.toList()));
            return jarPaths;
        }
        return null;
    }

    public List<String> getArtifactFilter(MavenArtifact artifact) {
        String filter = this.recordArtifacts.get(artifact.getCoordinates()).getMavenArtifact().getFilter();
        if (filter != null && !filter.isEmpty()) {
            return Stream.of(filter.split(File.pathSeparator)).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    private List<String> getArtifactsJarsPaths() {
        return this.recordArtifacts.values().stream().map(PreferencesRecordArtifact::getPath).distinct().collect(Collectors.toList());
    }

    private List<String> getArtifactsJarsDependencies() {
        return this.recordArtifacts.values().stream().map(p -> p.getMavenArtifact().getDependencies()).filter(d -> d != null && !d.isEmpty()).flatMap(d -> Stream.of(d.split(File.pathSeparator))).distinct().collect(Collectors.toList());
    }

    public List<File> getArtifactsFiles() {
        return this.getArtifactsJarsPaths().stream().filter(s -> s != null && !s.isEmpty()).map(File::new).filter(File::exists).collect(Collectors.toList());
    }

    public List<File> getArtifactsFilesWithDependencies() {
        List<String> jarsPaths = this.getArtifactsJarsPaths();
        jarsPaths.addAll(this.getArtifactsJarsDependencies());
        return jarsPaths.stream().filter(s -> s != null && !s.isEmpty()).map(File::new).filter(File::exists).collect(Collectors.toList());
    }

    public List<Path> getArtifactsPaths() {
        return this.getArtifactsFiles().stream().map(File::toPath).collect(Collectors.toList());
    }

    public List<Path> getArtifactsPathsWithDependencies() {
        return this.getArtifactsFilesWithDependencies().stream().map(File::toPath).collect(Collectors.toList());
    }

    public List<String> getArtifactsFilter() {
        return this.recordArtifacts.values().stream().map(p -> p.getMavenArtifact().getFilter()).filter(f -> f != null && !f.isEmpty()).flatMap(f -> Stream.of(f.split(File.pathSeparator))).distinct().collect(Collectors.toList());
    }

    public List<String> getArtifactsCoordinates() {
        return this.recordArtifacts.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toList());
    }
}

